/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GPLUGINSDK_H
#define GPLUGINSDK_H


/*--HEADERSTART--*/

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>

class QWidget;
class gPluginPainter;
class QImage;
class QDomNodeList;
class KPopupMenu;

const char KXDOCKER_VARTYPE_BOOL[] 	= "bool";
const char KXDOCKER_VARTYPE_PERCENT[] 	= "%";
const char KXDOCKER_VARTYPE_INT[] 	= "int";
const char KXDOCKER_VARTYPE_RANGE[] 	= "range";
const char KXDOCKER_VARTYPE_STRING[] 	= "string";
const char KXDOCKER_VARTYPE_ICON[]	= "icon";
const char KXDOCKER_VARTYPE_LIST[]	= "list";
const char KXDOCKER_VARTYPE_PATH[]	= "path";

/**
@author Stefano Zingarini
*/
class gPluginSDK : public QObject
{
Q_OBJECT
public:
    gPluginSDK(QObject *parent = 0, const char *name = 0);

    ~gPluginSDK();
    virtual QObject * Respawn(QObject *);

protected:
	void createXMLTree();
	void xPaintFX(int);
	int 			isStopped;
	int 			lastValue;
	int 			Value;
	int			ActiveConfigurationSizeOf;
	QString			ActiveConfigurationVersion;
	QString			IconsPath;
	QString			ToolTip;
	QString			ToolTip2;
	QString			LastToolTip2;
	QStringList		PluginInformations;
	int 			SizeBig;
	int			ImageFX_Y_degree;
	int			ImageFX_X_degree;
	int			ImageFX_GrayScale;
	int			ImageFX_Intensity;
	gPluginPainter		*ImageFX_Painter;
	QObject			*xGDocker;
	QObject			*xEConfigurator;
	void			*pActiveConfiguration;
	QObject			*xGIcon;
	QImage			*xImgSource;
	const QDomNodeList	*xXMLIconConfig;
	KPopupMenu		*PluginPopupMenu;
	QWidget 	*ConfigurationWindow;
public slots:
    virtual void xSetup();
    virtual void xRefreshIcon(QObject *);
    virtual void xStop();
    virtual void xStart();
    virtual void xAttach(QObject *);
    virtual void xApplyCfg();
    virtual void polling();
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xGetParameter(const QString, QString&);
    virtual void xGetInfo(QStringList &);
    virtual void xRunConfigurator();
    virtual void xEnabledClick(int &);
    virtual void xPaint(int);
    virtual void xEventClick(void *,int,int,int,int);
    virtual void xRefreshIconFromKXDocker(QObject *);
    virtual void xGetParameterType(const QString &, QString &);
    virtual void xContinue();
    virtual void xPause();
    virtual void xReAttach(QObject *);
public:
signals:
void cachePurge();
void xSetSmoothZoom();
void xDockerRedraw(QObject *);
void xGetDocker(QObject *&);
void xGetConfigurator(QObject *&);
void xSetText(const QString &);
void xGetImage(QImage *&);
void xGetPluginConfiguration(const QDomNodeList *&);
void xFindResource(const QString &, QString &);
void xGetPluginPopupMenu(KPopupMenu *&,const QObject *);
void xSetIconEXE(const QString &);
void xGetIconEXE(QString &);
void xGetIconImgFile(QString &);
void xGetIconName(QString &);
void xSetIconImgFile(const QString &);
void xSetIconName(const QString &);
void xSetOverText(const QString &);
void xGetConfigurationVersion(int &, QString &);
void xGetConfiguration(void *&,const QString, int);
void xGetConfigurationValue(const QString, int &);
void xGetConfigurationValue(const QString, QString &);
void xSetText(const QString &, int);
void xSetMiniText(const QString &);
void xSetTextManagedBy(int,int);
void xSetOverlayImage(int,int,const QString &);
void xSetOverlayImage(int,int,const QImage &);
void xSetOverlayImage(int,int,const QPixmap &);
void xStartStepping();
void xAskContinue(QObject *);
void xWMSetupParameter(const QString, const QString);
void xWMShow();
};

/*--HEADERSTOP--*/
#endif
