/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgpillowfake.h"
#include <kdebug.h>
#include <xgdocker.h>
#include <xgicon.h>
#include <xeconfiguration.h>
#include <xeobject.h>

#include <qtimer.h>
#include <krootpixmap.h>
#include <kapplication.h>
#include <dcopclient.h>
#include <kxdocker_setup_sources.h>


//#undef ENABLE_FINAL
	
#ifndef ENABLE_FINAL
extern void PrintaErroreLivello(const QString &,const QString &,int);
#endif


#include <X11/Xlib.h>


GC			pillow_gc;
XGCValues		*pillow_values;
XImage 			*pillow_xmask;
char *pillow_ColorBuffer=NULL;

/*
extern "C" QObject *xeplugin_register(QObject *parent)
{
	const char NOME[]="xPillow";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XGPillowFake(NULL,NOME));
}
*/
XGPillowFake::XGPillowFake(QWidget *, const char *name)
 : XEPlugin_GEPillow(NULL, name)
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("XGPillowFake(QWidget *, char *)").arg(name),"",1);
#endif
	if(name!=NULL)XEObject::xPluginAdd(this);
	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);
	KWin::setType(winId(), NET::Dock);
	KWin::setState( winId(), NET::StaysOnTop );
	// altre prove
	//KWin::setType(winId(), NET::Override);
	//NETWinInfo* info;
	//info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState );
	//info->setDesktop( NETWinInfo::OnAllDesktops);

	_timerHide=new QTimer();
	NegativeX=0;
	NegativeY=0;
	connect(_timerHide,SIGNAL(timeout()),this,SLOT(hideMe()));
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("XGPillowFake(QWidget *, char *)").arg(name),"",-1);
#endif
	img_Height=PILLOWMAXHEIGHT;

	pillow_values=new XGCValues;
	pillow_values->foreground = 0x00000000;	// default contectx colors
	pillow_values->background = 0x00000000;
	pillow_gc = XCreateGC (qt_xdisplay(), winId(), GCForeground | GCBackground, pillow_values); // drawing content

	pillow_xmask = XCreateImage(qt_xdisplay(),  DefaultVisual(qt_xdisplay(), 0), 32, ZPixmap, 0, NULL,
					QApplication::desktop()->width(), PILLOWMAXHEIGHT,
					32, 0);

}


XGPillowFake::~XGPillowFake()
{
}


#include "xgpillowfake.moc"


/*!
    \fn XGPillowFake::xSetupParameter(const QString, const QString)
 */
void XGPillowFake::xSetupParameter(const QString, const QString)
{
    /// @todo implement me
}


/*!
    \fn XGPillowFake::paintEvent( QPaintEvent *e)
 */
void XGPillowFake::paintEvent( QPaintEvent *e)
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("paintEvent( QPaintEvent *e)"),"",1);
#endif
	rect = e->rect();
	l=rect.left();
	t=rect.top();
	w=rect.width();
	h=rect.height();


	XPutImage(qt_xdisplay(), winId(),pillow_gc,
		pillow_xmask, l, t, 0, 0,
		w,h);

/*
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);
*/
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("paintEvent( QPaintEvent *e)"),"",-1);
#endif

}


/*!
    \fn XGPillowFake::xRefresh
 */
void XGPillowFake::xRefresh()
{
    /// @todo implement me
}


/*!
    \fn XGPillowFake::xStart
 */
void XGPillowFake::xStart()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("xStart()"),"",1);
#endif

	paintBuffer.create(
		QApplication::desktop()->width(),
		PILLOWMAXHEIGHT,
		32);
	paintBuffer.setAlphaBuffer(false);
	paintBuffer.fill(0);
	paintBuffer.setAlphaBuffer(true);


	resize(QApplication::desktop()->width(),PILLOWMAXHEIGHT);
	//show();
	KDesktopBackground->start();
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("xStart()"),"",-1);
#endif
}


/*!
    \fn XGPillowFake::xStop
 */
void XGPillowFake::xStop()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("xStop()"),"",0);
#endif
}


/*!
    \fn XGPillowFake::xSetup
 */
void XGPillowFake::xSetup()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("xSetup()"),"",1);
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();

	KDesktopBackground=new KRootPixmap((QWidget*)this);
	connect(KDesktopBackground, 
		SIGNAL(backgroundUpdated(const QPixmap &)), 
		this, SLOT(backgroundUpdated(const QPixmap &)));
	
	KDesktopBackground->setCustomPainting(true);

	connect(xGDocker,
	SIGNAL(xEventWidgetMoved(int,int,int,int,int,int)),
	this,
	SLOT(xEventWidgetMoved(int,int,int,int,int,int))
	);
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("xSetup()"),"",-1);
#endif

}


/*!
    \fn XGPillowFake::externalDrawPillow(QObject *,int,int)
 */
void XGPillowFake::externalDrawPillow(QObject *newIcon,int x,int y)
{
	//if(!isShown())return;
#ifndef ENABLE_FINAL
	kdWarning() << "void XGPillowFake::externalDrawPillow(QObject *newIcon,"<<x<<","<<y<<")\n";
#endif
	XGIcon *xGIcon=(XGIcon *)newIcon;
	//if(!xGIcon->isTextDrawed)xGIcon->xDrawText();
	//paintBuffer.fill(Qt::red);
	paintBuffer.setAlphaBuffer(false);
	paintBuffer.fill(0);
	paintBuffer.setAlphaBuffer(true);
	//_blendedText=xGIcon->xIconTextPillow.xGetPixmapText()->copy();
	_blendedText=xGIcon->xIconTextPillow.xImageText.copy();
	img_Height=_blendedText.height();
	//if(lastX!=x)Alpha=0.1;
	if(_alpha<=0.9)_alpha=_alpha+0.1;
#ifndef ENABLE_FINAL
	kdWarning() << "XGPillowFake::externalDrawPillow(QObject *newIcon,int x,int y) 189\n";
#endif

	bitBlt(&paintBuffer,
		NegativeX+x,
		y,
		setIntensity(_blendedText,_alpha),
				Qt::CopyROP);

	pillow_xmask->data=(char *)paintBuffer.bits();

	repaint(false);
#ifndef ENABLE_FINAL
	kdWarning() << "XGPillowFake::externalDrawPillow(QObject *newIcon,int x,int y) 201\n";
#endif
}


/*!
    \fn XGPillowFake::xGetInfo(QStringList &)
 */
void XGPillowFake::xGetInfo(QStringList &)
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("xGetInfo(QStringList &)"),"",0);
#endif
}


/*!
    \fn XGPillowFake::backgroundUpdated(const QPixmap &)
 */
void XGPillowFake::backgroundUpdated(const QPixmap &)
{
	//pixmapBackground=pb;
	//repaint(false);
#ifndef ENABLE_FINAL
	qWarning("void XGPillowFake::backgroundUpdated(const QPixmap &)");
#endif
}


/*!
    \fn XGPillowFake::xEventWidgetMoved(int,int,int , int , int,int)
 */
void XGPillowFake::xEventWidgetMoved(int x,int y,int , int , int,int)
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("xEventWidgetMoved()"),"",0);
#endif
	NegativeX=x;
	NegativeY=y;
	if(ActiveConfiguration->Window.Align=="bottom")
	{
		move(0,NegativeY-img_Height);
	}
	else
	{
		move(0,NegativeY+ActiveConfiguration->Window.Height);
	}
	
}


/*!
    \fn XGPillowFake::show()
 */
void XGPillowFake::show()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("show()"),"",0);
#endif
	//return;
	if(isShown() || img_Height<5)return;
	if(ActiveConfiguration->Window.Align=="bottom")
	{
		move(0,NegativeY-img_Height);
	}
	else
	{
		move(0,NegativeY+ActiveConfiguration->Window.Height);
	}

	resize(QApplication::desktop()->width(),img_Height);
	//paintBuffer.resize(QApplication::desktop()->width(),img_Height);


#ifndef ENABLE_FINAL
	qWarning("void XGPillowFake::show()");
#endif
	// we are going to be showed
	_alpha=0.1;

/*
	pixmapBackground=QPixmap::grabWindow(
		QApplication::desktop()->winId(),
		x(), y(),
		width(),
		height()
		);
	// 0.37 fix
	bitBlt(&paintBuffer,0,0,
				&pixmapBackground,
				Qt::CopyROP);
*/
	paintBuffer.create(
		width(),
		height(),
		32);
	paintBuffer.setAlphaBuffer(false);
	paintBuffer.fill(0);
	paintBuffer.setAlphaBuffer(true);


	KWin::setType(winId(), NET::Dock);
	QWidget::show();
	KWin::setType(winId(), NET::Dock);
	setUnShadowed();
	KWin::setOnAllDesktops(winId(),true);
	KWin::setState( winId(), NET::StaysOnTop );
	raise();
	// TODO: bad workaround
	_timerHide->start(1000);
}


/*!
    \fn XGPillowFake::hide()
 */
void XGPillowFake::hide()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("hide()"),"",0);
#endif
//	lower();
	//KWin::setState( winId(), NET::KeepBelow);
	if(isShown())QWidget::hide();
}


/*!
    \fn XGPillowFake::setUnShadowed()
 */
inline void XGPillowFake::setUnShadowed()
{
return;
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("setUnShadowed()"),"",0);
#endif
       QByteArray data2;
        QDataStream arg2(data2, IO_WriteOnly);
        //arg2 << topLevelWidget()->winId();
	arg2 << winId();
        kapp->dcopClient()->send(
           "kwin",
           "KWinInterface",
           "setUnshadowed(unsigned long int)"
           ,data2);
}



/*!
    \fn XGPillowFake::hideMe()
 */
void XGPillowFake::hideMe()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("hideMe()"),"",1);
#endif

	if(!xGDocker->getRaised())
	{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("hideMe()"),"334",1);
#endif
		hide();
		_timerHide->stop();
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("hideMe()"),"334",-1);
#endif
	}
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("hideMe()"),"",-1);
#endif
}
