/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgdockerfake.h"
#include "xeobject.h"
#include <kdebug.h>
#include <qtimer.h>
#include <qmutex.h>
#include <qdatetime.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qpixmap.h>
#include <sys/times.h>
#include <kiconloader.h>
#include <kpixmapio.h>
#include <qevent.h>
#include <qdragobject.h> 
#include <qsizepolicy.h>
#include <qtimer.h>
#include <qpainter.h> 
#include <qimage.h>
#include <qdatetime.h> 
#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qfont.h>
#include <qcolor.h>
#include <krootpixmap.h>
#include <ksharedpixmap.h>
#include <dcopclient.h>
#include <xeplugin_gepillow.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kmainwindow.h>
#include <kicontheme.h>
#include <kwin.h>
#include <kmainwindow.h>
#include <kpopupmenu.h>
#include <kapplication.h>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <kimageeffect.h>
#include <kpixmapeffect.h>
#include <netwm.h>
#include <xematrix.h>
#include <xgpillowfake.h>

#define		LONBOTTOM	0
#define		LONTOP		1
#define		LONLEFT		2
#define		LONRIGHT	3

//#undef ENABLE_FINAL

#ifndef ENABLE_FINAL

void PrintaErroreLivello(const QString &f,const QString &errore,int sommatore)
{
	static int livello=0;
	if(sommatore>0)livello=livello+sommatore;
	QString Stringa=QString("[%1]").arg(livello);
	
	for(int i=0;i<livello;i++)
	{
		Stringa=Stringa+"-";
	}
	kdWarning() <<Stringa<<f<<" "<<errore<<"\n";
	if(sommatore<0)livello=livello+sommatore;
}
#endif
GC			gc;
XImage 			*xmask=NULL;
XImage 			*xmaskSingle=NULL;
//char *ColorBuffer=NULL;

extern "C" QObject *xeplugin_register(QObject *)
{
	const char NOME[]="xGDocker";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XGDockerFake(NULL,NOME));
}


XGDockerFake::XGDockerFake(QWidget *parent, const char *name)
 : XGDocker(parent, name
	//,
	//WStyle_StaysOnTop
	//|   WStyle_Customize |
	//| WDestructiveClose
	//  |Qt::WState_OwnSizePolicy


	// rimosse
	//WRepaintNoErase
	//| WStyle_NoBorder
  )

{
	// Registration is done by XGDockerFake
	// re-set all var
	xMakeWidgetCenterDeltaX=0;
	//fakeHeightDesktop=0;
	mayRequireDoChangeBackground=0;
	//alternativeHeightDesktop=0;
	isDropping=0;
	isDragging=0;
	hasDragged=-1;
	lastActionis=0;
	AxisAreInverted=1;
	backgroundBarAniFrame=0;
	lastDesaturate=Desaturate=0;
	maxDesaturate=0;
	isLowering=0;
	Busy=NULL;
	cacheBusy=NULL;
	p1=NULL;
	p2=NULL;
	mouseMoveTimeElapsed=NULL;
	polling=NULL;
	tMouseMoved=NULL;
	tAutoHideTimer=NULL;
	tPostIconAdd=NULL;
//	tPostShowRaise=NULL;
	tAutoSendBGTimer=NULL;
	tAnimateBackground=NULL;
	ActiveConfiguration=NULL;
	Matrix=NULL;
	lastIconDrag=NULL;
	Busy=NULL;
	cacheBusy=NULL;
	PixmapConverter=NULL;
	KDEIconLoader=NULL;
	// end

	for(uint i=0; i< MAX_ICONS;i++)activeIcons[i]=NULL;
	activeIconsCounter=0;
	// Draw issue
	if(parent)
	{
		// Warning this widget cannot be parented
	}
	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);
	// compiz
	KWin::setType(winId(), NET::Dock);
	KWin::setState( winId(), NET::StaysOnTop );
	// altre prove
	//KWin::setType(winId(), NET::Override);
	NETWinInfo* info;
	info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState );
	info->setDesktop( NETWinInfo::OnAllDesktops);
	//setFocusPolicy(QWidget::StrongFocus);
	//setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
	
	setMouseTracking (true);
	setAcceptDrops(true);
	xReset();

	//move(QApplication::desktop()->width()+10,QApplication::desktop()->height()+10);
	pattern = ("DESKTOP%1");
	int screen_number = DefaultScreen(qt_xdisplay());
	if (screen_number) {
		pattern = QString("SCREEN%1-DESKTOP").arg(screen_number) + "%1";
	}

	// Plugin engine registration
	// done by base
	//XEObject::xSetEngineDocker(this);
	//if(name!=NULL)XEObject::xPluginAdd(this);

	XGCValues		*values;
	values=new XGCValues;
	values->foreground = 0x00000000;	// default contectx colors
	values->background = 0x00000000;
	gc = XCreateGC (qt_xdisplay(), winId(), GCForeground | GCBackground, values); // drawing content
	delete values;
	values=NULL;
}


XGDockerFake::~XGDockerFake()
{
	xStop();
	XEObject::xPluginDel(this);
}


#include "xgdockerfake.moc"


/*!
    \fn XGDockerFake::xCfgChanged(QObject *XECfgObject)
 */
void XGDockerFake::xCfgChanged(QObject *XECfgObject)
{
	// We are going to get the new conf from configurator
	XEConfiguration *NewConfigurator=(XEConfiguration *)XECfgObject;
	if(NewConfigurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("falling back to ActiveConfiguration\n");
#endif
		// return;
	}
	else
	{
		ActiveConfiguration=NewConfigurator->xGetConfiguration();
	}
	if(ActiveConfiguration==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("error while searching for configuration data\n");
#endif
		return;
	}
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("appling new configuration\n");
#endif
	
	/// @todo Dont do Resize
	applyCfg();
}


/*!
    \fn XGDockerFake::xReset()
 */
void XGDockerFake::xReset()
{
	// Reset all data
	LayoutPosition=LONBOTTOM;
	AxisAreInverted=1;
	ActiveConfiguration=NULL;
	lastButtonStatus=Qt::NoButton;
	lastIconDrag=NULL;
	req.tv_nsec=0;
	req.tv_sec=0;
	//lastRaise=2;
	isRaised=0;
	isAnimating=0;
	lastRaise=0;
	xLastX=-1000;
	xLastY=-1000;
	xLastX_real=xLastX;
	xLastY_real=xLastY;
#ifdef ENABLE_SPECIALENGINE2
	xLastX_notmanaged=xLastX;
	xLastY_notmanaged=xLastY;
#endif

	isAnimating=0;
	xDesignVirtualYMatrix=0;
	lastRaise=0;
	lastIcon=0;
	lastIconActivated=0;
	RefreshMask=0;
	if(Busy==NULL)Busy=new QMutex();
	if(cacheBusy==NULL)cacheBusy=new QMutex();
	if(PixmapConverter==NULL)PixmapConverter=new KPixmapIO();
	if(KDEIconLoader==NULL)KDEIconLoader=new KIconLoader();


	if(polling==NULL)
	{
		polling=new QTimer();
		connect(polling,
		SIGNAL(timeout()),
		this, SLOT(xStep()));
	}
	/*
	if(KDesktopBackground==NULL)
	{
		KDesktopBackground=new KRootPixmap((QWidget*)this);
		connect(KDesktopBackground, 
		SIGNAL(backgroundUpdated(const QPixmap &)), 
		this, SLOT(backgroundUpdatedbyKDE(const QPixmap &)));
		KDesktopBackground->setCustomPainting(true);
	}
	if(m_pPixmap==NULL)
	{
		m_pPixmap=new KSharedPixmap;
		 connect(m_pPixmap, SIGNAL(done(bool)),this, SLOT(backgroundPostDone(bool)));

	}
*/
	if(tMouseMoved==NULL)
	{
		tMouseMoved=new QTimer(this);
		connect(tMouseMoved,SIGNAL(timeout()),this,SLOT(xIRQ_MouseTimeout()));
	}

	if(tAnimateBackground==NULL)
	{
		tAnimateBackground=new QTimer(this);
		connect(tAnimateBackground,SIGNAL(timeout()),this,SLOT(backgroundCicle()));
	}

	if(tAutoHideTimer==NULL)
	{
		tAutoHideTimer=new QTimer(this);
		connect(tAutoHideTimer,SIGNAL(timeout()),
			this,SLOT(xHide()));
	}

	if(tPostIconAdd==NULL)
	{
		tPostIconAdd=new QTimer(this);
		connect(tPostIconAdd,SIGNAL(timeout()),
			this,SLOT(xEventTaskAppendPost()));
	}
	if(tAutoSendBGTimer==NULL)
	{
		tAutoSendBGTimer=new QTimer(this);
		connect(tAutoSendBGTimer,SIGNAL(timeout()),
			this,SLOT(xSendToBackground()));
	}
/*
	if(tPostShowRaise==NULL)
	{
		tPostShowRaise=new QTimer(this);
		connect(tPostShowRaise,SIGNAL(timeout()),
			this,SLOT(showRaisePost()));
	}
*/
	
}


/*!
    \fn XGDockerFake::xSetup()
 */
void XGDockerFake::xSetup()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::xSetup()\n");
#endif
	// Query for last configuration
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("error while searching for plugin Configurator\n");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	
	Matrix=(XEMatrix *)XEObject::xGetMatrix();
	if(Matrix==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("error while searching for plugin Matrix\n");
#endif
		return;
	}

	// 0.40 new Event engine
	connect(Configurator, SIGNAL(xEventReloadIcon(int)),this,SLOT(xEventReloadIcon(int)));
	connect(Configurator, SIGNAL(xEventRemovedIcon(int)),this,SLOT(xEventRemovedIcon(int)));

	
	applyCfg();
	//lastRaise=1;
	//isRaised=0;
	//xUpdate(0,0);
	//(maskBackground);
	//polish();
	// 0.26 Apply xSetup on all modules Icons
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		activeIcons[iconIndex]->xSetupClass();
	}
}


/*!
    \fn XGDockerFake::xStart()
 */
void XGDockerFake::xStart()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("xStart()\n");
#endif
#ifdef ENABLE_STATS
	//0.36 TODO!
	ActiveConfiguration->Statistics.dockerStarts++;
	if(ActiveConfiguration->Statistics.dockerFirstStart==0)
	{
		ActiveConfiguration->Statistics.dockerFirstStart=(int)QDateTime::currentDateTime().toTime_t();
	}
	QDateTime tempo=QDateTime::currentDateTime();
	tempo=tempo.addDays(-ActiveConfiguration->Statistics.dockerDaysRunning);
	tempo=tempo.addSecs(-ActiveConfiguration->Statistics.dockerHoursRunning*60*60
		-ActiveConfiguration->Statistics.dockerMinutesRunning*60
		-ActiveConfiguration->Statistics.dockerSecondsRunning);

	ActiveConfiguration->Statistics.lastStart=tempo.toTime_t();

#endif


	Busy->unlock();
	
	//xUpdate();
	//xEventShowRaised();
	// 0.27
	//move(QApplication::desktop()->width()+10,QApplication::desktop()->height()+10);
	//qWarning(QString("Size:[%1][%1]").arg(ActiveConfiguration->Window.Width).arg(ActiveConfiguration->Window.Height));
	//setFixedSize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height);
	resize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height);
	
	xMoveWidgetCenter();
	checkBackgroundSeparators();
	//backgroundCicle();
	// 0.26 Apply xStart on all modules Icons
	// 0.38 moved to addIcon
	/*
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		activeIcons[iconIndex]->xStartClass();
	}
	*/
	xUpdateMatrix();
	mayRequireDoChangeBackground=1;
	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(5000);

	QTimer::singleShot(5000,this,SLOT(xPostStart()));

}

/*!
    \fn XGDockerFake::xPostStart()
 */
void XGDockerFake::xPostStart()
{
//	xUpdate();
//	repaint(true);
	//show();
	xEventShowRaised();
	//x11SetFloating(winId());
	//QTimer::singleShot(500,this,SLOT(xSendToBackground()));
}


/*!
    \fn XGDockerFake::xStop()
 */
void XGDockerFake::xStop()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("xStop()\n");
#endif
	hide();
	//KDesktopBackground->stop();
	//releaseMouse();

}

/*!
    \fn XGDockerFake::mouseMoveEvent( QMouseEvent *e )
 */
void XGDockerFake::mouseMoveEvent( QMouseEvent *e )
{
#ifdef ENABLE_SPECIALENGINE2
#ifndef ENABLE_FINAL
	//qWarning("Engine2: 276");
#endif

	// compiz without mask test
	//int y=e->pos().y();
	//if(!isRaised && y < yBar)return;


	if(isDragging>0 && lastButtonStatus!=Qt::NoButton)
	{
		//kdWarning()<<QString("void XGDockerFake::mouseMoveEvent() [%1][%1][%1]\n").arg(isDragging).arg(e->pos().x()).arg(e->pos().y());
		isDragging++;
		// work around this does not work
		//if(isDragging>ActiveConfiguration->Icons.Size)
		if(isDragging>2)
		{
			startDrag();
			//isDragging=0;
		}
	}
	if(cacheBusy->tryLock()==false)return;
	{

		

	/*
	xLastX_notmanaged=x;
	xLastY_notmanaged=y;
	*/
#ifndef ENABLE_FINAL
		//qWarning("QTimer::singleShot(1,this,SLOT(purgeCacheMovements()));");
#endif
//		QTimer::singleShot(1,this,SLOT(purgeCacheMovements()));

		// 0.27
		// stop all timers
		//tMouseMoved;
		tAutoHideTimer->stop();
		//tPostIconAdd;
		//tPostShowRaise->stop();
		tAutoSendBGTimer->stop();

/*
		// 0.40 if(ActiveConfiguration->Window.SendToBackground)
		if(ActiveConfiguration->Window.RaiseOnEvents)
		{
			//0.28
			if(ActiveConfiguration->Window.FastHide)
			{
				
			}
			else

			{
				if(
#ifdef USE_KWIN
					KWin::windowInfo(winId()).state()==NET::StaysOnTop
					||
					windowState()==Qt::WindowActive
#else
					//windowState()==Qt::WindowActive
					x11getOnTop(winId())
					||
					windowState()==Qt::WindowActive
#endif
					)
				{
					//qWarning("Already ontop");
				}
				else
				{

				}
			}
		}
*/
		isAnimating=1;
		if(!isRaised)
		{
			xLastX=e->pos().x();

//			NETRootInfo *RootInfo=new NETRootInfo(qt_xdisplay(),qt_xrootwin(), "DockApp",NULL,0,0,false);
//			RootInfo->restackRequest(winId(),topLevelWidget()->winId(),0);
//x11SetOnTop(winId());
			//raise();
			//KWin::setState( winId(),NET::KeepAbove );
			//qWarning("KWin::setState( winId(),NET::KeepAbove );");

		}
		else
		{
		}
		purgeCacheMovements();
	}
	return;
#endif
}


/*!
    \fn XGDockerFake::xUpdate(int EnableTransparency=0)
 */
void XGDockerFake::xUpdate(int Transparency, int pass)
{
	// CleanUP code PASS 1 (20040404)
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)\n").arg(Transparency).arg(pass),"",1);
#endif

	// Ok is software call ?
	// like the Smoothing past engine?
	if(pass==0)
	{
		// with composite this will grab the mouse!
		xUpdatePart1(Transparency,pass);
	}
	else
	{
/*
		switch(Transparency)
		{
			case 1:
// compiz: 			AfterTransparency=imgFakeBackgroundGlobal;
// compiz: 			imgFakeBackgroundAfterTransparency.detach();
			// this will kreate a plain transparent window
// compiz: 			imgFakeBackgroundGlobal.setAlphaBuffer(false);
// compiz: 			imgFakeBackgroundGlobal.fill(0);
// compiz: 			imgFakeBackgroundGlobal.setAlphaBuffer(true);
			break;
			case 2:
// compiz: 			imgFakeBackgroundGlobal=imgFakeBackgroundAfterTransparency;
			break;
		}
*/
	}
	paintBuffer.setAlphaBuffer(false);
	paintBuffer.fill(0);
	paintBuffer.setAlphaBuffer(true);



	//xUpdate(1,1);

	//nanosleep(&req,&rem);
	xUpdateDrawBackground(Transparency);
	// Painting the FAKE WINDOW!!!!

	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
	/*
		if(activeIcons[iconIndex].xSetUpdate>0)
		{
			//activeIcons[iconIndex].imgShowed=activeIcons[iconIndex].imgSource;
			activeIcons[iconIndex].xTransparency=
				activeIcons[iconIndex].xImgShowed.createAlphaMask();;

			//RefreshMask=1;
		}
	*/
#ifndef ENABLE_FINAL
		kdWarning() << (QString("activeIcons[%1][%1][%1][%1]\n").arg(iconIndex).arg(activeIcons[iconIndex]->xPosition.x()).arg(activeIcons[iconIndex]->xPosition.y()).arg(activeIcons[iconIndex]->xZoom));
#endif
		// 0.37
		if(!activeIcons[iconIndex]->hidden)
		{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"654",0);
#endif
			bitBlt(&paintBuffer,
				activeIcons[iconIndex]->xPosition.x(),
				activeIcons[iconIndex]->xPosition.y(),
				&activeIcons[iconIndex]->xImgShowed,0,Qt::CopyROP);
		}
		else
		{
			// check if there is an external window
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"652",0);
#endif

			if(activeIcons[iconIndex]->wExternal!=NULL)
			{
				activeIcons[iconIndex]->wExternal->move(
				activeIcons[iconIndex]->xPosition.x()+x(),
				activeIcons[iconIndex]->xPosition.y()+y()
					);
				activeIcons[iconIndex]->wExternal->resize(
				activeIcons[iconIndex]->xZoom,
				activeIcons[iconIndex]->xZoom
					);
			}
			else
			{
				if(activeIcons[iconIndex]->iExternal!=0)
				{
////qWarning("hippo");
/*
NETRootInfo *RootInfo=new NETRootInfo(qt_xdisplay(),qt_xrootwin(), "DockApp",NULL,0,0,false);
RootInfo->moveResizeWindowRequest(activeIcons[iconIndex]->iExternal,0,
				activeIcons[iconIndex]->xPosition.x()+x(),
				activeIcons[iconIndex]->xPosition.y()+y(),
				activeIcons[iconIndex]->xZoom,
				activeIcons[iconIndex]->xZoom);
*/
//(Window window, int flags, int x, int y, int width, int height )
/*
NETRootInfo rootinfo( qt_xdisplay(), NET::WMMoveResize);
rootinfo.moveResizeRequest(activeIcons[iconIndex]->iExternal,
				activeIcons[iconIndex]->xPosition.x()+x(),
				activeIcons[iconIndex]->xPosition.y()+y(),
                                //NET::TopLeft|
				//NET::Move
				//NET::TopLeft
				//|NET::Move
				);
*/
NETRootInfo rootinfo( qt_xdisplay(), NET::WM2MoveResizeWindow);//NET::WMMoveResize);
rootinfo.moveResizeWindowRequest(activeIcons[iconIndex]->iExternal,
				NET::TopLeft
				| 1<<8 |1<<9
				,
				//NET::Move,
				activeIcons[iconIndex]->xPosition.x()+x()-ActiveConfiguration->Icons.Size/2+activeIcons[iconIndex]->xZoom/2,
				activeIcons[iconIndex]->xPosition.y()+y()-ActiveConfiguration->Icons.Size/2+activeIcons[iconIndex]->xZoom/2,
				ActiveConfiguration->Icons.Size,
				ActiveConfiguration->Icons.Size
				);
				//activeIcons[iconIndex]->xZoom,
				//activeIcons[iconIndex]->xZoom);
/*
 NETWinInfo info( qt_xdisplay(), activeIcons[iconIndex]->iExternal, activeIcons[iconIndex]->iExternal,0);//qt_xrootwin(), 0 );
    NETStrut strut;
    strut.left = activeIcons[iconIndex]->xPosition.x()+x();
    strut.right =activeIcons[iconIndex]->xPosition.y()+y() ;
    strut.top = activeIcons[iconIndex]->xZoom;
    strut.bottom = activeIcons[iconIndex]->xZoom;
    info.setStrut( strut );
*/
/*
NETWinInfo* info;
info = new NETWinInfo( qt_xdisplay(), activeIcons[iconIndex]->iExternal, qt_xrootwin(), NET::WMState );
info->
*/

/*
moveResizeWindow(Window window, int flags, int x, int y, int width, int height) { Q_UNUSED(window); Q_UNUSED(flags); Q_UNUSED(x); Q_UNUSED(y); Q_UNUSED(width); Q_UNUSED(height); }
*/
				}
			}
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"725",0);
#endif

		}
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"743",0);
#endif

		// Drawing arrow
		// TODO: we are polling status of icon from configuration data it may be null
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.TaskInfo!=NULL ||ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.dcopReady
		||ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.forceRunning
		)
		{
			
			bitBlt(&paintBuffer,
				activeIcons[iconIndex]->xPosition.x()
				+activeIcons[iconIndex]->xZoom/2
				-ActiveConfiguration->Icons.Size/2-8,
				activeIcons[iconIndex]->xPosDefault.y()
				-8,
				&activeIcons[iconIndex]->xImgArrow,0,Qt::CopyROP);
		}
		// 0.36 with miniText
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"745",0);
#endif
		xUpdateRepaintMiniTextInline(iconIndex,paintBuffer,activeIcons[iconIndex]->xPosition.x(),0);



		// 0.31
		// draw overtext
		/*
		if(lastIcon==iconIndex)
		{
			if(!isAnimating)xDrawPillow();
		}
		*/
	}

#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"762",0);
#endif

	/*
	if(RefreshMask>0)
	{
		maskBuffer.fill(Qt::color0);
		
		
		for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
		{

		bitBlt(&maskBuffer,
			activeIcons[iconIndex]->xPosition.x(),
			activeIcons[iconIndex]->xPosition.y(),
			//&activeIcons[iconIndex].xTransparency,0,Qt::CopyROP);
			&activeIcons[iconIndex]->xTransparency,0,Qt::AndROP);

		}
		// Fake Desktop Patch 02162004 _rev 2
		bitBlt(&maskBuffer,
			0,
			ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop,
			&this->fakeDesktop,0,Qt::CopyROP);
		//setMask(maskBuffer);
		//setMask(newFakeDesktop);
		//qApp->syncX();
		RefreshMask=0;
	}
	*/
	xDrawPillow2();

#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"780",0);
#endif

	xUpdateDrawBackgroundPass2();

#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdate(int %1, int %1)").arg(Transparency).arg(pass),"",-1);
#endif
}


/*!
    \fn XGDockerFake::paintEvent( QPaintEvent *e)
 */
void XGDockerFake::paintEvent( QPaintEvent *e)
{
#ifndef ENABLE_FINAL
	//kdWarning() << ("void XGDockerFake::paintEvent( QPaintEvent *e)");
#endif
	rect = e->rect();
	l=rect.left();
	t=rect.top();
	w=rect.width();
	h=rect.height();

/*
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);
*/
	// paint only the docker into paintBuffer
	
	int len=ActiveConfiguration->Window.Width * ActiveConfiguration->Window.Height *sizeof(unsigned int);
	static int lastLen=0;
	if(lastLen!=len)
	{
/*		if(ColorBuffer==NULL)
		{
		}
		else
		{
			delete ColorBuffer;
		}
		ColorBuffer=new char[len];
*/
		lastLen=len;
	xmask = XCreateImage(qt_xdisplay(),  DefaultVisual(qt_xdisplay(), 0), 32, ZPixmap, 0, NULL,
					ActiveConfiguration->Window.Width, ActiveConfiguration->Window.Height,
					32, 0);
	}
/*
	long pixelIndex=0;
	for(uint x=0;x<ActiveConfiguration->Window.Height;x++)
	{
		uint *riga=(uint *)paintBuffer.scanLine(x);
		for(uint y=0;y<ActiveConfiguration->Window.Width;y++)
		{
			uint *p =  (uint *)riga+y;
			ColorBuffer[pixelIndex++]=qBlue(*p);
			ColorBuffer[pixelIndex++]=qGreen(*p);
			ColorBuffer[pixelIndex++]=qRed(*p);
			ColorBuffer[pixelIndex++]=qAlpha(*p);
		}
	}
*/
	//xUpdate(1,1);
	xmask->data=(char *)paintBuffer.bits();
	XPutImage(qt_xdisplay(), winId(),gc,
		xmask, l, t, l, t,
		w,h);



	//bitBlt(this,0,0,&paintBuffer,0,Qt::CopyROP);
/*
// [Fill the destination widget/pixmap with whatever you want to use as a background here]

Display *dpy = QPaintDevice::x11AppDisplay();
XRenderPictureAttributes pa;
pa.subwindow_mode = IncludeInferiors; // Don't clip child widgets
// We need to find out some things about the window, such as it's size, it's position
// on the screen, and the format of the pixel data
XWindowAttributes attr;
XGetWindowAttributes( dpy, winId(), &attr );
XRenderPictFormat *format = XRenderFindVisualFormat( dpy, attr.visual );
bool hasAlpha             = ( format->type == PictTypeDirect && format->direct.alphaMask );
int x                     = attr.x;
int y                     = attr.y;
int width                 = attr.width;
int height                = attr.height;


Picture picture = XRenderCreatePicture( dpy, winId (), format, CPSubwindowMode, &pa );
XRenderComposite( dpy, hasAlpha ? PictOpOver : PictOpSrc, picture, None,
                x11RenderHandle(), 0, 0, 0, 0, 0, 0, width, height );
*/
/*
Display *dpy = QPaintDevice::x11AppDisplay();
XRenderPictureAttributes pa;
pa.subwindow_mode = IncludeInferiors; // Don't clip child widgets
// We need to find out some things about the window, such as it's size, it's position
// on the screen, and the format of the pixel data
XWindowAttributes attr;
XGetWindowAttributes( dpy, winId(), &attr );
XRenderPictFormat *format = XRenderFindVisualFormat( dpy, attr.visual );
bool hasAlpha             = ( format->type == PictTypeDirect && format->direct.alphaMask );
int x                     = attr.x;
int y                     = attr.y;
int width                 = attr.width;
int height                = attr.height;
// Create a copy of the bounding region for the window
XserverRegion region = XFixesCreateRegionFromWindow( dpy, winId (), WindowRegionBounding );

// The region is relative to the screen, not the window, so we need to offset
// it with the windows position
XFixesTranslateRegion( dpy, region, -x, -y );
XFixesSetPictureClipRegion( dpy,0, 0, 0, region );
XFixesDestroyRegion( dpy, region );
*/
}


/*!
    \fn XGDockerFake::applyCfg()
 */
void XGDockerFake::applyCfg()
{
	req.tv_nsec=ActiveConfiguration->Engine.SleepFPS*1000;
	req.tv_sec=0;

	
	req2.tv_nsec=1000*1000;
	//(ActiveConfiguration->Engine.SleepThreads/100)*1000;
	//if(req2.tv_nsec<1)req2.tv_nsec=1;
	req2.tv_sec=0;

#ifndef ENABLE_FINAL
	// Emits Signal of warning
	char pippo[50];
	sprintf(pippo,"configuration ready w:%d h:%d top:%d left:%d actual w:%d, h:%d\n",
			ActiveConfiguration->Window.Width,
			ActiveConfiguration->Window.Height,
			ActiveConfiguration->Window.Top,
			ActiveConfiguration->Window.Left,
			width(),
			height()
		);
	kdWarning() << (pippo);
	
#endif
	
	xRecalibrate();

	// Load - Reload Icons
	if(activeIconsCounter>0)// && activeIcons!=NULL)
	{
		#ifndef ENABLE_FINAL
			kdWarning() << ("destroy old icons\n");	
		#endif
		// Destroy old icons
		for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
		{
			if(activeIcons[iconIndex]==NULL)continue;
			delete activeIcons[iconIndex];
		}	
		activeIconsCounter=0;
	}
	
		// Loading defaults icons
		//XGIcon::ActiveConfiguration=ActiveConfiguration;
		for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
		{
			if(iconIndex>MAX_ICONS)break;
			iconAdd(ActiveConfiguration->ObjectsIcons.at(iconIndex));
			// 0.38
			// moving this code to iconAdd
			/*
			if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className!="GIcon")
			{
				// 0.31
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
				{
					// it's a separator:
					// disable the Y and other factors
					// 0.31
					activeIcons[iconIndex]->xExclude=1;
					// Than we check for a right png configuration
					// is done on 
					//changeBackground(ActiveConfiguration->Theme.BackgroundPath);
					//updateBackgroundSeparator(iconIndex);
				}
#ifndef ENABLE_FINAL
	//qWarning("XEObject::xFindObject(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);");
	//qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);
#endif
	QObject *GClass=XEObject::xFindObject(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);
				if(GClass==NULL)continue;
#ifndef ENABLE_FINAL
			//qWarning("xgdocker.cpp:637");
			//qWarning("activeIcons[activeIconsCounter-1]->xSetClass(GClass);");
#endif
				// 0.31
				//activeIcons[activeIconsCounter-1]->xSetClass(GClass);
				activeIcons[iconIndex]->xSetClass(GClass);
			}
			*/



#ifndef ENABLE_FINAL
			//qWarning("xgdocker.cpp:591");
#endif
		}
		
	// New Engine with separators 11 May 2004
	// Creating the Background must be done at end
#ifndef ENABLE_FINAL
			//qWarning("xgdocker.cpp:856");
#endif	
	//0.31
	//ok
	xChangeBackground(ActiveConfiguration->Theme.BackgroundPath);
#ifndef ENABLE_FINAL
	//qWarning("xgdocker.cpp:598");
#endif
	xDesignVirtualYMatrix=activeIcons[0]->xHotspot.y();
	
#ifndef ENABLE_FINAL
	//qWarning("xgdocker.cpp:601");
#endif
	QString PoofName=ActiveConfiguration->Theme.PoofPath;
	PoofName=PoofName+"/poof.png";

	QFile a(::locate("data",PoofName));
	if(!a.exists() || PoofName==QString::null)
	{
		PoofName="kxdocker/themes/poof/poof.png";
	}
	ActiveConfiguration->Theme.Poof.load(::locate("data",PoofName));
	
	// patch for external pillow
	xPillow=(XEPlugin_GEPillow *)XEObject::xFindObject("xPillow");
	// 0.40 libKXDockerFake.so bundle the pillow and the docker for X11
	//if(xPillow==NULL)xPillow=new XEPlugin_GEPillow();
	if(xPillow==NULL)
	{
		QString pClassName="xPillow";
		xPillow=new XGPillowFake(NULL,pClassName);
		connect(this,SIGNAL(xSetup(const QString &)),XEObject::xGetRoot(), SLOT(xSetupThis(const QString &)));
		connect(this,SIGNAL(xStart(const QString &)),XEObject::xGetRoot(), SLOT(xStartThis(const QString &)));
		xSetup(pClassName);
		xStart(pClassName);
		disconnect(SIGNAL(xStart(const QString &)));
		disconnect(SIGNAL(xSetup(const QString &)));
	}
	
	// 0.27
	// polish();
}





/*!
    \fn XGDockerFake::xIRQ_MouseTimeout()
 */
void XGDockerFake::xIRQ_MouseTimeout()
{
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","",1);
#endif
	//lower();
	tMouseMoved->stop();
	tAutoHideTimer->stop();
	// 0.27
	//tAutoSendBGTimer->stop();
	//tDrawPillow->stop();
	//isRaised=0;
	//setMask(maskBuffer);
	//releaseMouse();
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1135",0);
#endif
	
	xUpdateSmooth();

	if(lastIconActivated!=lastIcon)
	{
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1143",1);
#endif

		if(lastIconActivated>=0&& lastIconActivated<(int)activeIconsCounter)
		{
			activeIcons[lastIconActivated]->xStopAnimating();
			// 0.39 clear cache, for highlights
			activeIcons[lastIconActivated]->cachePurge();
		}
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1143",-1);
#endif
	}
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1157",0);
#endif

	if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
	{
		lastIconActivated=lastIcon;


if(isRaised)
{


		//activeIcons[lastIcon]->xSetIntensity(0.1);
		// 0-39
		xEventHighlightIcon(lastIcon,activeIcons[lastIcon]);
		activeIcons[lastIcon]->xStartAnimating();
		/*
		bitBlt(&paintBuffer,activeIcons[lastIcon]->xPosition.x()+
			activeIcons[lastIcon]->xZoom/2
			-
			activeIcons[lastIcon]->xImgDrop.width()/2
			,
			activeIcons[lastIcon]->xPosition.x()
			,&activeIcons[lastIcon]->xImgDrop,
			0,
			Qt::CopyROP);
		*/
		// 1.1.0 
		xUpdate(0,1);
		//xUpdateRepaintInline(lastIcon);


		// 0.28
		// basket for drop action

		if(isDropping && ActiveConfiguration->ObjectsIcons.at(lastIcon)->Info.className!="GSeparator")
		{
		bitBlt(&paintBuffer,
			activeIcons[lastIcon]->xPosition.x()
			+
			activeIcons[lastIcon]->xZoom/2-
			activeIcons[lastIcon]->xImgDrop.width()/2
			,
			activeIcons[lastIcon]->xPosition.y()
			,
			&activeIcons[lastIcon]->xImgDrop,
			0,/*0,
			ActiveConfiguration->Icons.SizeBig,
			ActiveConfiguration->Icons.SizeBig,*/
			Qt::CopyROP);
		}
}
	}
	else
	{
		
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xIRQ_MouseTimeout()"),"1178",0);
#endif
		xUpdate(0,1);

#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xIRQ_MouseTimeout()"),"",-1);
#endif
	}
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1212",0);
#endif

	/*	
	if(lastIcon>=0 && lastIcon<activeIconsCounter && isRaised)
	{
		bitBlt(&paintBuffer,activeIcons[lastIcon]->xPosition.x()+
			activeIcons[lastIcon]->xTextDecentre,0,&activeIcons[lastIcon]->xImgText,
			0,
			Qt::CopyROP);
	}
	*/

	// fix for transparency
	repaint(false);
	//repaint(true);
	
	//0.31
	// 0.34
	/*
	for(uint i=0;i<activeIconsCounter ;i++)
	{
		if(activeIcons[i]->xPillow)activeIcons[i]->xPillow->hide();
	}
	*/

	// 0.27
	//xDrawPillow();
	//0.31
	//
	// 0.34
	//if(!isAnimating)xDrawPillow2();
	if(isRaised)
	{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::xIRQ_MouseTimeout() 1203\n");
#endif

#ifdef ENABLE_SPECIALENGINE3
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xIRQ_Reset()));
#else	
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xIRQ_Reset()));
#endif	
		// TODO: pillow must be an external widget
		// like plugins!!!
		/*
		if(!isAnimating && mouseMoveTimeElapsed.elapsed()>1000)QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xDrawPillow()));
		*/
		//if(!isAnimating)tDrawPillow->start(1000);
		
	}
	else
	{
// from xUpdatePart1
				lastRaise=isRaised;
				//xEventReset(xLastX,xLastY);
				//releaseMouse();
				// compiz_wnd:
				repaint(false);
				qApp->syncX();
				setMask(maskBackground);
				qApp->syncX();


		//0.34
		//if(activeIcons[0]->xPillow!=NULL)activeIcons[0]->xPillow->hide();
		// AutoHideTimer
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1275",1);
#endif
		if(ActiveConfiguration->Window.FastHide>0)
		{
			// 0.27
			//xHide();
			//QTimer::singleShot(0,this,SLOT(xHide()));
			tAutoHideTimer->start(1);
		}
		else
		{
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1287",1);
#endif
		if(ActiveConfiguration->Window.HideTimeout>0)
		{
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1292",0);
#endif
			//if(tAutoHideTimer->isActive())tAutoHideTimer->stop();
			tAutoHideTimer->start(
				ActiveConfiguration->Window.HideTimeout * 1000
			);
		}
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1287",-1);
#endif

		}
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","1275",-1);
#endif

	}
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xIRQ_MouseTimeout()","",-1);
#endif
}


/*!
    \fn XGDockerFake::mousePressEvent( QMouseEvent *e )
 */
void XGDockerFake::mousePressEvent( QMouseEvent *e )
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::mousePressEvent( QMouseEvent *e )\n");
#endif
	////qWarning("void XGDockerFake::mousePressEvent( QMouseEvent *e )");
//	isDragging=0;
	lastButtonStatus=e->button();

	hasDragged=-1;

//	if(e->pos().y()<0)return;
	// 0.37 moved to release
	isDragging=1;
}


/*!
    \fn XGDockerFake::maskGenerareBigFake()
 */
void XGDockerFake::maskGenerareBigFake()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::maskGenerareBigFake()\n");
#endif


	// 28/02/2004 smooth mask
	maskBackground.fill(Qt::color0);
	int fakeY=0;
	// 0.27
	//int fakeH=ActiveConfiguration->Window.HeightDesktop;
	int fakeH=ActiveConfiguration->Icons.Size+16;

	if(LayoutPosition==LONBOTTOM)
	{
		//0.27
		//fakeY=ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop;
		fakeY=ActiveConfiguration->Window.Height-fakeH;
		//old fakeH=ActiveConfiguration->Window.HeightDesktop;
	}
	if(LayoutPosition==LONTOP)
	{
		// 1.0.1
		//fakeY=fakeH;
	}
	bitBlt(&maskBackground,
			activeIcons[0]->xPosition.x(),
			fakeY,
			&fakeDesktop,0,0,
			activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			ActiveConfiguration->Icons.Size,
			fakeH
			,Qt::CopyROP);
	bitBlt(&maskBackground,
			activeIcons[0]->xPosition.x()-ActiveConfiguration->Icons.Size-16,
			fakeY,
			&backgroundBarLeft.xTransparency,
			0,Qt::CopyROP);
	
	bitBlt(&maskBackground,
			activeIcons[activeIconsCounter-1]->xPosition.x()
				+ActiveConfiguration->Icons.Size,
			fakeY,
			&backgroundBarRight.xTransparency,
			0,Qt::CopyROP);
	
			
	// compiz_wnd:
	/*
	repaint(false);
	qApp->syncX();
	if(!isRaised)setMask(maskBackground);
	qApp->syncX();
	*/
}

void XGDockerFake::xGetObjectIcon(int i,XGIcon *&ig)
{
	ig=xGetPointerObjectIcon(i);
}

/*!
    \fn XGDockerFake::getObjectIcon(int i)
 */
XGIcon * XGDockerFake::xGetPointerObjectIcon(int i)
{
/*
#ifndef ENABLE_FINAL
	char pippo[50];
	sprintf(pippo,"XGDockerFake::getObjectIcon(int %d)",i);
	//qWarning(pippo);
#endif
*/
	if(i<0||i>=(int)activeIconsCounter)return NULL;
/*
#ifndef ENABLE_FINAL
	sprintf(pippo,"XGDockerFake::getObjectIcon(int %d) -> %d",i,activeIcons[i]->xZoom);
	//qWarning(pippo);
#endif
*/
	return activeIcons[i];
}


/*!
    \fn XGDockerFake::iconAdd(const XSGObjectIcon &, int index=-1)
 */
void XGDockerFake::iconAdd(const XSGObjectIcon *cfgIcon, int index)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::iconAdd(const XSGObjectIcon *cfgIcon, int index)\n");
#endif

	int iconIndex=activeIconsCounter;
	XGIcon *addedIcon=new XGIcon;
	mayRequireDoChangeBackground=0;
	// 0.30
	if(ActiveConfiguration->AutoResize==1 &&activeIconsCounter>0)
	{
		/*
		QPoint testIfOut;
		Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
		////qWarning(QString("AutoResize:[%1-%1]").arg(testIfOut.x()).arg(activeIcons[0]->xPosDefault.x()));
		if((testIfOut.x()-activeIcons[0]->xPosDefault.x())>QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)
		{
			////qWarning("AutoResize, we have to resize...");
			// Calc new IconSize
			int sizeTest=ActiveConfiguration->Icons.Size;
			for(;sizeTest>16;sizeTest=sizeTest-1)
			{
			ActiveConfiguration->Icons.Size=sizeTest;
		
				Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
				if((testIfOut.x()-activeIcons[0]->xPosDefault.x())>QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)continue;
				break;
			}
			xUpdateMatrix();
			//xUpdateSense();
			//
			mayRequireDoChangeBackground=1;
		}
		*/
			ActiveConfiguration->Icons.Size=QApplication::desktop()->width()/(activeIconsCounter+2);
			if(ActiveConfiguration->Icons.Size>ActiveConfiguration->Icons.SizePrefer)ActiveConfiguration->Icons.Size=ActiveConfiguration->Icons.SizePrefer;
			xUpdateMatrix();
			//xUpdateSense();
			//
			mayRequireDoChangeBackground=1;
	}
	
	if(index>=0 && activeIconsCounter!=(uint)index)
	{
		iconIndex=index;
		// if we have to intert a center icon we have to translate the others
#ifndef ENABLE_FINAL
		//qWarning("xgdocker.cpp:733");
#endif
		for(int i=index;i<(int)activeIconsCounter-1;i++)
		{
#ifndef ENABLE_FINAL
			//qWarning("xgdocker.cpp:736");
#endif
			activeIcons[i]->xPosition=activeIcons[i+1]->xPosition;
			activeIcons[i]->xPosDefault=activeIcons[i+1]->xPosDefault;
			activeIcons[i]->xPosFixed=activeIcons[i+1]->xPosFixed;
			activeIcons[i]->xHotspot=activeIcons[i+1]->xHotspot;
			activeIcons[i]->xZoom=activeIcons[i+1]->xZoom;
//			activeIcons[i]->xSetSmoothZoom(activeIcons[i]->xZoom);
			activeIcons[i]->xSetSmoothZoom();
		}
		//Matrix->xMakeSpace(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xPosition);
		Matrix->xMakeSpace(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xPosFixed);
		activeIcons[activeIconsCounter-1]->xPosDefault=activeIcons[activeIconsCounter-1]->xPosFixed;
		activeIcons[activeIconsCounter-1]->xPosDefault.setX(activeIcons[activeIconsCounter-1]->xPosFixed.x()+xMakeWidgetCenterDeltaX);
		activeIcons[activeIconsCounter-1]->xPosition=activeIcons[activeIconsCounter-1]->xPosDefault;
		//Matrix->xMakeCenter(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xHotspot);
	activeIcons[activeIconsCounter-1]->xHotspot.setX(activeIcons[activeIconsCounter-1]->xPosDefault.x()+ActiveConfiguration->Icons.Size/2);
	activeIcons[activeIconsCounter-1]->xHotspot.setY(activeIcons[activeIconsCounter-1]->xPosDefault.y()+ActiveConfiguration->Icons.Size/2+ActiveConfiguration->Icons.Raise);

		
		
		for(int i=activeIconsCounter;i>=index;i--)
		{
			activeIcons[i+1]=activeIcons[i];
		}
	}
	
	QPixmap Pixmap;
	QString imgFileNameReal=cfgIcon->Images.imgFileName;
	Configurator->xFindResource("icon",imgFileNameReal);
	QFile ifr(imgFileNameReal);
	if(ifr.exists() && imgFileNameReal!=QString::null)
	{
		Pixmap.load(imgFileNameReal);
#ifndef ENABLE_FINAL
		kdWarning() << (imgFileNameReal)<<"\n";
#endif
	}
	else
	{
		Pixmap=KDEIconLoader->loadIcon(
				cfgIcon->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig,
				KIcon::DefaultState,
				NULL,
				true
				);
		// patch 31052004
		// to load the default icon
		if(Pixmap.isNull())
		{
			if(ActiveConfiguration->Theme.DefaultIcon.isNull())
			{
			imgFileNameReal="default";
			Configurator->xFindResource("icon",imgFileNameReal);

			ifr.setName(imgFileNameReal);
			if(ifr.exists() && imgFileNameReal!=QString::null)
			{
				ActiveConfiguration->Theme.DefaultIcon.load(imgFileNameReal);
			}
			else
			{
				ActiveConfiguration->Theme.DefaultIcon=KDEIconLoader->loadIcon(
					cfgIcon->Images.imgFileName,
					KIcon::NoGroup,
					ActiveConfiguration->Icons.SizeBig
					);
			}
			}
			else
			{
			
			}
			Pixmap=ActiveConfiguration->Theme.DefaultIcon;
		}
	}


			if(Pixmap.isNull())
			{
				#ifndef ENABLE_FINAL
					kdWarning() << ("error loading image\n");
				#endif
				QImage TDF;
				TDF.create(
					1,
					1,
					32);
				
				TDF.setAlphaBuffer(false);
				TDF.fill(0);
				TDF.setAlphaBuffer(true);
				Pixmap.convertFromImage(TDF);

			}
			// resetting mask, cached data
			addedIcon->xReset();
			// loading the image
			//addedIcon->xImgOriginal=PixmapConverter.convertToImage(Pixmap);
			addedIcon->xImgOriginal=Pixmap.convertToImage();
			if(cfgIcon->Tasks.ShowThumbnail>0)
			{
				addedIcon->xImgSource=cfgIcon->Tasks.Thumbnail;
			}
			else
			{
		
				//addedIcon->xImgSource=PixmapConverter.convertToImage(Pixmap);
				addedIcon->xImgSource=Pixmap.convertToImage();
			}
	
			// Setup cacheing policy
			addedIcon->xAndZoomCache=ActiveConfiguration->Engine.AndZoomCache;
			Matrix->xMakeSpace(iconIndex,&addedIcon->xPosFixed);
			addedIcon->xPosDefault=addedIcon->xPosFixed;
			addedIcon->xPosDefault.setX(addedIcon->xPosFixed.x()+xMakeWidgetCenterDeltaX);
			addedIcon->xPosition=addedIcon->xPosDefault;
			//Matrix->xMakeCenter(iconIndex,&addedIcon->xHotspot);
			addedIcon->xHotspot.setX(addedIcon->xPosDefault.x()+ActiveConfiguration->Icons.Size/2);
			addedIcon->xHotspot.setY(addedIcon->xPosDefault.y()+ActiveConfiguration->Icons.Size/2+ActiveConfiguration->Icons.Raise);

			//
			addedIcon->xZoom=ActiveConfiguration->Icons.Size;
			//addedIcon->xSetSmoothZoom(ActiveConfiguration->Icons.Size);
			addedIcon->xSetSmoothZoom();
			if(addedIcon->xExclude)updateBackgroundSeparator(iconIndex);
			//activeIcons[iconIndex]->xSetZoom(ActiveConfiguration->Icons.Size);
			// setup it ready for update
			// activeIcons[iconIndex]->xSetUpdate=1;
	// Loading arrow
	QString ArrowFileName="arrow.png";
	if(cfgIcon->Images.imgFileArrow!=QString::null &&cfgIcon->Images.imgFileArrow!="")ArrowFileName=cfgIcon->Images.imgFileArrow;
	
	if (ActiveConfiguration->Theme.ArrowsPath[ActiveConfiguration->Theme.ArrowsPath.length()-1]!='/')ActiveConfiguration->Theme.ArrowsPath=ActiveConfiguration->Theme.ArrowsPath+"/";
	
	
	ArrowFileName=::locate("data",ActiveConfiguration->Theme.ArrowsPath)+ArrowFileName;
#ifndef ENABLE_FINAL
kdWarning() << (ArrowFileName)<<"\n";
#endif
	// TODO: check this!
	ArrowFileName=::locate("data",ArrowFileName);
#ifndef ENABLE_FINAL
	kdWarning() << (ArrowFileName)<<"\n";
#endif

	// bug fix 31052004
	QFile ar(::locate("data",ArrowFileName));
	if(!ar.exists() || ArrowFileName==QString::null)
	{
		ArrowFileName="arrow.png";
if(cfgIcon->Images.imgFileArrow!=QString::null)ArrowFileName=cfgIcon->Images.imgFileArrow;
		ArrowFileName="kxdocker/themes/arrows/"+ArrowFileName;
		
		ArrowFileName=::locate("data",ArrowFileName);
		ar.setName(ArrowFileName);
		if(!ar.exists() || ArrowFileName==QString::null)
		{
			ArrowFileName="kxdocker/themes/arrows/arrow.png";
			ArrowFileName=::locate("data",ArrowFileName);
		}		
	}
	// 0.40 with fix for arrow > 64

	/*
	QPixmap PixmapArrow(ArrowFileName);
	
	if(PixmapArrow.isNull())
	{
		//PixmapArrow.create(1,1,32);
	}

	addedIcon->xImgArrowSource=PixmapConverter->convertToImage(PixmapArrow);
	*/
	addedIcon->xImgArrowSource.load(ArrowFileName);
	if(addedIcon->xImgArrowSource.width()<2)
	{
		//PixmapArrow.create(1,1,32);
		addedIcon->xImgArrowSource.create(1,1,32);
		addedIcon->xImgArrowSource.setAlphaBuffer(false);
		addedIcon->xImgArrowSource.fill(0);
		addedIcon->xImgArrowSource.setAlphaBuffer(true);
	}

	// patch 18042004 -> enable other icons sizes
	addedIcon->xImgArrow=addedIcon->xImgArrowSource.smoothScale(
		ActiveConfiguration->Icons.Size+16,
		ActiveConfiguration->Icons.Size+16,
		QImage::ScaleMax);
	// Loading Drop icon
	ArrowFileName="drop.png";
	if(cfgIcon->Images.imgFileDrop!=QString::null&&cfgIcon->Images.imgFileDrop!="")ArrowFileName=cfgIcon->Images.imgFileDrop;
	if (ActiveConfiguration->Theme.ArrowsPath[ActiveConfiguration->Theme.ArrowsPath.length()-1]!='/')ActiveConfiguration->Theme.ArrowsPath=ActiveConfiguration->Theme.ArrowsPath+"/";
	// TODO: check this!
	ArrowFileName=::locate("data",ActiveConfiguration->Theme.ArrowsPath)+ArrowFileName;
	ArrowFileName=::locate("data",ArrowFileName);

	ar.setName(::locate("data",ArrowFileName));
	if(!ar.exists() || ArrowFileName==QString::null)
	{
		ArrowFileName="drop.png";
		if(cfgIcon->Images.imgFileArrow!=QString::null)ArrowFileName=cfgIcon->Images.imgFileArrow;
		ArrowFileName="kxdocker/themes/arrows/"+ArrowFileName;
		
		ArrowFileName=::locate("data",ArrowFileName);
		ar.setName(ArrowFileName);
		if(!ar.exists() || ArrowFileName==QString::null)
		{
			ArrowFileName="kxdocker/themes/arrows/drop.png";
			ArrowFileName=::locate("data",ArrowFileName);
		}		
	}

	// 0.40

	addedIcon->xImgDrop.load(ArrowFileName);
	if(addedIcon->xImgDrop.width()<2)
	{
		//PixmapArrow.create(1,1,32);
		addedIcon->xImgDrop.create(1,1,32);
		addedIcon->xImgDrop.setAlphaBuffer(false);
		addedIcon->xImgDrop.fill(0);
		addedIcon->xImgDrop.setAlphaBuffer(true);
	}


	/*

	QPixmap PixmapDrop(ArrowFileName);
	
	if(PixmapDrop.isNull())
	{

	}

	addedIcon->xImgDrop=PixmapConverter->convertToImage(PixmapDrop);
	*/
	/*
	addedIcon->xImgDrop=addedIcon->xImgDrop.smoothScale(
		ActiveConfiguration->Icons.SizeBig,
		ActiveConfiguration->Icons.SizeBig,
		QImage::ScaleMax);
	*/
	
	
		
	addedIcon->xSetText(cfgIcon->OverText);
	
	QString PoofName=ActiveConfiguration->Theme.PoofPath;
	PoofName=PoofName+"/"+cfgIcon->PoofName;
#ifndef ENABLE_FINAL
	kdWarning() << (PoofName)<<"\n";
#endif

	QFile b(::locate("data",PoofName));
	if(!b.exists() || PoofName==QString::null)
	{
		PoofName="kxdocker/themes/poof/";
		PoofName=PoofName+cfgIcon->PoofName;
	}
#ifndef ENABLE_FINAL
	kdWarning() << "xgdocker.cpp:866 "<<(PoofName)<<" "<<(::locate("data",PoofName))<<"\n";
#endif
	addedIcon->Poof.load(::locate("data",PoofName));
	

	addedIcon->iconConfiguration=cfgIcon;
	
	activeIcons[iconIndex]=addedIcon;
	activeIconsCounter++;
#ifndef ENABLE_FINAL
	//qWarning("xgdocker.cpp:876");
#endif

#ifdef ENABLE_STATS
	//0.36 TODO!
//ActiveConfiguration->ObjectsIcons.at(iconIndex)->Statistics.dockerIndexSum=ActiveConfiguration->ObjectsIcons.at(iconIndex)->Statistics.dockerIndexSum+iconIndex;

	if(ActiveConfiguration->Statistics.maxIconsDisplayed < (int)activeIconsCounter)
		ActiveConfiguration->Statistics.maxIconsDisplayed=activeIconsCounter;
/*
	double avgExplode=ActiveConfiguration->Statistics.avgIconsDisplayed*ActiveConfiguration->Statistics.avgCounter;
	//qWarning(QString("Stats:%1*%1=%1+%1/%1=%1")
		.arg(ActiveConfiguration->Statistics.avgCounter)
		.arg(ActiveConfiguration->Statistics.avgIconsDisplayed)
		.arg(avgExplode)
		.arg(activeIconsCounter)
		.arg(ActiveConfiguration->Statistics.avgCounter+1)
		.arg(avgExplode/ActiveConfiguration->Statistics.avgCounter)
		);
	avgExplode=avgExplode+activeIconsCounter+activeIconsCounter%2;
*/
	ActiveConfiguration->Statistics.avgCounter++;
	ActiveConfiguration->Statistics.avgIconsDisplayed=ActiveConfiguration->Statistics.avgIconsDisplayed+activeIconsCounter;

#endif



	// 0.38 moved code + ask to load plugin
	QString pClassName=ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className;
	if(pClassName!="GIcon")
	{
		// 0.31
		if(pClassName=="GSeparator")
		{
			activeIcons[iconIndex]->xExclude=1;
		}
		QObject *GClass=XEObject::xFindObject(pClassName);
		if(GClass==NULL)
		{
#ifndef ENABLE_FINAL

		//qWarning("activeIcons[iconIndex]->xSetClass(GClass); null");
#endif

			// 0.38
			// ask to load the plugin
			XEConfiguration *NewConfigurator=(XEConfiguration *)XEObject::xGetConfiguration();
			if(NewConfigurator!=NULL)
			{
#ifndef ENABLE_FINAL
		kdWarning() << "activeIcons[iconIndex]->xSetClass(GClass); loading "<<(pClassName)<<"\n";
#endif
				NewConfigurator->xLoadModule(pClassName);
				GClass=XEObject::xFindObject(pClassName);
				// TODO: need to use: PluginXMLConf->xXMLExplode();
				// now simulating the startup
				if(GClass!=NULL)
				{
					connect(this,SIGNAL(xSetup(const QString &)),XEObject::xGetRoot(), SLOT(xSetupThis(const QString &)));
					//connect(this,SIGNAL(xStop(const QString &)),XEObject::xGetRoot(), SLOT(xStop(const QString &)));
					connect(this,SIGNAL(xStart(const QString &)),XEObject::xGetRoot(), SLOT(xStartThis(const QString &)));
					xSetup(pClassName);
					activeIcons[iconIndex]->xSetClass(GClass);
					xStart(pClassName);
					disconnect(SIGNAL(xStart(const QString &)));
					//disconnect(SIGNAL(xStop(const QString &)));
					disconnect(SIGNAL(xSetup(const QString &)));
					activeIcons[iconIndex]->xStartClass();

				}
			}
		}
		else
		{
#ifndef ENABLE_FINAL
			//qWarning("activeIcons[iconIndex]->xSetClass(GClass); attached");
#endif
			activeIcons[iconIndex]->xSetClass(GClass);
			activeIcons[iconIndex]->xStartClass();
		}
	}
}


/*!
    \fn XGDockerFake::iconRemove(int index)
 */
void XGDockerFake::xEventRemovedIcon(int index)
{
#ifndef ENABLE_FINAL
	kdWarning() << QString("void XGDockerFake::xEventRemovedIcon(%1)\n").arg(index);
#endif

	if(index<0 || index>=(int)activeIconsCounter)return;
	
	// poof animations
	//0.40 if(!noanimation)xEventRemoveIcon(index);
	//0.40 Configurator->iconRemove(index);
	
	XGIcon *removedIcon=activeIcons[index];
/*
	for(int i=activeIconsCounter-1;i>index;i--)
	{
		xSwapIcons( i,i-1);
	}
	for(int i=index;i<(int)activeIconsCounter-1;i++)
	{
		activeIcons[i]=activeIcons[i+1];
		activeIcons[i]->cachePurge();
		//activeIcons[i]->xSetSmoothZoom(activeIcons[i]->xZoom);
		activeIcons[i]->xSetSmoothZoom();
		//activeIcons[i]->xReSetClass(activeIcons[i+1]->xGetClass());
	}
*/
	for(int i=index;i<(int)activeIconsCounter-1;i++)
	{
		xSwapIcons(i,i+1);
	}
	//ActiveConfiguration->Engine.IconsShowed--;
	activeIconsCounter--;
	activeIcons[activeIconsCounter]=NULL;
	removedIcon->xStopClass();


//	//qWarning("1503");
	//0.32
	// delayed
//	delete removedIcon;
	
	// 0.27
	//xMoveWidgetCenter();
	//maskGenerareBigFake();
	//polish();
// 0.38
if(checkBackgroundSeparators())
{/*
	// TODO: URGENT may be bugghed
	//qWarning("if(checkBackgroundSeparators())");
	activeIconsCounter--;
	Configurator->iconRemove(activeIconsCounter);
	delete activeIcons[activeIconsCounter];
	activeIcons[activeIconsCounter]=NULL;
	//qWarning("if(checkBackgroundSeparators()) end");
*/
}


	mayRequireDoChangeBackground=0;

	// 0.30
	if(ActiveConfiguration->AutoResize==1 &&activeIconsCounter>0)
	{
		/*
		QPoint testIfOut;
		Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
		////qWarning(QString("AutoResize:[%1-%1]").arg(testIfOut.x()).arg(activeIcons[0]->xPosDefault.x()));
		if((testIfOut.x()-activeIcons[0]->xPosDefault.x())<QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)
		{
			////qWarning("AutoResize, we have to resize...");
			// Calc new IconSize
			int sizeTest=ActiveConfiguration->Icons.Size;
			for(;sizeTest<=ActiveConfiguration->Icons.SizePrefer;sizeTest=sizeTest+1)
			{
			ActiveConfiguration->Icons.Size=sizeTest;
		
				Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
				if((testIfOut.x()-activeIcons[0]->xPosDefault.x())<QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)continue;
				break;
			}
			xUpdateMatrix();
			//
			mayRequireDoChangeBackground=1;
			//changeBackground(ActiveConfiguration->Theme.BackgroundPath);
			//xUpdateSense();
			//return;

		}
		*/
			ActiveConfiguration->Icons.Size=QApplication::desktop()->width()/(activeIconsCounter+2);
			if(ActiveConfiguration->Icons.Size>ActiveConfiguration->Icons.SizePrefer)ActiveConfiguration->Icons.Size=ActiveConfiguration->Icons.SizePrefer;
			xUpdateMatrix();
			//xUpdateSense();
			//
			mayRequireDoChangeBackground=1;
	}


	
	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(200);
	// 0.32
//	//qWarning("1552");
	// 0.40 try to deallocate memory
	removedIcon->xFreeClass();
	delete removedIcon;
//	//qWarning("1553");
}



/*!
    \fn XGDockerFake::xEventTaskAppend(int)
 */
void XGDockerFake::xEventTaskAppend(int iconIndex)
{
#ifndef ENABLE_FINAL
	kdWarning() << (QString("void XGDockerFake::xEventTaskAppend(int %1)\n").arg(iconIndex));
#endif
	// 0.27
	// now we can d animations ;)
	//activeIconsCounterLast=activeIconsCounter;
	iconAdd(ActiveConfiguration->ObjectsIcons.at(iconIndex),iconIndex);
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")createBackgroundSeparators();
	//activeIcons[iconIndex]->dAnimateNowFade=0;
	// 0.38
	// fading animations
	emit xEventAddedIcon(activeIconsCounter-1);

	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(200);
	lastActionis=1;
}


/*!
    \fn XGDockerFake::xEventTaskAppendPost()
 */
void XGDockerFake::xEventTaskAppendPost()
{

#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xEventTaskAppendPost()"),"",1);
#endif

	//if(isRaised)return;
	tPostIconAdd->stop();

	if(mayRequireDoChangeBackground)
	{
// 		//qWarning("if(mayRequireDoChangeBackground)");
		mouseMoveEventSW(xLastX,xLastY,1);
		xChangeBackground(ActiveConfiguration->Theme.BackgroundPath);
		mayRequireDoChangeBackground=0;
		// 0.38
		xUpdate();
		/*
		repaint(false);
		*/
	}

	xMoveWidgetCenter();
	maskGenerareBigFake();
	if(isRaised)
	{
		//QMouseEvent e(QEvent::MouseMove,QPoint(xLastX,xLastY),0,0);
		//mouseMoveEvent(&e);
		mouseMoveEventSW(xLastX,xLastY,1);
		xUpdate(0,1);
		// 0.38
		/*
		repaint(false);
		*/
	}

	// 0.38
	// fading animations
	//activeIcons[activeIconsCounter]->hidden
	// TODO: this is ugly
	/*
	if(lastActionis)
	{
		//emit xEventAddedIcon(activeIconsCounter-1);
		lastActionis=0;
	}
	*/
	repaint(false);
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xEventTaskAppendPost()"),"",-1);
#endif


}

/*!
    \fn XGDockerFake::xIRQ_Reset()
 */
void XGDockerFake::xIRQ_Reset()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("xEventReset()")<<"\n";
#endif	

	xEventMouseMoved(xLastX,xLastY);
	//tMouseMoved->start(ActiveConfiguration->Engine.SmoothTimeout);

	//grabMouse();
	//xEventReset(xLastX,xLastY);
}




/*!
    \fn XGDockerFake::xMoveWidgetCenter()
 */
void XGDockerFake::xMoveWidgetCenter()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xMoveWidgetCenter()"),"",1);
#endif


	// Move Window to layer
	if(LayoutPosition==LONBOTTOM)
	{
#ifndef ENABLE_FINAL
		//qWarning("xMoveWidgetCenter() bottom align");
#endif
		// 0.39 engine without move()
		/*
		int  rwidth=
			activeIcons[activeIconsCounter-1]->xPosDefault.x()
			-activeIcons[0]->xPosDefault.x()+
			(ActiveConfiguration->Icons.Size+16)*2
			+(ActiveConfiguration->Icons.Size);
		ActiveConfiguration->Window.Left=
			(QApplication::desktop()->width()-rwidth)/2
			-(activeIcons[0]->xPosDefault.x()-ActiveConfiguration->Icons.Size-16);
		*/
		/*************/
		//int  rwidth=QApplication::desktop()->width();
		ActiveConfiguration->Window.Left=0;
		/*************/

		ActiveConfiguration->Window.Top=
			QApplication::desktop()->height()-ActiveConfiguration->Window.Height;
		if(ActiveConfiguration->Window.RaiseOnEvents)
		{
                	// compiz_wnd: KWin::setStrut( winId(), 0, 0, 0, ActiveConfiguration->Window.HeightDesktop );
		}
	}
	// 1.0.1
	if(LayoutPosition==LONTOP)
	{
		ActiveConfiguration->Window.Left=0;
		ActiveConfiguration->Window.Top=0;
		if(ActiveConfiguration->Window.RaiseOnEvents)
		{
                	// compiz_wnd: KWin::setStrut( winId(),0,0,ActiveConfiguration->Window.HeightDesktop,0);
		}
	}

	ActiveConfiguration->Window.Left=ActiveConfiguration->Window.LeftForce+ActiveConfiguration->Window.Left;
	ActiveConfiguration->Window.Top=ActiveConfiguration->Window.TopForce+ActiveConfiguration->Window.Top;
#ifndef ENABLE_FINAL

		char pippo[50];
		sprintf(pippo,"XGDockerFake::xMoveWidgetCenter() %d %d\n",ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
		kdWarning() << (pippo);
#endif
	// compiz_wnd: setFixedSize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height);

	// 0.38
	// try using only nn kde env
//		int prevx=x();
//		int prevy=y();
	if(!isRaised)
	{
		maskSliding.fill(Qt::color0);
		int fakeY=0;
		int fakeH=ActiveConfiguration->Icons.Size+16;
	
		if(LayoutPosition==LONBOTTOM)
		{
			//0.27
			//fakeY=ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop;
			fakeY=ActiveConfiguration->Window.Height-fakeH;
			//old fakeH=ActiveConfiguration->Window.HeightDesktop;
		}
		if(LayoutPosition==LONTOP)
		{
			fakeY=fakeH;
		}
		bitBlt(&maskSliding,
				0,
				fakeY,
				&fakeDesktop,0,0,
				ActiveConfiguration->Window.Width,
				fakeH
				,Qt::CopyROP);
		// compiz_wnd:
		setMask(maskSliding);
		qApp->syncX();
	}
/*************************************/
// 0.39 without move()
		int prevDeltaX=xMakeWidgetCenterDeltaX;
		int  rwidth=
			activeIcons[activeIconsCounter-1]->xPosFixed.x()
			-activeIcons[0]->xPosFixed.x()+
			(ActiveConfiguration->Icons.Size+16)*2
			+(ActiveConfiguration->Icons.Size);
		xMakeWidgetCenterDeltaX=
			(QApplication::desktop()->width()-rwidth)/2
			-(activeIcons[0]->xPosFixed.x()-ActiveConfiguration->Icons.Size-16);
		//xMakeWidgetCenterDeltaX=-100;
			for(int updateAllIconI=0;updateAllIconI<(int)activeIconsCounter;updateAllIconI++)
			{
//activeIcons[updateAllIconI]->xPosDefault.setX(0);
activeIcons[updateAllIconI]->xPosDefault.setX(activeIcons[updateAllIconI]->xPosFixed.x()+xMakeWidgetCenterDeltaX);
activeIcons[updateAllIconI]->xHotspot.setX(activeIcons[updateAllIconI]->xPosDefault.x()+ActiveConfiguration->Icons.Size/2);
			}

////qWarning(QString("slide:%1 %1").arg(rwidth).arg(xMakeWidgetCenterDeltaX));
/*************************************/


		xEventWidgetBeforeMoved(
			prevDeltaX,
			0,
			activeIcons[0]->xPosDefault.x(),
			activeIcons[0]->xPosDefault.y(),
			activeIcons[activeIconsCounter-1]->xPosDefault.x(),
			activeIcons[activeIconsCounter-1]->xPosDefault.y(),
			xMakeWidgetCenterDeltaX,
			0
		);
	if(!isRaised)
	{
		// since upgrade mask is called after this we nned to "move" icons on 0.39
			for(int updateAllIconI=0;updateAllIconI<(int)activeIconsCounter;updateAllIconI++)
			{
				activeIcons[updateAllIconI]->xPosition=activeIcons[updateAllIconI]->xPosDefault;
			}

	}
/*
		backgroundUpdated(xEventGetBackground(
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top,
			ActiveConfiguration->Window.Width,
			ActiveConfiguration->Window.Height
			));
*/
		lastRaise=-2;
		xUpdate(0,1);
		// 0.39
		move(ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
		qApp->syncX();
		lastRaise=isRaised;

	
	xEventWidgetMoved(
		ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top,
		activeIcons[0]->xPosDefault.x(),
		activeIcons[0]->xPosDefault.y(),
		activeIcons[activeIconsCounter-1]->xPosDefault.x(),
		activeIcons[activeIconsCounter-1]->xPosDefault.y()
		);

	// 0.36 plugins now will know if they are moved!
	for(uint i=0;i<activeIconsCounter;i++)
	{
		activeIcons[i]->xEventPostSetIconPos(
			i,
			activeIcons[i]->xPosDefault.x(),
			activeIcons[i]->xPosDefault.y(),
			ActiveConfiguration->Icons.Size);
	}
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xMoveWidgetCenter()"),"",-1);
#endif
}



/*!
    \fn XGDockerFake::xBliz()
 */
void XGDockerFake::xBliz(int)
{
}


/*!
    \fn XGDockerFake::getRaised()
 */
int XGDockerFake::getRaised()
{
    return isRaised;
}


/*!
    \fn XGDockerFake::mouseMoveSoftware(int,int)
 */
void XGDockerFake::mouseMoveSoftware(int ,int y)
{
	// called by the software to track the mouse position
	// TODO: top
	if(y<0)xRestore();
}


/*!
    \fn XGDockerFake::wheelEvent(QWheelEvent * e )
 */
void XGDockerFake::wheelEvent(QWheelEvent * e )
{
	releaseMouse();
	int x=e->pos().x();
	int y=e->pos().y();
	int b=0;
	if(e->delta()>0)b=1;
	else b=2;
	int iconNum=(x-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	xEventMouseWheel(iconNum,x,y,b);
}


void XGDockerFake::xEventReloadIcon(int icon)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::reloadIcon(int icon)")<<"\n";
#endif

	QPixmap Pixmap;
	if(ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName!=""){
	QString imgFileNameReal=ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName;
	Configurator->xFindResource("icon",imgFileNameReal);
	QFile ifr(imgFileNameReal);
	if(ifr.exists() && imgFileNameReal!=QString::null)
	{
		Pixmap.load(imgFileNameReal);
	}
	else
	{
		Pixmap=KDEIconLoader->loadIcon(
			ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig
				);
	}

	if(!Pixmap.isNull())activeIcons[icon]->xImgSource=Pixmap.convertToImage();
	else
	{
		activeIcons[icon]->xImgSource.create(
			1,
			1,
			32);
		
		activeIcons[icon]->xImgSource.setAlphaBuffer(false);
		activeIcons[icon]->xImgSource.fill(0);
		activeIcons[icon]->xImgSource.setAlphaBuffer(true);
	}
	activeIcons[icon]->xImgOriginal=activeIcons[icon]->xImgSource.copy();
	//int z=activeIcons[icon]->xZoom;
	//activeIcons[icon]->xZoom=0;
	activeIcons[icon]->cachePurge();
	//activeIcons[icon]->xSetSmoothZoom(z);
	activeIcons[icon]->xSetSmoothZoom();
	activeIcons[icon]->xIconTextPillow.xSetText(ActiveConfiguration->ObjectsIcons.at(icon)->OverText);

	activeIcons[icon]->xIconTextMini.xSetText(ActiveConfiguration->ObjectsIcons.at(icon)->Tasks.MiniText);


	activeIcons[icon]->xIconTextPillow.PillowIsLoaded=0;
	// 0.0.19 20050524
	// Used to tell to the plugin to force redraw
	}
	activeIcons[icon]->xRedraw();
	xUpdate(0,1);
	repaint(false);
	if(icon==lastIcon)xDrawPillow2();
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::xEventReloadIcon(int icon) end");
#endif

}



//inline void XGDockerFake::mouseMoveEventSW(int x,int y,int force)
void XGDockerFake::mouseMoveEventSW(int x,int y,int force,Qt::ButtonState )
{
//Qt::ButtonState button)
	// Mouse move event, software - user
	// Check if you are going near the end of screen Y - horizontal bar
	// TODO: Vertical bar
	xLastX=x;
	xLastY=y;
	
	if(xLastX_real==x && xLastY_real==y && !force)
	{
		return;
	}

	// new engine 2
	xLastX_real=x;
	xLastY_real=y;
	
	int dx,dy,DiffIconX,DiffIconY,DiffIcon,AreMovingToLeft;
	int iconNum=
		(x-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX)/
		(ActiveConfiguration->Icons.Size
		+ActiveConfiguration->Icons.Separation);

	// adaptive mouse horizontal
	if(iconNum<=0)
	{
		dx=activeIcons[0]->xHotspot.x()-x;
		if(dx>0)
		{
			dy=activeIcons[0]->xHotspot.x()-y;
			if(dy>0)y=y-abs(activeIcons[0]->xHotspot.x()-x);
			else y=abs(activeIcons[0]->xHotspot.x()-x)+y;
			x=activeIcons[0]->xHotspot.x();
		}
	}
	if(iconNum>=(int)activeIconsCounter-1)
	{
		dx=activeIcons[activeIconsCounter-1]->xHotspot.x()-x;
		if(dx<0)
		{
			dy=activeIcons[activeIconsCounter-1]->xHotspot.x()-y;
			if(dy>0)y=y-abs(activeIcons[activeIconsCounter-1]->xHotspot.x()-x);
			else y=abs(activeIcons[activeIconsCounter-1]->xHotspot.x()-x)+y;
			x=activeIcons[activeIconsCounter-1]->xHotspot.x();
		}
	}
	// save last icon index
	if(isDragging>5)
	{
		lastIcon=iconNum;
		if(hasDragged>=0&&hasDragged<(int)activeIconsCounter&&lastIcon>=0&&lastIcon<(int)activeIconsCounter)
		{
			Configurator->xSwapIcons(hasDragged,lastIcon);
			xSwapIcons(hasDragged,lastIcon);
			hasDragged=lastIcon;
		}
	}
	else lastIcon=iconNum;
	// Optimizing code
	isRaised=0;
/*
	// 0.37 this will optimize repaint but no gain performance
	int minY=activeIcons[0]->xPosition.y();
	int minX=activeIcons[activeIconsCounter-1]->xPosition.x();
	int maxY=0;
	int maxX=0;
*/	
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		dx=activeIcons[iconIndex]->xHotspot.x()-x;
		DiffIconX=abs(dx*ActiveConfiguration->Matrix.DesignXMoltiplier);
		dy=activeIcons[iconIndex]->xHotspot.y()-y;
		DiffIconY=abs(dy*ActiveConfiguration->Matrix.DesignYMoltiplier);
		DiffIcon=DiffIconY+DiffIconX;

		if(DiffIcon<ActiveConfiguration->Matrix.sizeMatrix*2)
		{
			if(dx>0)
			{
				AreMovingToLeft=ActiveConfiguration->Matrix.DMatrix[DiffIconX][DiffIconY];
			}
			else
			{
				AreMovingToLeft=-ActiveConfiguration->Matrix.DMatrix[DiffIconX][DiffIconY];
			}
			if(!activeIcons[iconIndex]->xExclude)
			{
				activeIcons[iconIndex]->xPosition.setX(
					activeIcons[iconIndex]->xPosDefault.x()
					- ActiveConfiguration->Matrix.XMatrix[DiffIcon]+AreMovingToLeft);
				// new Engine with Separators 11 May 2004
				activeIcons[iconIndex]->xPosition.setY(
					activeIcons[iconIndex]->xPosDefault.y()
					-ActiveConfiguration->Matrix.YMatrix[DiffIcon]);

				activeIcons[iconIndex]->xSetZoom(
					ActiveConfiguration->Matrix.ZMatrix[DiffIcon]);
			}
			else
			{
				activeIcons[iconIndex]->xPosition.setX(
					activeIcons[iconIndex]->xPosDefault.x()
					+AreMovingToLeft);
			}
			isRaised=1;

			// 0.37 engine with multirepaint
			/*
			if(activeIcons[iconIndex]->xPosition.x()<minX)minX=activeIcons[iconIndex]->xPosition.x();
			if(activeIcons[iconIndex]->xPosition.x()+ActiveConfiguration->Matrix.ZMatrix[DiffIcon]>maxX)maxX=activeIcons[iconIndex]->xPosition.x();
			if(activeIcons[iconIndex]->xPosition.y()<minY)minY=activeIcons[iconIndex]->xPosition.y();
			if(activeIcons[iconIndex]->xPosition.y()+ActiveConfiguration->Matrix.ZMatrix[DiffIcon]>maxY)maxX=activeIcons[iconIndex]->xPosition.y();
			*/
		}
		else
		{
			if(DiffIconY>=ActiveConfiguration->Matrix.sizeMatrix*2)
			{
				DiffIconY=ActiveConfiguration->Matrix.sizeMatrix*2-1;
				// all hotspot are =y
				// than if you are too away from 1 icon all icons are restored
			}
			if(dx>0)
			{
				AreMovingToLeft=ActiveConfiguration->Matrix.KMatrix[DiffIconY];
			}
			else
			{
				AreMovingToLeft=-ActiveConfiguration->Matrix.KMatrix[DiffIconY];
			}
			activeIcons[iconIndex]->xPosition.setX(
				activeIcons[iconIndex]->xPosDefault.x()
				+AreMovingToLeft);
			activeIcons[iconIndex]->xPosition.setY(
				activeIcons[iconIndex]->xPosDefault.y()
				);
			// 0.31
			// we may update Y and X axis
			if(!activeIcons[iconIndex]->xExclude)
			{
				activeIcons[iconIndex]->xSetZoom(ActiveConfiguration->Icons.Size);
			}
		}
	}


	// 0.37 with multi repaint
	/*
	tUpdateRect.setTop(minY);
	tUpdateRect.setBottom(maxY);
	tUpdateRect.setLeft(minX-ActiveConfiguration->Icons.Size-ActiveConfiguration->Icons.Separation);
	tUpdateRect.setRight(maxX+ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	*/

}


/*!
    \fn XGDockerFake::xRestore()
 */
void XGDockerFake::xRestore()
{
	xEventReset(xLastX,xLastY);
}




/*!
    \fn XGDockerFake::xHide()
 */
void XGDockerFake::xHide()
{
#ifndef ENABLE_FINAL
	//qWarning("void XGDockerFake::xHide()");
#endif
	tAutoHideTimer->stop();
	tAutoSendBGTimer->stop();
	if(isRaised)return;
	//xEventDockerHidden();
	hide();
	
}


/*!
    \fn XGDockerFake::dragEnterEvent(QDragEnterEvent* event)
 */
void XGDockerFake::dragEnterEvent(QDragEnterEvent* event)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::dragEnterEvent(QDragEnterEvent* event)")<<"\n";
#endif


	isDropping=1;
    event->accept(
        QTextDrag::canDecode(event)
	// ||
        //QImageDrag::canDecode(event)
    );
    tAutoHideTimer->stop();
    tAutoSendBGTimer->stop();
    /*
    QString basket;
    if(QTextDrag::decode ( event, basket)==true)//qWarning(basket);
   	*/
}


/*!
    \fn XGDockerFake::dropEvent(QDropEvent* event)
 */
void XGDockerFake::dropEvent(QDropEvent* e)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::dropEvent(QDropEvent* e)")<<"\n";
#endif
/*
	isDropping=0;
	Busy->lock();
	int x=e->pos().x();
//	int y=e->pos().y();
	int iconNum=(x-ActiveConfiguration->Window.borderLeft)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	QString basket;
	Busy->unlock();

*/

	// 0.37 from press event
	if(e->pos().y()<0)return;
	isDropping=0;
	releaseMouse();
	Busy->lock();
	int x=e->pos().x();
	int iconNum=(x-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	dropIcon(iconNum,e);
	Busy->unlock();
}

/*!
    \fn XGDockerFake::dragLeaveEvent (QDragLeaveEvent * )
 */
void XGDockerFake::dragLeaveEvent (QDragLeaveEvent * )
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::dragLeaveEvent (QDragLeaveEvent * )")<<"\n";
#endif


	isDropping=0;
	if(ActiveConfiguration->Window.FastHide>0)
	{
		// 0.27
		//xHide();
		//QTimer::singleShot(0,this,SLOT(xHide()));
		tAutoHideTimer->start(1);
	}
	else
	{
		if(!ActiveConfiguration->Window.FastHide)
		{
		#ifndef ENABLE_FINAL
			//qWarning("tAutoSendBGTimer->start(200);");
		#endif
			tAutoSendBGTimer->start(200);
		}
		else
		{
			tAutoSendBGTimer->start(1);
		}
		/*
		if(ActiveConfiguration->Window.HideTimeout>0)
		{
			//qWarning("xgdocker.cpp:630");
			tAutoHideTimer->start(
				ActiveConfiguration->Window.HideTimeout * 1000
			);
		}
		*/
	}

}

/*!
    \fn XGDockerFake::dragMoveEvent( QDragMoveEvent * )
 */
void XGDockerFake::dragMoveEvent( QDragMoveEvent *)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::dragMoveEvent( QDragMoveEvent *)")<<"\n";
#endif

/*
	Busy->lock();
	Busy->unlock();
*/
	////qWarning(QString("[%1][%1]").arg(event->pos().x()).arg(event->pos().y()));
	
	
	/*
	this->mouseMoveEventSW(event->pos().x(),event->pos().y());
	
	xUpdate();
	repaint(false);
	*/
	if(cacheBusy->tryLock()==false)return;
	purgeCacheMovements();
}




/*!
    \fn XGDockerFake::mouseReleaseEvent ( QMouseEvent * e )
 */
void XGDockerFake::mouseReleaseEvent (QMouseEvent *e)
{
#ifndef ENABLE_FINAL
	kdWarning() << QString("void XGDockerFake::mouseReleaseEvent(%1,%1) [%1][%1]\n").arg(e->pos().x()).arg(e->pos().y()).arg(lastIcon).arg(hasDragged);
#endif
	if(hasDragged>=0)
	{
		hasDragged=-1;
		isDragging=0;
		// We need to check if you have dropped out of the docker
		if(e->pos().y()>=0&&e->pos().y()<=ActiveConfiguration->Window.Height&&lastIcon>=0&&lastIcon<(int)activeIconsCounter)
		{
			// done into the engine
		}
		else
		{
			if(hasDragged>0&&hasDragged<(int)activeIconsCounter)
			{
				XSGObjectIcon *itorm=ActiveConfiguration->ObjectsIcons.at(hasDragged);
				Configurator->xEventInRemovingIcon(hasDragged,0);
				ActiveConfiguration->RollingIcons.remove(itorm);
			}
		}
	}
	else
	{
		// 0.37 from press event
		if(e->pos().y()<0)return;
	
		releaseMouse();
		Busy->lock();
		int x=e->pos().x();
		int y=e->pos().y();
		int b=e->button();
		int iconNum=(x-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX)
			/
			(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
		
		//if(isDragging>10+ActiveConfiguration->Icons.Size)
			xEventMouseClick(iconNum,x,y,b);
		//if(isRaised)QTimer::singleShot(500,this,SLOT(xIRQ_Reset()));
		//xBliz();
		//grabMouse();
		Busy->unlock();
	
	
	
		lastButtonStatus=Qt::NoButton;
		lastIconDrag=NULL;
		isDragging=0;
		hasDragged=-1;
	}
}


/*!
    \fn XGDockerFake::hide()
 */
void XGDockerFake::hide()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::hide()")<<"\n";
#endif
	xEventDockerHidden();
	QWidget::hide();
	// compiz_wnd: KWin::setStrut( winId(), 0, 0, 0,0);
}


/*!
    \fn XGDockerFake::show()
 */
void XGDockerFake::show()
{

#ifndef ENABLE_FINAL
	//qWarning("void XGDockerFake::show()");
#endif
	////qWarning("void XGDockerFake::show()");

	tAutoSendBGTimer->stop();
	tAutoHideTimer->stop();
	
	if(!isShown())
	{
		xEventShowRaised();
	}
	else
	{
		if(ActiveConfiguration->Window.RaiseOnEvents)
		{
			
			xEventShowRaised();
		}
		else
		{
			//QWidget::show();
			// compiz
			//KWin::setType(winId(), NET::Dock);
			//KWin::setOnAllDesktops(winId(),true);
/*
#ifdef USE_KWIN
	KWin::setState( winId(), NET::StaysOnTop );
#else
	//raise();
	x11SetOnTop(winId());
#endif
*/
			emit xEventDockerShowed();
			//tAutoSendBGTimer->stop();
		}
	}
	// 0.27
	//isRaised=1;
	//

	
}

inline void XGDockerFake::setUnShadowed()
{
// compiz_wnd: 
return;

#ifndef ENABLE_FINAL
	kdWarning() << ("inline void XGDockerFake::setUnShadowed()")<<"\n";
#endif
	//0.29 && KDE 3.4 unshadow
       QByteArray data2;
        QDataStream arg2(data2, IO_WriteOnly);
        //arg2 << topLevelWidget()->winId();
	arg2 << winId();
        kapp->dcopClient()->send(
           "kwin",
           "KWinInterface",
           "setUnshadowed(unsigned long int)"
           ,data2);
}


void XGDockerFake::xEventShowRaised()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::xEventShowRaised()")<<"\n";
#endif
	////qWarning("void XGDockerFake::xEventShowRaised()");
	//if(tPostShowRaise->isActive())tPostShowRaise->stop();

	// compiz with real transparency let's us draw transparent
	paintBuffer.setAlphaBuffer(false);
	paintBuffer.fill(0);
	paintBuffer.setAlphaBuffer(true);
	repaint(false);

	if(isHidden()){
		// compiz
		//KWin::setType(winId(), NET::Dock);
		QWidget::show();
		//raise();
	}
	else
	{
	}
	// 0.37
	setUnShadowed();
	// compiz
	//qWarning("KWin::setState(winId(), NET::KeepAbove);");
	KWin::setState(winId(), NET::KeepAbove);
	//KWin::setState( winId(), NET::StaysOnTop );
	KWin::setOnAllDesktops(winId(),true);
	qApp->syncX();

	lastRaise=0;
	isRaised=0;


	emit xEventDockerShowed();

	lastRaise=0;
	isRaised=1;
	xUpdate();

	if(ActiveConfiguration->Window.FastHide)
	{
		//fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		//alternativeHeightDesktop=ActiveConfiguration->Icons.Size+16;
	}
	else
	{
/*
if(LayoutPosition==LONTOP)
{
		fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		alternativeHeightDesktop=ActiveConfiguration->Icons.Size+16;
}}
else
*/
{

		//fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		//alternativeHeightDesktop=ActiveConfiguration->Icons.Size+16;
}
	}
	
	// 0.29 it must go to lower
	if(!ActiveConfiguration->Window.FastHide)
	{
	#ifndef ENABLE_FINAL
		//qWarning("tAutoSendBGTimer->start(200);");
	#endif
		tAutoSendBGTimer->start(500);
	}
	else
	{
		tAutoSendBGTimer->start(1);
	}
	////qWarning("XGDockerFake::showRaisedPost2() end");

}

/*!
    \fn XGDockerFake::purgeCacheMovements()
 */
void XGDockerFake::purgeCacheMovements()
{


#ifdef ENABLE_SPECIALENGINE2
#ifndef ENABLE_FINAL
	//qWarning("void XGDockerFake::purgeCacheMovements() Engine 2");
#endif
//	static int lastCalledX=0;
//	static int lastCalledY=0;
//	if(xLastX_notmanaged!=lastCalledX || xLastY_notmanaged!=lastCalledY )
		for(int recallme=1;recallme!=0;)
{

	// workaround!!!!!!!
	QPoint pos, mouse, vect;
	int WinX, WinY;
	int XCoord,YCoord;
	Display *display;
	Window root, RootIDRet, ChildIDRet;
	unsigned int StateMask;
	display = kapp->getDisplay();
	root = RootWindow(display,DefaultScreen(display));
	XQueryPointer(display, root, &RootIDRet, &ChildIDRet, &XCoord,&YCoord, &WinX, &WinY, &StateMask);
	//mouse = xGDocker->mapFromGlobal(QPoint(XCoord,YCoord));
	mouse = mapFromGlobal(QPoint(XCoord,YCoord));
	xLastX_notmanaged=mouse.x();
	xLastY_notmanaged=mouse.y();

	static int ymoltiply=1;
//	static int xmoltiply=1;





	recallme=0;
	//if(1)
	// 0.39
	//if(mouseMoveTimeElapsed.elapsed()>30)
	{
	//recallme=0;
#ifndef ENABLE_FINAL
			kdWarning() <<(
			QString("void XGDockerFake::purgeCacheMovements() Engine 2 count [%1,%1][%1,%1]\n")
			.arg(xLastX_notmanaged)
			.arg(xLastY_notmanaged)
			.arg(xLastX)
			.arg(xLastY)
			);
#else
#endif

#ifdef ENABLE_SPECIALENGINE4
			if(iconNum<activeIconsCounter && iconNum>=0)
				xLastX_notmanaged=activeIcons[iconNum]->xPosDefault.x()+ActiveConfiguration->Icons.Size/2;
#endif
			
			int ax=xLastX_notmanaged;
			//int ay=xLastY_notmanaged;
			int ay=xLastY;
			int xInterpolationValue=ActiveConfiguration->Engine.InterpolationValue;

			// new Engine 0.20
			// 20040525
#ifdef ENABLE_SPECIALENGINE3
	////qWarning("#ifdef ENABLE_SPECIALENGINE3");
			// 0.40 RC
			// test 1
			/*
			int iconNum=(int)(double(xLastX_notmanaged-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX)
				/
				double(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation));
			*/
			int iconNum=((xLastX_notmanaged-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX)
				/
				(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation));
			//kdWarning()<<QString("Provo: [%1]=%1/%1\n").arg(iconNum).arg(xLastX_notmanaged-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX).arg(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
 			//if(iconNum<0 || iconNum>=(int)activeIconsCounter)
			// 0.40 RC
			if(iconNum<0 || iconNum>(int)activeIconsCounter)
			{
				xLastY_notmanaged=-1;
			}
		else
		{ // start sp3
#else
		{ // start sp3
#endif


			
			// 0.25
			// unused var
			//int xInterpolationStep=50;
			if(xLastX-xLastX_notmanaged>1)
			{

				ax=xLastX-1-(xLastX-xLastX_notmanaged)/xInterpolationValue;
				//ax=xLastX-1;
				recallme=1;
			}
			else
			{
				if(xLastX-xLastX_notmanaged<-1)
				{
					ax=xLastX+1-(xLastX-xLastX_notmanaged)/xInterpolationValue;
					//ax=xLastX+1;
					recallme=1;
				}
			}
		} // end of sp3

 			if(xLastY_notmanaged<0|| xLastY_notmanaged>ActiveConfiguration->Window.Height)
			{
				if(!isRaised)
				{
					releaseMouse();

					// 0.36 this may help to release mouse
					if(xPillow!=NULL)xPillow->hide();


					recallme=0;
					ay=xLastY-5-ymoltiply;
					ymoltiply=1;
					//break;
					//0.27
					if(!ActiveConfiguration->Window.FastHide)
					{
					#ifndef ENABLE_FINAL
						//qWarning("tAutoSendBGTimer->start(200);");
					#endif
						tAutoSendBGTimer->start(200);
					}
					else
					{
					tAutoSendBGTimer->start(1);
						//QTimer::singleShot(0,this,SLOT(xSendToBackground()));
						//xSendToBackground();
					}
				}
				else
				{
					// we have to animate
					//ay=xLastY-1-(xLastY-xLastY_notmanaged)/xInterpolationValue;
					releaseMouse();
					ay=xLastY-5-ymoltiply;
					ymoltiply=ymoltiply+5;
					recallme=1;
				}

			}
			else
			{
			
				if(xLastY-xDesignVirtualYMatrix>1)
				{
					ay=xLastY-1-abs(xLastY-xDesignVirtualYMatrix)/xInterpolationValue;
					recallme=1;
				}
				else
				{
					if(xLastY-xDesignVirtualYMatrix<-1)
					{
						ay=xLastY+1+abs(xLastY-xDesignVirtualYMatrix)/xInterpolationValue;
						recallme=1;
					}
				}
			}
				//mouseMoveTimeElapsed.start();
				mouseMoveEventSW(ax,ay,0,lastButtonStatus);
				//xUpdate(0,isRaised);
				xUpdate();
				//xDrawPillow();
				//nanosleep(&req2,&rem2);
				repaint(false);
				//repaint(tUpdateRect);
				//repaint(tUpdateRect,false);
				//update();
				// 0.39
				nanosleep(&req,&rem);
		}
	/*
	else
	{
		//usleep(10000);
		////qWarning("relax");
		nanosleep(&req2,&rem2);
		recallme=1;
	}
	*/
}
	/*
	if(recallme)
	{
#ifdef ENABLE_FINAL
#else
			//qWarning("void XGDockerFake::purgeCacheMovements() Engine 2 repoll");
#endif
			//QTimer::singleShot(0,this,SLOT(purgeCacheMovements()));
			//purgeCacheMovements();
	}
	else
	{
	
			//mouseMoveEventSW(xLastX_notmanaged,xLastY_notmanaged,0,lastButtonStatus);
	}
	*/
			//xUpdate();
			//repaint(false);
			
	cacheBusy->unlock();
	isAnimating=0;

#endif
}


/*!
    \fn XGDockerFake::xGetWidget(QWidget *&)
 */
void XGDockerFake::xGetWidget(QWidget *&pObjectWnd)
{
	pObjectWnd=this;
}


/*!
    \fn XGDockerFake::xMouseMoveSoftware(int,int,Qt::ButtonState)
 */
void XGDockerFake::xMouseMoveSoftware(int x,int y)
{
	mouseMoveSoftware(x,y);
}


/*!
    \fn XGDockerFake::xDockerRedraw
 */
void XGDockerFake::xDockerRedraw()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xDockerRedraw()"),"",1);
#endif
	// 31052004
	// may be wrong but this will help to alleviate the flickering
	// PS:
	// this will not work properly until we rewrite pillow code
	//xUpdate(0,1);
	//xUpdate();
	//xIRQ_MouseTimeout();
	//xUpdateSmooth();

	xUpdate(0,1);
	repaint(false);
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xDockerRedraw()"),"",-1);
#endif

}


/*!
    \fn XGDockerFake::xUpdateSmooth()
 */
inline void XGDockerFake::xUpdateSmooth()
{
#ifndef ENABLE_FINAL
PrintaErroreLivello("XGDockerFake::xUpdateSmooth()","",1);
#endif
	for(long int iconIndex=0;iconIndex<(int)activeIconsCounter;iconIndex++)
	{
		if(activeIcons[iconIndex]->xSetUpdate==1)
		{
			//activeIcons[iconIndex]->xSetSmoothZoom(activeIcons[iconIndex]->xZoom);
			activeIcons[iconIndex]->xSetSmoothZoom();
			activeIcons[iconIndex]->xSetUpdate=0;
		}
	}
#ifndef ENABLE_FINAL
PrintaErroreLivello("XGDockerFake::xUpdateSmooth()","",-1);
#endif
}

inline void XGDockerFake::xUpdateDrawBackground(int )
{

#ifndef ENABLE_FINAL
//qWarning("inline void XGDockerFake::xUpdateDrawBackground()");
#endif

	// we calc only 1 time the coords
	// TODO: here we can put an if is changed
	xBar=activeIcons[0]->xPosition.x();
	yBar=activeIcons[0]->xPosDefault.y()-8;
	dxBar=activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			activeIcons[activeIconsCounter-1]->xZoom;
	dyBar=ActiveConfiguration->Icons.Size+16;



	// fake background
	// unified to avoid the transparency error
// compiz: 	if(!Transparency)bitBlt(&paintBuffer,
// compiz: 			0,
// compiz: 			0,
// compiz: 			&imgFakeBackgroundGlobal,Qt::CopyROP);

	// draw background bar
	bitBlt(&paintBuffer,
			xBar,
			yBar,
			&backgroundBar.xImgSource,
			xBar,
			0,
			dxBar,
			dyBar,Qt::CopyROP);
	bitBlt(&paintBuffer,
			xBar-ActiveConfiguration->Icons.Size-16,
			yBar,
			//&backgroundBarLeft.xImgSource,
			&backgroundBarLeft.xImgShowed,
			0,Qt::CopyROP);
	
	bitBlt(&paintBuffer,
			xBar+dxBar,
			yBar,
			//&backgroundBarRight.xImgSource,
			&backgroundBarRight.xImgShowed,
			0,Qt::CopyROP);
}


inline void XGDockerFake::xUpdateDrawBackgroundPass2()
{
	bitBlt(&paintBuffer,
			xBar,
			yBar,
			&backgroundBarOver.xImgSource,
			xBar,
			0,
			dxBar,
			dyBar,Qt::CopyROP);
}

/*!
    \fn XGDockerFake::xDockerRedraw(XGIcon *)
 */
void XGDockerFake::xDockerRedraw(QObject *findMe)
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("XGDockerFake::xDockerRedraw(QObject *findMe)"),"",1);
#endif
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(findMe==activeIcons[i])
		{
			// Ok we repaint only this icon
			// 0.38 with steps update the Original not the Source...
			//
			//if(sender()==activeIcons[i]->xClassManager)activeIcons[i]->xImgSource=activeIcons[i]->xImgOriginal;
			xUpdateRepaintInline(i);
			return;
		}
	}
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("XGDockerFake::xDockerRedraw(QObject *findMe)"),"",-1);
#endif
}


void XGDockerFake::xUpdateRepaint(int iconIndex)
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("void XGDockerFake::xUpdateRepaint(int iconIndex)"),"",0);
#endif
	xUpdateRepaintInline(iconIndex);
}

/*!
    \fn XGDockerFake::xGetLayout()
 */
int XGDockerFake::xGetLayout()
{
	return LayoutPosition;
}


/*!
    \fn XGDockerFake::xSendToBackground()
 */
void XGDockerFake::xSendToBackground()
{
#ifndef ENABLE_FINAL
	kdWarning()<<QString("void XGDockerFake::xSendToBackground() [%1][%1]\n").arg(lastIcon).arg(hasDragged);
#endif
	
	tAutoSendBGTimer->stop();
	// 0.40
	// drag an icon out of docker
	if(hasDragged>=0)
	{
		// We need to check if you have dropped out of the docker
		if(hasDragged>=0&&hasDragged<(int)activeIconsCounter)
		{
				XSGObjectIcon *itorm=ActiveConfiguration->ObjectsIcons.at(hasDragged);
				Configurator->xEventInRemovingIcon(hasDragged,0);
				ActiveConfiguration->RollingIcons.remove(itorm);
		}

		hasDragged=-1;
		isDragging=0;
	}

	if(isRaised)return;
	

	
	if(ActiveConfiguration->Window.SendToBackground)
	{
		// we have to send it to background
#ifdef USE_KWIN
		// compiz_wnd: KWin::setStrut( winId(), 0, 0, 0, 0 );
			// compiz
		//KWin::setType(winId(), NET::Dock);
		//KWin::setState( winId(), NET::KeepBelow);
		//qWarning("KWin::setState( winId(), NET::KeepBelow);");
		lower();
#else
		NETWinInfo info( qt_xdisplay(),winId(),qt_xrootwin(), 0 );
		NETStrut strut;
		strut.left = 0;
		strut.right =0;
		strut.top = 0;
		strut.bottom =0;
		info.setStrut( strut );
		x11SetFloating(winId());
#endif
		// 0.27
		// TODO: new event for sending to BAGROUND NOT HIDING!
		//xEventDockerHidden();
		xEventDockerSendToBackground();
		
	}
	else
	{
		if(xPillow!=NULL)xPillow->hide();
	}

	// 0.35
	if(!tAnimateBackground->isActive() && maxDesaturate>0)tAnimateBackground->start(250);

}


/*!
    \fn XGDockerFake::createPopup(KPopup *&,const QObject *)
 */
void XGDockerFake::createPopup(KPopupMenu *&cpgIcon,const QObject *iiIcon)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::createPopup(KPopupMenu *&cpgIcon,const QObject *iiIcon)")<<"\n";
#endif
	cpgIcon=NULL;
	if(!iiIcon)return;
	XGIcon *pgIcon=(XGIcon *)iiIcon;
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(activeIcons[i]==pgIcon)
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(pgIcon->iconConfiguration);
			if(idx>0)
			{
				ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu=new KPopupMenu();
				cpgIcon=ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu;
			}
		}
	}
}


/*!
    \fn XGDockerFake::getPopupMenu(KPopupMenu *&, const QObject *)
 */
void XGDockerFake::getPopupMenu(KPopupMenu *&cpgIcon, const QObject *iiIcon)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::getPopupMenu(KPopupMenu *&cpgIcon, const QObject *iiIcon)")<<"\n";
#endif

	cpgIcon=NULL;
	if(!iiIcon)return;
	XGIcon *pgIcon=(XGIcon *)iiIcon;
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(activeIcons[i]==pgIcon)
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(pgIcon->iconConfiguration);
			if(idx>0)
			{
				cpgIcon=ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu;
			}
		}
	}
}


/*!
    \fn XGDockerFake::xBackgroundMove(int,int)
 */
void XGDockerFake::xBackgroundMove(int nXBar,int nYBar)
{
	xBar=nXBar;
	yBar=nYBar;
}


/*!
    \fn XGDockerFake::xBackgroundGetCoords(int &,int &)
 */
void XGDockerFake::xBackgroundGetCoords(int &destXBar,int &destYBar)
{
	destXBar=xBar;
	destYBar=yBar;
}




/*!
    \fn XGDockerFake::lower()
 */
void XGDockerFake::lower()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::lower()")<<"\n";
#endif
	isLowering=1;
	// 0.27
	// ugly trick
	//fakeHeightDesktop=ActiveConfiguration->Icons.Size+16;
	//alternativeHeightDesktop=fakeHeightDesktop;
	lastRaise=1;
	// here we are going to put a big bug on xDrawPillow2
	isRaised=1;
	xUpdate();

	// 0.35
	if(xPillow!=NULL)xPillow->hide();
	//QWidget::lower();
	//qWarning("KWin::setState( winId(), NET::KeepBelow);");
 	KWin::setState(winId(),NET::KeepBelow);
	repaint(false);
	lastRaise=0;
	isRaised=0;
	//alternativeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
	//fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
	isLowering=0;
}






/*!
    \fn XGDockerFake::xGetIconIndex(const QObject*)
 */
int XGDockerFake::xGetIconIndex(const QObject*findMe)
{
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(findMe==activeIcons[i])
		{
			// Ok we repaint only this icon
			return i;
		}
	}
	return -1;
}

/*!
    \fn XGDockerFake::xUpdateMatrix()
 */
inline void XGDockerFake::xUpdateMatrix()
{
/*
	xBar=activeIcons[0]->xPosition.x();
	yBar=activeIcons[0]->xPosDefault.y()-8;
	dxBar=activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			activeIcons[activeIconsCounter-1]->xZoom;
	dyBar=ActiveConfiguration->Icons.Size+16;
*/


	ActiveConfiguration->Window.Height=
		// 0.34
		//ActiveConfiguration->Icons.FontSize+
		ActiveConfiguration->Icons.Size+
		16+
		(ActiveConfiguration->Icons.SizeBig
		-
		ActiveConfiguration->Icons.Size
		)/2+
		abs(ActiveConfiguration->Icons.Raise)
		;
	if(LayoutPosition==LONTOP)
	{
		ActiveConfiguration->Window.borderTop=8;
	}
	else
	{
		ActiveConfiguration->Window.borderTop=
			8+
			(ActiveConfiguration->Icons.SizeBig
			-
			ActiveConfiguration->Icons.Size
			)/2+
			abs(ActiveConfiguration->Icons.Raise)
			;
	}

			////qWarning(QString("AutoResize:[%1]").arg(ActiveConfiguration->Icons.Size));
			Matrix->xUpdateMatrix();
			for(int updateAllIconI=0;updateAllIconI<(int)activeIconsCounter;updateAllIconI++)
			{
				//Matrix->xMakeSpace(updateAllIconI,&activeIcons[updateAllIconI]->xPosition);
				//if(activeIcons[activeIconsCounter-1]->xExclude)
				if(activeIcons[updateAllIconI]->xExclude)
				{
					////qWarning("updateBackgroundSeparator(updateAllIconI);");
					updateBackgroundSeparator(updateAllIconI);
				}
				else
				{
					Matrix->xMakeSpace(updateAllIconI,&activeIcons[updateAllIconI]->xPosFixed);
					activeIcons[updateAllIconI]->xPosDefault=activeIcons[updateAllIconI]->xPosFixed;
					activeIcons[updateAllIconI]->xPosDefault.setX(activeIcons[updateAllIconI]->xPosFixed.x()+xMakeWidgetCenterDeltaX);
					//Matrix->xMakeCenter(updateAllIconI,&activeIcons[updateAllIconI]->xHotspot);
			activeIcons[updateAllIconI]->xHotspot.setX(activeIcons[updateAllIconI]->xPosDefault.x()+ActiveConfiguration->Icons.Size/2);
			activeIcons[updateAllIconI]->xHotspot.setY(activeIcons[updateAllIconI]->xPosDefault.y()+ActiveConfiguration->Icons.Size/2+ActiveConfiguration->Icons.Raise);

//					activeIcons[updateAllIconI]->xSetSmoothZoom(ActiveConfiguration->Icons.Size);
activeIcons[updateAllIconI]->xZoom=ActiveConfiguration->Icons.Size;
activeIcons[updateAllIconI]->xSetSmoothZoom();
					activeIcons[updateAllIconI]->xImgArrow=activeIcons[updateAllIconI]->xImgArrowSource.smoothScale(
						ActiveConfiguration->Icons.Size+16,
						ActiveConfiguration->Icons.Size+16,
						QImage::ScaleMax);
				}
			}
}


/*!
    \fn XGDockerFake::xUpdateSense()
 */
void XGDockerFake::xUpdateSense()
{
	mayRequireDoChangeBackground=1;
	xUpdateMatrix();
	xChangeBackground(ActiveConfiguration->Theme.BackgroundPath);
	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(200);
}


/*!
    \fn XGDockerFake::xUpdateBackgroundCoords()
 */
inline void XGDockerFake::xUpdateBackgroundCoords()
{
	if(strcmp(ActiveConfiguration->Window.Align,"none")==0)
	{
		LayoutPosition=LONBOTTOM;
		AxisAreInverted=1;
	}
	if(strcmp(ActiveConfiguration->Window.Align,"bottom")==0)
	{
		LayoutPosition=LONBOTTOM;
		AxisAreInverted=-1;
		// bug fix for size >48px
		if(ActiveConfiguration->Engine.MaxIconsShowed<1)ActiveConfiguration->Engine.MaxIconsShowed=(QApplication::desktop()->width()/(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation))-1;
		// 0.27
		ActiveConfiguration->Window.Width=
			(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)
			*(ActiveConfiguration->Engine.MaxIconsShowed+4+ActiveConfiguration->Matrix.DesignDMoltiplier)
			+
			ActiveConfiguration->Matrix.KMatrix[(ActiveConfiguration->Matrix.sizeMatrix*2-1)]
			*2*ActiveConfiguration->Matrix.DesignXMoltiplier
			+ActiveConfiguration->Window.borderLeft*2;
//		//qWarning(QString("Width=%1").arg(ActiveConfiguration->Window.Width));
		// compiz_wnd fix
		ActiveConfiguration->Window.Width=QApplication::desktop()->width();
		//if(ActiveConfiguration->Window.HeightDesktop!=0)
		//{
			// align the desktop size
			// 0.27
			//ActiveConfiguration->Window.HeightDesktop=ActiveConfiguration->Icons.Size+16;
			//fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
			//alternativeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		//}
	}
	if(strcmp(ActiveConfiguration->Window.Align,"top")==0)
	{
		LayoutPosition=LONTOP;
		AxisAreInverted=-1;




		if(ActiveConfiguration->Engine.MaxIconsShowed<1)ActiveConfiguration->Engine.MaxIconsShowed=(QApplication::desktop()->width()/(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation))-1;
		// 0.27
		ActiveConfiguration->Window.Width=
			(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)
			*(ActiveConfiguration->Engine.MaxIconsShowed+4+ActiveConfiguration->Matrix.DesignDMoltiplier)
			+
			ActiveConfiguration->Matrix.KMatrix[(ActiveConfiguration->Matrix.sizeMatrix*2-1)]
			*2*ActiveConfiguration->Matrix.DesignXMoltiplier
			+ActiveConfiguration->Window.borderLeft*2;
		//fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		//alternativeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
	}
	
	// application height
	ActiveConfiguration->Window.Height=
		// 0.34
		//ActiveConfiguration->Icons.FontSize+
		ActiveConfiguration->Icons.Size+
		16+
		(ActiveConfiguration->Icons.SizeBig
		-
		ActiveConfiguration->Icons.Size
		)/2+
		abs(ActiveConfiguration->Icons.Raise)
		;
		// 0.21 pillow is going to be removed
		//+XGIcon::xGetFontHeight();
		//+32;
	
	if(LayoutPosition==LONTOP)
	{
		ActiveConfiguration->Window.borderTop=8;
	}
	if(LayoutPosition==LONBOTTOM)
	{
		ActiveConfiguration->Window.borderTop=
			//ActiveConfiguration->Icons.Size+
			8+
			(ActiveConfiguration->Icons.SizeBig
			-
			ActiveConfiguration->Icons.Size
			)/2+
			abs(ActiveConfiguration->Icons.Raise)
			;
	}
}



inline void XGDockerFake::changeBackgroundForce(const QString basePath)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("inline void XGDockerFake::changeBackgroundForce(const QString basePath)")<<"\n";
#endif

	maxDesaturate=(float)ActiveConfiguration->Theme.Background.Desaturate/(float)100;

	QString barPath=basePath;
	if (barPath[barPath.length()-1]!='/')barPath=barPath+"/";
	barPath=::locate("data",barPath);
	
	QFile a(barPath);
	
	if(basePath.length()>0 && a.exists())
	{
		
		
#ifndef ENABLE_FINAL
		kdWarning() <<(barPath)<<"\n";
#endif
		// Setup background theme
		QString filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundCenter;
		
		QPixmap PixmapB(filename);
		// 0.35
		// desaturate
		if(maxDesaturate>0)
		{
			int i=0;
			for(float ifo=0;ifo<maxDesaturate;ifo=ifo+maxDesaturate/20)
			{
				QPixmap PixmapAn(filename);
				if(PixmapAn.isNull())
				{
					backgroundBarAni[i].xReset();
					break;
				}
				// 0.35 fix1
				// error with alpha
				//KPixmap An2=PixmapAn;
				//if(i>0)An2=KPixmapEffect::desaturate(An2,ifo);

				backgroundBarAni[i].xImgSource=PixmapAn.convertToImage();
				//backgroundBarAni[i].xImgSource=An2.convertToImage();

				//  desaturate
				//if(i>0)backgroundBarAni[i].xImgSource=KImageEffect::desaturate(backgroundBarAni[i].xImgSource,ifo);
				if(i>0)backgroundBarAni[i].xDesaturate(ifo);
					backgroundBarAni[i].xImgSource=
						backgroundBarAni[i].xImgSource.smoothScale(
						backgroundBarAni[i].xImgSource.width(),
						ActiveConfiguration->Icons.Size+16);
				backgroundBarAni[i].xRepeat(
						ActiveConfiguration->Window.Width,
						ActiveConfiguration->Icons.Size+16);
				i++;
			}
		}
		else
		{
			for(int i=0;i<64;i++)
			{
				//backgroundBarAni[i].xReset();
				QString fnamebar=barPath+
					QString("ani_%1_").arg(i)
					+ActiveConfiguration->Theme.Background.imgBackgroundCenter;
				////qWarning(fnamebar);
				QPixmap PixmapAn(fnamebar);
				if(PixmapAn.isNull())
				{
					backgroundBarAni[i].xReset();
					//backgroundBarAni[i].xImgSource.reset();
					break;
				}
				backgroundBarAni[i].xImgSource=PixmapAn.convertToImage();
					backgroundBarAni[i].xImgSource=
						backgroundBarAni[i].xImgSource.smoothScale(
						backgroundBarAni[i].xImgSource.width(),
						ActiveConfiguration->Icons.Size+16);
				backgroundBarAni[i].xRepeat(
						ActiveConfiguration->Window.Width,
						ActiveConfiguration->Icons.Size+16);
			}
		}
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			//backgroundBar.xImgSource.reset();
			backgroundBar.xReset();
		}
		else
		{
			// this will load the original background
			backgroundBar.xImgSource=PixmapB.convertToImage();
			// check if it's tiled
			if(ActiveConfiguration->Theme.Background.Tiled)
			{
				backgroundBar.xImgSource=
					backgroundBar.xImgSource.smoothScale(
					backgroundBar.xImgSource.width(),
					ActiveConfiguration->Icons.Size+16);
				backgroundBar.xRepeat(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
			else
			{
				backgroundBar.xImgSource=
					backgroundBar.xImgSource.smoothScale(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundOver;
		
		PixmapB.load(filename);
		
		if(PixmapB.isNull())
		{
			backgroundBarOver.xImgSource.reset();
#ifndef ENABLE_FINAL
			kdWarning() <<("errore OVER\n");
#endif
		}
		else
		{
			//backgroundBarOver.xImgSource=PixmapConverter.convertToImage(PixmapB);
			backgroundBarOver.xImgSource=PixmapB.convertToImage();
			
			if(ActiveConfiguration->Theme.Background.Tiled)
			{
				backgroundBarOver.xImgSource=
					backgroundBarOver.xImgSource.smoothScale(
					backgroundBarOver.xImgSource.width(),
					ActiveConfiguration->Icons.Size+16);
				backgroundBarOver.xRepeat(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
			else
			{
				backgroundBarOver.xImgSource=
					backgroundBarOver.xImgSource.smoothScale(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundLeft;
		
		PixmapB.load(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			backgroundBarLeft.xReset();
			//backgroundBarLeft.xImgSource.reset();
			backgroundBarLeft.xTransparency.resize(0,0);
#ifndef ENABLE_FINAL
			kdWarning() <<("errore left\n");
#endif
		}
		else
		{
			backgroundBarLeft.xReset();
			backgroundBarLeft.xImgSource=PixmapB.convertToImage();
			backgroundBarLeft.xImgOriginal.load(barPath+"background-mask-left.png");
			/*backgroundBarLeft.xImgSource=
				backgroundBarLeft.xImgSource.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			backgroundBarLeft.xTransparency=
				backgroundBarLeft.xImgSource.createHeuristicMask();
				//backgroundBarLeft.xImgSource.createAlphaMask();
			*/
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundRight;
		
		PixmapB.load(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			backgroundBarRight.xReset();
			backgroundBarRight.xTransparency.resize(0,0);
#ifndef ENABLE_FINAL
			kdWarning() <<("errore right\n");
#endif
		}
		else
		{
			backgroundBarRight.xReset();
			backgroundBarRight.xImgSource=PixmapB.convertToImage();
			backgroundBarRight.xImgOriginal.load(barPath+"background-mask-right.png");
			/*
			backgroundBarRight.xImgSource=
				backgroundBarRight.xImgSource.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
	
			backgroundBarRight.xTransparency=
				//backgroundBarRight.xImgSource.createAlphaMask();
				backgroundBarRight.xImgSource.createHeuristicMask();
			*/
	}
		PixmapB.resize(0,0);
	}
	else
	{
		// no background
		backgroundBar.xImgSource.reset();
	}

	// auto adding separator
	// 20050601
	// code moved to a func
	// 0.31
	//checkBackgroundSeparators();
	createBackgroundSeparators();
	//maskGenerareBigFake();
	lastBackgroundPath=basePath;

}
void XGDockerFake::xChangeBackground(const QString &basePath)
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::changeBackground(const QString basePath)")<<"\n";
#endif

#ifdef ENABLE_STATS
	//0.36 TODO!
	ActiveConfiguration->Statistics.changedBackgroundTheme++;
#endif


	// 0.32
	// todo optimize!!!
	//if(lastBackgroundPath!=basePath)
	{
		changeBackgroundForce(basePath);
		
	}
	//else
	{
		if(!backgroundBarRight.xImgSource.isNull()){
			
			//backgroundBarRight.xSetSmoothZoom(ActiveConfiguration->Icons.Size+16);
			backgroundBarRight.xZoom=ActiveConfiguration->Icons.Size+16;
			backgroundBarRight.xSetSmoothZoom();

			QImage tmpMask=backgroundBarRight.xImgShowed;
			if(!backgroundBarRight.xImgOriginal.isNull())
			{
			tmpMask=backgroundBarRight.xImgOriginal.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			}
			backgroundBarRight.xTransparency=tmpMask.createHeuristicMask();

			/*
			backgroundBarRight.xTransparency=backgroundBarRight
					.xImgShowed
						.createHeuristicMask();

			*/
			// 0.32
			/*
			backgroundBarRight.xTransparency.resize(
				ActiveConfiguration->Icons.Size+16,
				ActiveConfiguration->Icons.Size+16);
			backgroundBarRight.xTransparency.fill(Qt::color1);
			*/
		}
		if(!backgroundBarLeft.xImgSource.isNull())
		{
			//backgroundBarLeft.xSetSmoothZoom(ActiveConfiguration->Icons.Size+16);
			backgroundBarLeft.xZoom=ActiveConfiguration->Icons.Size+16;
			backgroundBarLeft.xSetSmoothZoom();
			QImage tmpMask=backgroundBarLeft.xImgShowed;
			if(!backgroundBarLeft.xImgOriginal.isNull())
			{
			tmpMask=backgroundBarLeft.xImgOriginal.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			}
			backgroundBarLeft.xTransparency=tmpMask.createHeuristicMask();

			/*
			backgroundBarLeft.xTransparency=backgroundBarLeft
					.xImgShowed
						.createHeuristicMask();
			*/
			// 0.32
			/*
			backgroundBarLeft.xTransparency.resize(
				ActiveConfiguration->Icons.Size+16,
				ActiveConfiguration->Icons.Size+16);
			backgroundBarLeft.xTransparency.fill(Qt::color1);
			*/
		}
		// since 0.30 support apply configuration we need only to resize the images...
		checkBackgroundSeparators();
	}
	if(maxDesaturate>0)backgroundCicle();
	// 0.35
	if(!tAnimateBackground->isActive() && maxDesaturate>0)tAnimateBackground->start(250);


}

void XGDockerFake::createBackgroundSeparators()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("void XGDockerFake::createBackgroundSeparators()")<<"\n";
#endif
	QString barPath=ActiveConfiguration->Theme.BackgroundPath;
	if (barPath[barPath.length()-1]!='/')barPath=barPath+"/";
	barPath=::locate("data",barPath);
	// New engine 11 May 2004
	// we have to search for all separators icons
	// GSeparator
	for(uint iconIndex=0;
		iconIndex<ActiveConfiguration->ObjectsIcons.count();
		iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
		{
			// exclude from resizing
			activeIcons[iconIndex]->xExclude=1;
			QString fname=ActiveConfiguration->ObjectsIcons.at(iconIndex)->Images.imgFileName;
			// check if you like to specify an image
			// 0.31
			if(fname=="")
			{
				// if 't specify an image we load the
				// background-separator.png
				QPixmap PixmapB;
				PixmapB.resize(0,0);
		
				QString filename=barPath
					+ActiveConfiguration->Theme.Background.imgBackgroundSeparator;
#ifndef ENABLE_FINAL
kdWarning() <<(filename)<<"\n";
#endif
				PixmapB.load(filename);
				// Loading background Bar and tile it
				activeIcons[iconIndex]->xReset();
				if(PixmapB.isNull())
				{
					// We do nothing!!!
					// TODO: new right engine to load backgrounds
					
					// 0.22 patch 15062004
					// if ou don't have separators we create a transparent image
					activeIcons[iconIndex]->xImgSource.create(1,1,32);
					activeIcons[iconIndex]->xImgSource.setAlphaBuffer(false);
					activeIcons[iconIndex]->xImgSource.fill(0);
					activeIcons[iconIndex]->xImgSource.setAlphaBuffer(true);
				
			
#ifndef ENABLE_FINAL
kdWarning() <<("errore imgBackgroundSeparator\n");
#endif
				}
				else
				{
					activeIcons[iconIndex]->xImgSource=PixmapB.convertToImage();
					// 0.31
					/*
					activeIcons[iconIndex]->xImgSource=
						activeIcons[iconIndex]->xImgSource.smoothScale(
						ActiveConfiguration->Icons.Size+16
						,ActiveConfiguration->Icons.Size+16);
					*/
				}
					// 0.31
				updateBackgroundSeparator(iconIndex);
				// free image
				PixmapB.resize(0,0);
			}
			else
			{
				// you have specified the image
				// other engines will load it
			}
		}
	}
}

inline int XGDockerFake::checkBackgroundSeparators()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("inline void XGDockerFake::checkBackgroundSeparators()")<<"\n";
#endif
	////qWarning("void XGDockerFake::checkBackgroundSeparators()");


	for(uint iconIndex=0;
		iconIndex<ActiveConfiguration->ObjectsIcons.count();
		iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
		{
			updateBackgroundSeparator(iconIndex);
		}
	}

	////qWarning("End.");
	if(ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1)->Info.className=="GSeparator")
	{
		//iconRemove(ActiveConfiguration->ObjectsIcons.count()-1,1);
#ifndef ENABLE_FINAL
		kdWarning() <<("void XGDockerFake::checkBackgroundSeparators() return 1\n");
#endif
		return 1;
	}else return 0;
}

inline void XGDockerFake::updateBackgroundSeparator(int iconIndex)
{
#ifndef ENABLE_FINAL
	kdWarning() <<(QString("xSetSmoothZoom(%1)\n").arg(ActiveConfiguration->Icons.Size+16));
#endif

	activeIcons[iconIndex]->xZoom=ActiveConfiguration->Icons.Size+16;
	//activeIcons[iconIndex]->xSetSmoothZoom(ActiveConfiguration->Icons.Size+16);
	activeIcons[iconIndex]->xSetSmoothZoom();
	Matrix->xMakeSpace(iconIndex,&activeIcons[iconIndex]->xPosFixed);
	//Matrix->xMakeCenter(iconIndex,&activeIcons[iconIndex]->xHotspot);
	activeIcons[iconIndex]->xPosFixed.setY(
		activeIcons[iconIndex]->xPosFixed.y()-8);
	activeIcons[iconIndex]->xPosFixed.setX(
		activeIcons[iconIndex]->xPosFixed.x()-8);
	activeIcons[iconIndex]->xPosDefault=activeIcons[iconIndex]->xPosFixed;
	activeIcons[iconIndex]->xPosDefault.setX(activeIcons[iconIndex]->xPosFixed.x()+xMakeWidgetCenterDeltaX);
	activeIcons[iconIndex]->xPosition=activeIcons[iconIndex]->xPosDefault;
	activeIcons[iconIndex]->xHotspot.setX(activeIcons[iconIndex]->xPosDefault.x()+ActiveConfiguration->Icons.Size/2);
	activeIcons[iconIndex]->xHotspot.setY(activeIcons[iconIndex]->xPosDefault.y()+ActiveConfiguration->Icons.Size/2+ActiveConfiguration->Icons.Raise);

/*
	activeIcons[iconIndex]->xPosition.setY(
		activeIcons[iconIndex]->xPosition.y()-8);
	activeIcons[iconIndex]->xPosition.setX(
		activeIcons[iconIndex]->xPosition.x()-8);
*/
	activeIcons[iconIndex]->xSetUpdate=0;
}

void XGDockerFake::backgroundCicle()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	kdWarning() << ("XGDockerFake::backgroundCicle()")<<"\n";
#endif



	////qWarning(QString("void XGDockerFake::backgroundCicle(%1)").arg(backgroundBarAniFrame));
	if(isRaised){
		// ok than check if we have desaturated
		if(maxDesaturate>0)
		{
			if(backgroundBarAniFrame>0)
			{
				backgroundBarAniFrame--;
				backgroundBar.xImgSource=backgroundBarAni[backgroundBarAniFrame].xImgSource;
				//backgroundBar.xImgSource.fill(0);
				xUpdate();
				repaint(false);
				if(backgroundBarAni[backgroundBarAniFrame].xImgSource.isNull()){
					if(maxDesaturate>0)tAnimateBackground->stop();
					backgroundBarAniFrame=0;
				}
			}
			else
			{
				tAnimateBackground->stop();
			}
			return;
		}

		// 0.35 we need to restart the animation
		// because it may be desaturation
		//backgroundBarAniFrame=0;
		return;
	}
	if(backgroundBarAni[0].xImgSource.isNull()){
		tAnimateBackground->stop();
		return;
	}


	backgroundBar.xImgSource=backgroundBarAni[backgroundBarAniFrame].xImgSource;
	//backgroundBar.xImgSource.fill(0);
	xUpdate();
	repaint(false);
	backgroundBarAniFrame++;
	if(backgroundBarAniFrame>63)backgroundBarAniFrame=0;
	if(backgroundBarAni[backgroundBarAniFrame].xImgSource.isNull()){
		if(maxDesaturate>0)
		{
			tAnimateBackground->stop();
			if(backgroundBarAniFrame>0)backgroundBarAniFrame--;
		}
		else backgroundBarAniFrame=0;
	}

	
}

void XGDockerFake::xStopAnimateBackground()
{
	tAnimateBackground->stop(); 
}

void XGDockerFake::xStartAnimateBackground()
{
	tAnimateBackground->start(250);
}

inline void XGDockerFake::xUpdateRepaintFast(int iconIndex)
{
	xUpdateRepaintInline(iconIndex);
}



void XGDockerFake::xDockerRedrawFast(QObject *findMe)
{
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("XGDockerFake::xDockerRedrawFast(QObject *findMe)"),"",1);
#endif
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(findMe==activeIcons[i])
		{
			// Ok we repaint only this icon
			xUpdateRepaintFast(i);
			return;
		}
	}
#ifndef ENABLE_FINAL
PrintaErroreLivello(QString("XGDockerFake::xDockerRedrawFast(QObject *findMe)"),"",-1);
#endif
}




void XGDockerFake::xUpdateRepaintInline(int iconIndex)
{

//if(isRaised==0)return;
// Test 2
	int bsx=activeIcons[iconIndex]->xPosition.x();
	int bsz=activeIcons[iconIndex]->xZoom;
	static QImage  paintBufferSingle;
	static char *LastBuffer=0;
	if(xmaskSingle!=NULL)
	{
		xmaskSingle->data=LastBuffer;
		XDestroyImage(xmaskSingle);
	}

	xmaskSingle = XCreateImage(qt_xdisplay(),  DefaultVisual(qt_xdisplay(), 0), 32, ZPixmap, 0, NULL,
					bsz, ActiveConfiguration->Window.Height,
					32, 0);

	paintBufferSingle.create(bsz,ActiveConfiguration->Window.Height,32);
	paintBufferSingle.setAlphaBuffer(false);
	paintBufferSingle.fill(0);
	paintBufferSingle.setAlphaBuffer(true);


	//qWarning(QString("Updating single icon %1 %1 %1").arg(iconIndex).arg(bsx).arg(bsz));

	bitBlt(&paintBufferSingle,
			0,
			yBar,
			&backgroundBar.xImgSource,
			bsx,
			0,
			bsz,
			ActiveConfiguration->Window.Height,Qt::CopyROP);

	if(activeIcons[iconIndex]->hidden==0)
	{
		bitBlt(&paintBufferSingle,
			0,
			activeIcons[iconIndex]->xPosition.y(),
			&activeIcons[iconIndex]->xImgShowed,0,Qt::CopyROP);
	}




		// Drawing arrow
		// TODO: we are polling status of icon from configuration data it may be null
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.TaskInfo!=NULL
		||
		ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.dcopReady
		||
		ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.forceRunning
		)
		{
			bitBlt(&paintBufferSingle,
				0
				+activeIcons[iconIndex]->xZoom/2
				-ActiveConfiguration->Icons.Size/2-8,
				activeIcons[iconIndex]->xPosDefault.y()
				-8,
				&activeIcons[iconIndex]->xImgArrow,0,Qt::CopyROP);
		}
		// 0.36 with miniText
	xUpdateRepaintMiniTextInline(iconIndex,paintBufferSingle,0,0);


	bitBlt(&paintBufferSingle,
			0,
			yBar,
			&backgroundBarOver.xImgSource,
			bsx,
			0,
			bsz,
			ActiveConfiguration->Window.Height,
			Qt::CopyROP);

	LastBuffer=xmaskSingle->data;
	xmaskSingle->data=(char *)paintBufferSingle.bits();

	XPutImage(qt_xdisplay(),winId(),gc,xmaskSingle, 0, 0, bsx, 0,bsz,ActiveConfiguration->Window.Height);

	if(iconIndex==lastIcon)xDrawPillow2();
}



inline void XGDockerFake::xDrawPillow2()
{
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::xDrawPillow2()\n");
#endif

	if(isRaised && !isLowering)
	{
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::xDrawPillow2() isRaised\n");
#endif
		if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
		{
			if(xPillow==NULL)
			{
kdWarning() <<("void XGDockerFake::xDrawPillow2() WARNING! xPillow cannot be NULL");
				/*
				if(activeIcons[0]->xPillow==NULL)
				{
					activeIcons[0]->xPillow=new XEPlugin_GEPillow(0,0);
					if(activeIcons[0]->xPillow==NULL)
					{
						//qWarning("KXDocker::XGDockerFake::xDrawPillow2()::activeIcons[0]->xPillow==NULL I think I'm going to crash!!!");
						return;
					}

					activeIcons[0]->xPillow->xSetup();
					activeIcons[0]->xPillow->xEventWidgetMoved(
						ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top,
						activeIcons[0]->xPosDefault.x(),
						activeIcons[0]->xPosDefault.y(),
						activeIcons[activeIconsCounter-1]->xPosDefault.x(),
						activeIcons[activeIconsCounter-1]->xPosDefault.y()
					);
					activeIcons[0]->xPillow->xStart();
				}
				// TODO: make static xPillow
				activeIcons[lastIcon]->xPillow=activeIcons[0]->xPillow;
#ifndef ENABLE_FINAL
	//qWarning("void XGDockerFake::xDrawPillow2() created xPillow");
#endif
				*/
			}
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::xDrawPillow2() 4532\n");
#endif
			if(!activeIcons[lastIcon]->xIconTextPillow.isTextDrawed)activeIcons[lastIcon]->xIconTextPillow.xDrawText();
			int bsx=activeIcons[lastIcon]->xPosition.x()+activeIcons[lastIcon]->xZoom/2;
			bsx=bsx-activeIcons[lastIcon]->xIconTextPillow.xTextDecentre;
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::xDrawPillow2() 4535\n");
#endif
			
			xPillow->externalDrawPillow(
			//((XEPlugin_GEPillow *)xPillow)->externalDrawPillow(
				activeIcons[lastIcon],
				bsx
				//+ActiveConfiguration->Window.Left
				,
				0
				//+ActiveConfiguration->Window.Top-5
				//-
				//XGIcon::xGetFontHeight()
				);
			xPillow->show();
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::xDrawPillow2() 4548\n");
#endif

		}
		else
		{
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::xDrawPillow2() Not Raised\n");
#endif
		}
	}
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::xDrawPillow2() End\n");
#endif
}


void XGDockerFake::xSetDesaturate(float nDesaturate)
{
	Desaturate=nDesaturate;
	repaint(false);
}



void XGDockerFake::xUpdateRepaintMiniTextInline(int iconIndex, QImage &targetBuffer,int xs,int)
{
#ifndef ENABLE_FINAL
	kdWarning() <<QString("XGDockerFake::xUpdateRepaintMiniTextInline(%1) start\n").arg(iconIndex);
#endif
	if(activeIcons[iconIndex]->xIconTextMini.pillowText.length())
	{
		if(!activeIcons[iconIndex]->xIconTextMini.isTextDrawed)activeIcons[iconIndex]->xIconTextMini.xDrawText();
		int bsx=xs+activeIcons[iconIndex]->xZoom/2;
		bsx=bsx-activeIcons[iconIndex]->xIconTextMini.xTextDecentre;

		bitBlt(&targetBuffer,bsx,
			activeIcons[iconIndex]->xPosDefault.y()+
			ActiveConfiguration->Icons.Size/2,
			&activeIcons[iconIndex]->xIconTextMini.xImageText,
			0,
			Qt::CopyROP);
	}
#ifndef ENABLE_FINAL
	kdWarning() <<QString("XGDockerFake::xUpdateRepaintMiniTextInline(%1) end\n").arg(iconIndex);
#endif

}

void XGDockerFake::startDrag()
{
#ifndef ENABLE_FINAL
	kdWarning() <<QString("void XGDockerFake::startDrag() [%1]\n").arg(lastIcon);
#endif
	if(hasDragged<0)
	{
		if(lastIcon<0)hasDragged=0;
		else if(lastIcon>=(int)activeIconsCounter)hasDragged=activeIconsCounter-1;
			else hasDragged=lastIcon;
	}
	return;

	if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
	{
		// 0.39 workaround, this is not ready
		// activeIcons[lastIcon]->hidden=1;
		QDragObject *d = new QTextDrag("ciao", this );
		//d->dragCopy();
		if (d->drag() && d->target() == this )
		{
			// ok than you have moved it
			// 0.40 with xSwapIcons();
/*
			int srcPos=xGetPointerObjectIcon(hasDragged);
			int iconNum=(xLastX-ActiveConfiguration->Window.borderLeft-xMakeWidgetCenterDeltaX)/(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
			xSwap(srcPos,iconNum);
*/
		}
	}
#ifndef ENABLE_FINAL
	kdWarning() <<("void XGDockerFake::EndstartDrag()\n");
#endif
	// do NOT delete d.
}
/*

extern  GC kde_xget_temp_gc( int scrn, int depth);
GC kde_xget_temp_gc( int, int depth)
{
	GC gc;
	XGCValues gcv;
	memset(&gcv,0,sizeof(gcv));
	Pixmap pix;
	pix=XCreatePixmap(qt_xdisplay(),qt_xrootwin(), 128, 128, depth);
	gc=XCreateGC(qt_xdisplay(), pix, GCForeground, &gcv);
	return gc;
}
QPixmap XGDockerFake::xEventGetBackground(int l,int t,int wb,int hb)
{
	QPixmap background(wb,hb);

	static Atom prop_root;
//	static Atom atom_eroot;
	Pixmap p = None;
	Atom type;
	int format;
	unsigned long length, after;
	unsigned char* data_root;
	prop_root = XInternAtom(qt_xdisplay(), "_XROOTPMAP_ID", false);
	//atom_eroot = XInternAtom(qt_xdisplay(), "ESETROOT_PMAP_ID", false);
	XGetWindowProperty( qt_xdisplay(), qt_xrootwin(), prop_root, 0L, 1L, False, AnyPropertyType,&type, &format, &length, &after, &data_root);
	//XGetWindowProperty( qt_xdisplay(), qt_xrootwin(), atom_eroot, 0L, 1L, False, AnyPropertyType,&type, &format, &length, &after, &data_root);
	if (type == XA_PIXMAP)
	{
		p = *((Pixmap*)data_root);
		if (p != None){
			Window root=qt_xrootwin();
			Pixmap p_mask = None;
			int x=0, y=0;
			unsigned int w = 0;
			unsigned int h = 0;
			unsigned int border_w=0, depth=0;
			XGetGeometry(qt_xdisplay(), p, &root,
				&x, &y, &w, &h, &border_w, &depth);
			if (w > 0 && h > 0){
				QPixmap pm(w, h);
				// Always detach before doing something behind QPixmap's back.
				pm.detach();
				XCopyArea(qt_xdisplay(),
					p, pm.handle(),
					kde_xget_temp_gc(DefaultScreen(qt_xdisplay()),depth),
					0, 0, w, h, 0, 0);
				if (p_mask != None){
					QBitmap bm(w, h);
					XCopyArea(qt_xdisplay(), p_mask, bm.handle(),
						kde_xget_temp_gc(DefaultScreen(qt_xdisplay()), 1),
						0, 0, w, h, 0, 0);
					pm.setMask(bm);
				}
				bitBlt(&background,0,0,&pm,l,t,wb,hb,Qt::CopyROP);
				return background;

				//background=pm;
	
			}
		}
	}

	background.fill(Qt::black);
	return background;
}
*/

void XGDockerFake::paint(QImage &target)
{
	bitBlt(&target,
		0,
		0,
		&paintBuffer,
		0,0,ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height,
		Qt::CopyROP);
}

void XGDockerFake::paintIn(QImage &source,int Erase)
{
	switch(Erase)
	{
		case 1:
		paintBuffer.setAlphaBuffer(false);
		//paintBuffer.fill(0);
		//paintBuffer.setAlphaBuffer(true);
		break;
		case 2:
		//lastRaised=0;
		xUpdatePart1(0,0);
		break;
	}

	bitBlt(&paintBuffer,
		0,
		0,
		&source,
		0,0,ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height,
		Qt::CopyROP);
}

inline void XGDockerFake::xUpdatePart1(int,int)
{
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xUpdatePart1(int,int)","",1);
#endif
			// Emit Mouse Moved Signal to track mouse!
			tMouseMoved->start(ActiveConfiguration->Engine.SmoothTimeout);

		// if it's raised we have to do some work
		if(isRaised>0)
		{
			// Are we changing the state of the widget?
			if(lastRaise!=isRaised)
			{
				// Grab the new FAKE background, because we are raising over the windows
				//0.27
				setMask(maskFull);
				//qApp->syncX();
				////qWarning("xgdocker.cpp:385");
				// Lock the mouse to have a good smooth
				grabMouse();
				// Software update with manual background refresh
				if(lastRaise>=0)
				{
#ifndef ENABLE_FINAL
					kdWarning() <<("xgdocker.cpp:389 You are showing the window\n");
#endif
					/*
					bitBlt(&paintBuffer,
						0,
						0,
						&imgWindow,0,Qt::CopyROP);
					*/
// compiz: 					imgFakeBackground=imgWindow;
				}
				else
				{
					// it's a desktop
					/*
					bitBlt(&paintBuffer,
						0,
						0,
						&imgBackground,0,Qt::CopyROP);
					*/
#ifndef ENABLE_FINAL
					kdWarning() <<("xgdocker.cpp:403 You are showing the desktop\n");
#endif					
					/*
					paintBuffer.fill(0);
					repaint(false);
					sleep(1);
					*/
// compiz: 					imgFakeBackground=imgBackground;
				}
				// save the state
				lastRaise=isRaised;
	// 0.35
	if(!tAnimateBackground->isActive() && maxDesaturate>0)tAnimateBackground->start(250);

			}
			// starting paint background
			// new patch 20040602
			// to avoid transparency error
			
			/*
			bitBlt(&paintBuffer,
					0,
					0,
					&imgFakeBackground,0,Qt::CopyROP);
			*/
			// 0.27
//			int fakeY=ActiveConfiguration->Window.Height-fakeHeightDesktop;
//			int fakeBY=0;
			// 1.0.1
			if(LayoutPosition==LONTOP)
			{
//				fakeY=0;
//                                fakeBY=alternativeHeightDesktop;
			// contenuto schermo
// compiz: 			bitBlt(&imgFakeBackgroundGlobal,
// compiz: 					0,
// compiz: 					fakeBY,
// compiz: 					&imgFakeBackground,0,0,
// compiz: 					ActiveConfiguration->Window.Width,
// compiz: 					ActiveConfiguration->Window.Height-fakeBY,Qt::CopyROP);
			// background
// compiz: 			bitBlt(&imgFakeBackgroundGlobal,
// compiz: 				0,
// compiz: 				fakeY,
// compiz: 				&imgBackground,0,fakeY,
// compiz: 				ActiveConfiguration->Window.Width,
// compiz: 				fakeHeightDesktop-fakeY
// compiz: 				,Qt::CopyROP);
			}
			else
			{
// compiz: 			bitBlt(&imgFakeBackgroundGlobal,
// compiz: 					0,
// compiz: 					fakeBY,
// compiz: 					&imgFakeBackground,0,Qt::CopyROP);
// compiz: 			bitBlt(&imgFakeBackgroundGlobal,
// compiz: 				0,
// compiz: 				fakeY,
// compiz: 				&imgBackground,0,fakeY,
// compiz: 				ActiveConfiguration->Window.Width,
				//ActiveConfiguration->Window.HeightDesktop
				// 0.27
// compiz: 				fakeHeightDesktop
				//fakeHeightDesktop
// compiz: 				,Qt::CopyROP);
			}
		}
		else
		{
			// we are closed simpli release resources
			if(lastRaise!=isRaised)
			{
// Moved to SmoothTimeout due to compiz-kompmgr error
				releaseMouse();
				xUpdateSmooth();
/*
				lastRaise=isRaised;
				//xEventReset(xLastX,xLastY);
				// compiz_wnd:
				repaint(false);
				qApp->syncX();
				setMask(maskBackground);
				qApp->syncX();
*/
			}
		}
#ifndef ENABLE_FINAL
	PrintaErroreLivello("xUpdatePart1(int,int)","",-1);
#endif

}

QImage * XGDockerFake::xGetBackground()
{
// compiz: 	return &imgFakeBackgroundGlobal;
	return &paintBuffer;
}

void XGDockerFake::xStep()
{
	uint k=0;
	////qWarning("void XGDockerFake::xStep()");
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{

		// 0.38
		if(activeIcons[iconIndex]->dAnimateStatus
	//		&& 
	//		mouseMoveTimeElapsed.elapsed()>50
		)
		{
			k++;
			activeIcons[iconIndex]->xStep();
			//int z=activeIcons[iconIndex]->xZoom;
			//activeIcons[iconIndex]->xZoom=0;
			// done in GIcon
			//activeIcons[iconIndex]->xSetZoom();
			xUpdateRepaintInline(iconIndex);
			nanosleep(&req2,&rem);

		}

	}
	if(k==0)polling->stop();
}

void XGDockerFake::xCheckBackgroundSeparators()
{
	int nIconsBefore=0;
	for(int i=(int)activeIconsCounter-1;i>=0;i--)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.className.endsWith("GSeparator","false"))
		{
			if(nIconsBefore<1)
			{
				XSGObjectIcon *itorm=ActiveConfiguration->ObjectsIcons.at(i);
				Configurator->xEventInRemovingIcon(i,1);
				ActiveConfiguration->RollingIcons.remove(itorm);
			}

			nIconsBefore=0;
		}
		else
		{
			if(!ActiveConfiguration->ObjectsIcons.at(i)->Info.className.startsWith("x","false")
				&&
				ActiveConfiguration->ObjectsIcons.at(i)->TimeToLive==0
			)
			{
				//nIconsBefore++;
				break;
			}
			else nIconsBefore++;
		}
	}
}

void XGDockerFake::xStartStepping()
{
	polling->start(200);
}


void XGDockerFake::xParse(const QString &Action, int, void *)
{
	if(Action=="xRestore")xRestore();
	else if(Action=="xStartAnimateBackground")xStartAnimateBackground();
	else if(Action=="xStopAnimateBackground")xStopAnimateBackground();
	else if(Action=="xRecalibrate")xRecalibrate();
	else kdWarning()<<QString("Unknown action, %1, performed to %1")<<Action<<(name());
}
void XGDockerFake::xGetInfo(QStringList &a)
{
	QStringList PluginInformations;
	QString Version=KXDOCKERVERSION;
	Version=Version+"-1.1.0";
	PluginInformations.append("KXDocker GXDockerComposite");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append(KXDOCKERDATE); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=manual");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download")); // url update
	
	a=PluginInformations;
}


/*!
    \fn XGDockerFake::xGetParameterList(QStringList *)
 */
void XGDockerFake::xGetParameterList(QStringList *)
{
    /// @todo implement me
}


/*!
    \fn XGDockerFake::xGetParameter(const QString, QString&)
 */
void XGDockerFake::xGetParameter(const QString, QString&)
{
    /// @todo implement me
}


/*!
    \fn XGDockerFake::xSetupParameter(const QString, const QString)
 */
void XGDockerFake::xSetupParameter(const QString, const QString)
{
    /// @todo implement me
}


/*!
    \fn XGDockerFake::xSwapIcons(int,int)
 */
void XGDockerFake::xSwapIcons(int a,int b)
{
#ifndef ENABLE_FINAL
kdWarning()<<QString("xSwapIcons(%1,%1)\n").arg(a).arg(b);
#endif
	if(a==b|| a<0||b<0||a>=(int)activeIconsCounter||b>=(int)activeIconsCounter)return;


	XGIcon *addedIcon=activeIcons[a];
	/***********************/
	Matrix->xMakeSpace(b,&addedIcon->xPosFixed);
	addedIcon->xPosDefault=addedIcon->xPosFixed;
	addedIcon->xPosDefault.setX(addedIcon->xPosFixed.x()+xMakeWidgetCenterDeltaX);
	addedIcon->xPosition=addedIcon->xPosDefault;
	addedIcon->xHotspot.setX(addedIcon->xPosDefault.x()+ActiveConfiguration->Icons.Size/2);
	addedIcon->xHotspot.setY(addedIcon->xPosDefault.y()+ActiveConfiguration->Icons.Size/2+ActiveConfiguration->Icons.Raise);
	addedIcon->xZoom=ActiveConfiguration->Icons.Size;
	/***********************/
	addedIcon=activeIcons[b];
	Matrix->xMakeSpace(a,&addedIcon->xPosFixed);
	addedIcon->xPosDefault=addedIcon->xPosFixed;
	addedIcon->xPosDefault.setX(addedIcon->xPosFixed.x()+xMakeWidgetCenterDeltaX);
	addedIcon->xPosition=addedIcon->xPosDefault;
	addedIcon->xHotspot.setX(addedIcon->xPosDefault.x()+ActiveConfiguration->Icons.Size/2);
	addedIcon->xHotspot.setY(addedIcon->xPosDefault.y()+ActiveConfiguration->Icons.Size/2+ActiveConfiguration->Icons.Raise);
	addedIcon->xZoom=ActiveConfiguration->Icons.Size;

	activeIcons[b]=activeIcons[a];
	activeIcons[a]=addedIcon;
	if(activeIcons[a]->xExclude)updateBackgroundSeparator(a);
	if(activeIcons[b]->xExclude)updateBackgroundSeparator(b);
	activeIcons[b]->xSetSmoothZoom();
	activeIcons[a]->xSetSmoothZoom();

	return;
}


/*!
    \fn XGDockerFake::xRecalibrate()
 */
inline void XGDockerFake::xRecalibrate()
{
	// patch 18042004 check out the align
	//0.30
	xUpdateBackgroundCoords();
	XGIcon::ActiveConfiguration=ActiveConfiguration;
	XGIconTextMaker::ActiveConfiguration=ActiveConfiguration;
	ActiveConfiguration->Window.borderLeft=
		ActiveConfiguration->Matrix.KMatrix
			//[ActiveConfiguration->Matrix.sizeMatrix*2-1];
			[0]
			+ActiveConfiguration->Icons.Size+16;

// compiz: 		imgBackground.create(ActiveConfiguration->Window.Width,
// compiz: 			ActiveConfiguration->Window.Height,32);
// compiz: 	imgFakeBackgroundGlobal.create(ActiveConfiguration->Window.Width,
// compiz: 		ActiveConfiguration->Window.Height,32);
	paintBuffer.create(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height,32);

	paintBuffer.setAlphaBuffer(false);
	paintBuffer.fill(0);
	paintBuffer.setAlphaBuffer(true);

	maskBackground.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskSliding.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskBuffer.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskBackground.fill(Qt::color0);
	maskSliding.fill(Qt::color0);
	maskFull.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskFull.fill(Qt::color1);
	
	// 0.27
	//fakeDesktop.resize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.HeightDesktop);
	fakeDesktop.resize(ActiveConfiguration->Window.Width,ActiveConfiguration->Icons.Size+16);
	
	fakeDesktop.fill(Qt::color1);
	
	maskBuffer.fill(Qt::color0);
}
