/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_MOUSE_H
#define XEPLUGIN_MOUSE_H

#include <qobject.h>
#include <X11/Xlib.h>
class QTimer;
class XSConfigurations;
class XGDocker;
class QWidget;
class QMutex;


/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_Mouse : public QObject
{
Q_OBJECT
public:
    XEPlugin_Mouse(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_Mouse();
protected:
	QTimer	*MouseTimer;
	XSConfigurations *ActiveConfiguration;
	XGDocker	*xGDocker;
	Display *display;
	Window root, RootIDRet, ChildIDRet;
	unsigned int StateMask;
	QWidget *xGDockerWindow;
	int x,y;
	int PollingTimeout;
	QMutex *MousePollingMutex;
public slots:
	void xSetup();
	void xStart();
	void xStop();
	void xGetParameter(const QString,QString&);
	void xGetParameterList(QStringList*);
protected slots:
	void xEventMouseMoved(int,int);
	void xEventDockerHidden();
	void stepMouseTracking();

	void stepMouseTimer();
	void xEventDockerSendToBackground();
signals:
	//void xGetWidget(QWidget *&);
	void mouseMoveSoftware(int,int);
};

#endif
