/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini                               *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "testlibgui.h"

#include "libkxdocker.h"

#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpixmap.h>


testlibgui::testlibgui(QWidget* parent, const char* name, bool modal, WFlags fl)
: wLibKXDocker(parent,name, modal,fl)
{
	QString ApplicationName="libkxdocker";
	if(name!=NULL)
	{
		ApplicationName=name;
	}
	KXDocker=new libkxdocker(this,ApplicationName);
	
	// if the class start with x will not be saved into xml user configuration
	KXDocker->setClientClass("xlibkxdocker");

	connect((QObject *)kxEnable,SIGNAL(toggled(bool)),this,SLOT(kShowIcon(bool)));
	connect((QObject *)kxBounce,SIGNAL(clicked()),this,SLOT(bounce()));
	connect((QObject *)kxIcon,SIGNAL(textChanged(const QString &)),this,SLOT(iconChanged(const QString &)));
	connect((QObject *)kxText,SIGNAL(textChanged(const QString &)),this,SLOT(textChanged(const QString &)));
	
	connect((QObject *)kxIconButton,SIGNAL(iconChanged(QString)),this,SLOT(setbIcon(QString)));
	connect((QObject *)kxIconButton_2,SIGNAL(clicked()),this,SLOT(setbIcon2()));
	
	
	// this will load the kxdocker before we SHOW the application window
	// will be traced by name()
	kxEnable->setChecked(true);
}

testlibgui::~testlibgui()
{
	
}

/*$SPECIALIZATION$*/


#include "testlibgui.moc"



/*!
    \fn testlibgui::kShowIcon(bool)
 */
void testlibgui::kShowIcon(bool mostra)
{
	if(mostra)KXDocker->show();
	else KXDocker->hide();
}


/*!
    \fn testlibgui::bounce()
 */
void testlibgui::bounce()
{
	KXDocker->bounce();
}


/*!
    \fn testlibgui::close()
 */
bool testlibgui::close()
{

    return wLibKXDocker::close();
}


/*!
    \fn testlibgui::closeEvent(QCloseEvent *)
 */
void testlibgui::closeEvent(QCloseEvent *e)
{
    KXDocker->hide();
    wLibKXDocker::closeEvent(e);
}


/*!
    \fn testlibgui::textChanged(const QString &)
 */
void testlibgui::textChanged(const QString &news)
{
    KXDocker->setText(news);
}

/*!
    \fn testlibgui::iconChanged(const QString &)
 */
void testlibgui::iconChanged(const QString &news)
{
	qWarning(news);

	// 0.3 has support for QPixmap &
	KXDocker->loadIcon(news);

}


/*!
    \fn testlibgui::setbIcon(QString)
 */
void testlibgui::setbIcon(QString news)
{
	kxIcon->setText(news);
}

void testlibgui::groupChanged(const QString &a)
{
	qWarning(a);
}



/*!
    \fn testlibgui::setbIcon2
 */
void testlibgui::setbIcon2()
{
	// 0.3 has support for QPixmap &
	//KXDocker->loadIcon(news);
	QPixmap pixmap;
	KXDocker->setPixmap(pixmap);
}
