/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini                               *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "libkxdocker.h"

#include <qlabel.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>

libkxdocker::libkxdocker(QWidget* parent, const char* name)
    : QObject(parent, name)
{
	kxdockerIconIndex=-1;
	
	reset();
	
	client= new DCOPClient();
	client->attach();
	
	findIcon();
	
}

libkxdocker::~libkxdocker()
{
}

#include "libkxdocker.moc"


/*!
    \fn libkxdocker::bounce()
 */
void libkxdocker::bounce()
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
	//,replyData2;
		QCString replyType;
		//,replyType2;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		//qWarning(Nome);
	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "bounceByName(QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			// bounced correctly if kxdocker will find the icon
			//qWarning("void libkxdocker::bounce()");
			}
			else
			{
			//qWarning("error: void libkxdocker::bounce()");
			}
	}
}


/*!
    \fn libkxdocker::hide()
 */
void libkxdocker::hide()
{
	dcopRemoveIcon();
}


/*!
    \fn libkxdocker::show()
 */
void libkxdocker::show()
{
	repaint();
}


/*!
    \fn libkxdocker::setPixmap(const QPixmap &)
 */
void libkxdocker::setPixmap(const QPixmap &a)
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		outgoingStream<<a;
	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "changeImageByName(QString,QPixmap)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			}
			else
			{
			}
	}
}


/*!
    \fn libkxdocker::loadIcon(const QString &)
 */
void libkxdocker::loadIcon(const QString &NewiconImg)
{
	iconImg=NewiconImg;
	dcopSetImage(NewiconImg);

}


/*!
    \fn libkxdocker::clear()
 */
void libkxdocker::clear()
{
	hide();
	reset();
}


/*!
    \fn libkxdocker::roll(bool)
 */
void libkxdocker::roll(bool)
{
    /// @todo implement me
}


/*!
    \fn libkxdocker::rollDown()
 */
void libkxdocker::rollDown()
{
    /// @todo implement me
}


/*!
    \fn libkxdocker::rollUp()
 */
void libkxdocker::rollUp()
{
    /// @todo implement me
}


/*!
    \fn libkxdocker::setText(const QString &)
 */
void libkxdocker::setText(const QString &NewoverText)
{
	overText=NewoverText;
	dcopSetText(NewoverText);
}


/*!
    \fn libkxdocker::setClientClass(const QString &)
 */
void libkxdocker::setClientClass(const QString &NewtaskClass)
{
	taskClass=NewtaskClass;
}


/*!
    \fn libkxdocker::setClientCaption(const QString &)
 */
void libkxdocker::setClientCaption(const QString &NewwindowTitle)
{
	windowTitle=NewwindowTitle;
}


/*!
    \fn libkxdocker::setClientTask(const QString &)
 */
void libkxdocker::setClientTask(const QString &NewtaskName)
{
	taskName=NewtaskName;
}


/*!
    \fn libkxdocker::setAliasName(const QString &)
 */
void libkxdocker::setAliasName(const QString &NewfileName)
{
	fileName=NewfileName;
}


/*!
    \fn libkxdocker::setGroup(const QString &)
 */
void libkxdocker::setGroup(const QString &NewgroupName)
{
	groupName=NewgroupName;
}


/*!
    \fn libkxdocker::setIconClassName(const QString &)
 */
void libkxdocker::setIconClassName(const QString &NewiconClass)
{
	iconClass=NewiconClass;
}


/*!
    \fn libkxdocker::setName(const QString &)
 */
void libkxdocker::setName(const QString &NewiconName)
{
	iconName=NewiconName;
}


/*!
    \fn libkxdocker::setOnClickExec(const QString &)
 */
void libkxdocker::setOnClickExec(const QString &NewonClickExec)
{
	onClickExec=NewonClickExec;
}


/*!
    \fn libkxdocker::setIconData()
 */
void libkxdocker::setIconData(
const QString &NewiconName,
const QString &NewiconImg,
const QString &NewoverText,
const QString &NewonClickExec,
const QString &NewiconClass,
const QString &NewgroupName,
const QString &NewfileName,
const QString &NewwindowTitle,
const QString &NewtaskName,
const QString &NewtaskClass
)
{
	iconName=NewiconName;
	iconImg=NewiconImg;
	overText=NewoverText;
	onClickExec=NewonClickExec;
	iconClass=NewiconClass;
	groupName=NewgroupName;
	fileName=NewfileName;
	windowTitle=NewwindowTitle;
	taskName=NewtaskName;
	taskClass=NewtaskClass;
}


/*!
    \fn libkxdocker::repaint()
 */
void libkxdocker::repaint()
{
	kxdockerIconIndex=findIcon();
	if(kxdockerIconIndex==DCOPINDEXNONE)
	{
		// we have to add it!
		dcopAddIcon();
	}
	else
	{
		// ok we have the icon
		dcopSetImage(iconImg);
		dcopSetText(overText);
	}
}


/*!
    \fn libkxdocker::findIcon()
 */
int libkxdocker::findIcon()
{
	int foundedIcon=-1;
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;

	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "findIcon(QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="int"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> foundedIcon;
					qWarning(QString("Found icon: %1").arg(foundedIcon));
				
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}
	return foundedIcon;
}


/*!
    \fn libkxdocker::dcopSetImage(const QString &)
 */
void libkxdocker::dcopSetImage(const QString &newImage)
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		outgoingStream<<newImage;
	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "changeImageByName(QString,QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			}
			else
			{
			}
	}
}


/*!
    \fn libkxdocker::dcopSetText(const QString &)
 */
void libkxdocker::dcopSetText(const QString &newText)
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		outgoingStream<<newText;
	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "changeTextByName(QString,QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			}
			else
			{
			}
	}
}


/*!
    \fn libkxdocker::dcopAddIcon()
 */
void libkxdocker::dcopAddIcon()
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		outgoingStream<<iconImg;
		outgoingStream<<overText;
		outgoingStream<<onClickExec;
		outgoingStream<<iconClass;
		outgoingStream<<groupName;
		outgoingStream<<fileName;
		outgoingStream<<windowTitle;
		outgoingStream<<taskName;
		outgoingStream<<taskClass;
		if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "addIcon(QString,QString,QString,QString,QString,QString,QString,QString,QString,QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			}
			else
			{
			}
	}
	
}


/*!
    \fn libkxdocker::dcopRemoveIcon()
 */
void libkxdocker::dcopRemoveIcon()
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
	//,replyData2;
		QCString replyType;
		//,replyType2;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		//qWarning(Nome);
	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "removeByName(QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			// bounced correctly if kxdocker will find the icon
			//qWarning("void libkxdocker::bounce()");
			}
			else
			{
			//qWarning("error: void libkxdocker::bounce()");
			}
	}}


/*!
    \fn libkxdocker::reset()
 */
void libkxdocker::reset()
{
	iconName=name();
	iconImg=iconName;
	overText=iconName;
	onClickExec=iconName;
	iconClass="GIcon";
	groupName=iconName;
	fileName=iconName;
	windowTitle=iconName;
	taskName=iconName;
	taskClass=iconName;
}



/*!
    \fn libkxdocker::stopBounce()
 */
void libkxdocker::stopBounce()
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
	//,replyData2;
		QCString replyType;
		//,replyType2;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		//qWarning(Nome);
	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "stopBounceByName(QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			// bounced correctly if kxdocker will find the icon
			//qWarning("void libkxdocker::bounce()");
			}
			else
			{
			//qWarning("error: void libkxdocker::bounce()");
			}
	}
}


/*!
    \fn libkxdocker::startBounce()
 */
void libkxdocker::startBounce()
{
	if(client->isApplicationRegistered(DCOPKXDOCKERNAME)){
		QByteArray outgoingData;
        	QByteArray replyData;
	//,replyData2;
		QCString replyType;
		//,replyType2;
		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		outgoingStream<<iconName;
		//qWarning(Nome);
	        if(client->call(DCOPKXDOCKERNAME,
                        DCOPKXDOCKERIFACE,
                        "startBounceByName(QString)",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
			// bounced correctly if kxdocker will find the icon
			//qWarning("void libkxdocker::bounce()");
			}
			else
			{
			//qWarning("error: void libkxdocker::bounce()");
			}
	}
}
