/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_trayiconlogger.h"
#include <libkxdocker.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <qcheckbox.h>
#include <kaboutdialog.h>
#include <kaboutapplication.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <qfile.h>
#include <qdir.h>
//extern const char version [];

extern "C" QObject *xeplugin_register(QObject *)
{
        const char NOME[]="xTray";
        return (new XEPlugin_TrayIconLogger(NULL,NOME));
}


XEPlugin_TrayIconLogger::XEPlugin_TrayIconLogger(QWidget *, const char *name)
: KSystemTray((QWidget *)XEObject::xGetDocker(), name)
{
	XEObject::xPluginAdd(this);
	trobbler="kxdocker/themes/trobblers/default";
	connect(&trobblerAnimator,SIGNAL(timeout()),this,SLOT(step()));
	trobblerlastStep=0;
	trobblerList.clear();
	trobblerLastabsolutePath="";
	startupAddedCounter=0;
}


XEPlugin_TrayIconLogger::~XEPlugin_TrayIconLogger()
{
	xStop();
	XEObject::xPluginDel(this);
}


#include "xeplugin_trayiconlogger.moc"

void XEPlugin_TrayIconLogger::xParse(const QString &action, int, void *pointer)
{
	if(action=="about")xAbout();
	else if(action.startsWith("xAppendGenericMenu("))
	{
		QString ModuleToLoad=action.mid(strlen("xAppendGenericMenu("));
		if(ModuleToLoad.length()>0&&ModuleToLoad[ModuleToLoad.length()-1]==')')
		{
			ModuleToLoad=ModuleToLoad.left(ModuleToLoad.length()-1);
		}
		if(pointer==NULL)return;
		// ok than we can add new submenu
		KPopupMenu *Menu=contextMenu();
		KPopupMenu *SubMenu=(KPopupMenu *)pointer;
		Menu->insertItem(i18n(ModuleToLoad),SubMenu);
	}
}


void XEPlugin_TrayIconLogger::xSetup()
{
	// Emits Signal of warning
#ifndef ENABLE_FINAL
	xWarningMsg(this,"xSetup");
#endif
	// load cfg
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	fetchDefaultParameters();

	QString baseImage="";
	xFindTrobbler(trobbler,baseImage,0);
	if(baseImage=="")
	{
		xFindTrobbler("kxdocker/themes/trobblers/default/",baseImage,0);
	}
	if(baseImage=="")
	{
		xFindTrobbler("kxdocker/themes/icons/kxdocker-help.png",baseImage,0);
	}
	if(baseImage=="")
	{
		xActiveIcon=loadIcon("kxdocker");
	}
	//else(xActiveIcon.load(baseImage));
	else(xActiveIcon=loadIcon(baseImage));
	setPixmap(xActiveIcon);
	
	// setup the popup configurations
	KPopupMenu *Menu=contextMenu();
	Menu->setCheckable ( true);
	Menu->insertTitle(loadIcon("window_new"),"Task manager");
	//QCheckBox	*aaaa=new QCheckBox("Show windows from all desktops",NULL);
	//Menu->insertItem(aaaa);
	//m_popup->setItemChecked(m_selectedItem, false);
	connect(this,SIGNAL(xFindResource(const QString &, QString &)),
		Configurator,SLOT(xFindResource(const QString &, QString &)));

	QObject	*xTaskManager=XEObject::xFindObject("xTaskManager");
	idShowAll=0;
	if(xTaskManager)
	{
		idShowAll=Menu->insertItem(loadIcon("desktop"),"Show windows from all desktops",
			this,SLOT(xToggleShowAll()));
		connect
		(
			this,
			SIGNAL(xTaskMgr_GetParameter(const QString, int&)),
			xTaskManager,
			SLOT(xGetParameter(const QString, int&))
		);
		connect
		(
			this,
			SIGNAL(xToggleShowAllDispatch()),
			xTaskManager,
			SLOT(xToggleShowAll())
		);
		connect(xTaskManager,SIGNAL(xEventStartAnimating(const QString &)),this,SLOT(xEventStartAnimating(const QString &)));
		connect(xTaskManager,SIGNAL(xEventStopAnimating(const QString &)),this,SLOT(xEventStopAnimating(const QString &)));
		
		int allshow=0;
		if(allshow==0)
		{
			Menu->setItemChecked(idShowAll, false);
		}
		else
		{
			Menu->setItemChecked(idShowAll, true);
		}
		xTaskMgr_GetParameter(QString("showWindowsOnlyFromThisDesktop"),allshow);
	}
	
	if(XEObject::xFindObject("xConfigurator")!=NULL || XEObject::xFindObject("xThemeManager")!=NULL)
	{
		Menu->insertTitle(loadIcon("configure"),"Setup docker");
	}
	if(XEObject::xFindObject("xConfigurator")!=NULL)
	{
		Menu->insertItem(loadIcon("configure"),"Configurator",
			XEObject::xFindObject("xConfigurator"),SLOT(xConfigure()));
	}
	if(XEObject::xFindObject("xThemeManager")!=NULL)
	{
		Menu->insertItem(loadIcon("iconthemes"),"Theme Manager",
			XEObject::xFindObject("xThemeManager"),SLOT(xConfigure()));
	}
	Menu->insertItem(loadIcon("player_play"),"Start background Animations",
		XEObject::xGetDocker(),SLOT(xStartAnimateBackground()));
	Menu->insertItem(loadIcon("player_pause"),"Stop background Animations",
		XEObject::xGetDocker(),SLOT(xStopAnimateBackground()));

	Menu->insertTitle(loadIcon("kxdocker"),i18n("Informations"));
	Menu->insertItem(loadIcon("idea"),"About KXDocker",
		this,SLOT(xAbout()));


	/*
	Menu->insertItem(loadIcon("desktop"),"Show windows from all desktops",
		this,SLOT(RunLastCmd()));
	*/
}
void XEPlugin_TrayIconLogger::xStart()
{
	show();
}
void XEPlugin_TrayIconLogger::xStop()
{
	hide();
}
void XEPlugin_TrayIconLogger::xToggleShowAll()
{
	KPopupMenu *Menu=contextMenu();
	xToggleShowAllDispatch();
		int allshow=0;
		if(allshow==0)
		{
			Menu->setItemChecked(idShowAll, false);
		}
		else
		{
			Menu->setItemChecked(idShowAll, true);
		}
}
void XEPlugin_TrayIconLogger::xGetParameter(const QString vname,QString& vvalue)
{
	if(vname=="trobbler")
	{
		vvalue=trobbler;
	}
}
void XEPlugin_TrayIconLogger::xGetParameterList(QStringList*a)
{
	a->append("trobbler");

}
void XEPlugin_TrayIconLogger::xAbout()
{
	static KAboutApplication *ad=new KAboutApplication();
	ad->show();
}
void XEPlugin_TrayIconLogger::step()
{
	//qWarning("void XEPlugin_TrayIconLogger::step()");
	//setPixmap(xActiveIcon);
	QString lastFrameFile;
	if(trobblerList.count()<1)
	{
		trobblerlastStep=0;
		xFindTrobbler(trobbler,lastFrameFile,0);
		if(trobblerList.count()<1)
		{
			trobblerAnimator.stop();
			return;
		}
	}
	else lastFrameFile=trobblerList[trobblerlastStep];
	//qWarning("void XEPlugin_TrayIconLogger::step2()");
	//qWarning(lastFrameFile);

	//xActiveIcon.load(lastFrameFile);
	xActiveIcon=loadIcon(lastFrameFile);
	trobblerlastStep++;
	if(trobblerlastStep>=(int)trobblerList.count())trobblerlastStep=0;
	setPixmap(xActiveIcon);
	if(trobblerList.count()<2)trobblerAnimator.stop();
}
void XEPlugin_TrayIconLogger::xFindTrobbler(const QString baseImage, QString &loadThis, int frameStep)
{
	//qWarning(QString("void XEPlugin_TrayIconLogger::xFindTrobbler(const QString %1, QString &%1, int %1)").arg(baseImage).arg(loadThis).arg(frameStep));
	QString absolutePath;
	QString fileName;
	QFile a;
	QDir d;
	loadThis="";

	absolutePath=::locate("data",baseImage);
	if(absolutePath.isNull()||absolutePath=="")
	{
		return;
	}

	if(trobblerLastabsolutePath==absolutePath)
	{
		loadThis=trobblerList[frameStep];
		return;
	}


	d.setPath(absolutePath);
	if(d.exists())
	{
		trobblerLastabsolutePath=absolutePath;
		d.setFilter(QDir::Files | QDir::Hidden);
		d.setSorting(QDir::Name);
	        const QFileInfoList *list = d.entryInfoList();
        	QFileInfoListIterator it( *list );
        	QFileInfo *fi;
		while ( (fi = it.current()) != 0 ) {
			fileName=absolutePath+"/";
			fileName=fileName+fi->fileName();
			trobblerList.append(fileName);
			++it;
		}
	}
	else
	{
		// it's a filename
		a.setName(absolutePath);
		if(a.exists())
		{
			loadThis=absolutePath;
		}
		else
		{
			return;
		}
	}
}
void XEPlugin_TrayIconLogger::fetchDefaultParameters()
{
	//qWarning("void XEPlugin_TrayIconLogger::fetchDefaultParameters()");
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		//qWarning(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name);
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xTray")
		{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
		{
			trobbler=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("trobbler", "kxdocker/themes/trobblers/default/");
			//qWarning(QString("trobbler=%1").arg(trobbler));
		}
		else
		{
		// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
		
		}
		
		break;
		}
	
	}
}
void XEPlugin_TrayIconLogger::xSetupParameter(const QString vname,const QString vvalue)
{
	if(vname=="trobbler")
	{
		trobbler=vvalue;
		trobblerAnimator.stop();
		trobblerLastabsolutePath="";
		trobblerlastStep=0;
		trobblerList.clear();
		trobblerAnimator.start(500);
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xTray")
			{
			// update xml configuration
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
			("trobbler",trobbler);
			}
		}

	}
}


/*!
    \fn XEPlugin_TrayIconLogger::xEventStartAnimating(const QString &)
 */
void XEPlugin_TrayIconLogger::xEventStartAnimating(const QString &)
{
	if(startupAddedCounter<1)trobblerAnimator.start(500);
	startupAddedCounter++;
}


/*!
    \fn XEPlugin_TrayIconLogger::xEventStopAnimating(const QString &)
 */
void XEPlugin_TrayIconLogger::xEventStopAnimating(const QString &)
{
	startupAddedCounter--;
	if(startupAddedCounter<1)
	{
		trobblerAnimator.stop();
		QString baseImage="kxdocker/themes/icons/kxdocker-help.png";
		xFindTrobbler(baseImage,baseImage,0);
		if(baseImage=="")
		{
			xActiveIcon=loadIcon("kxdocker");
		}
		else xActiveIcon=loadIcon(baseImage);
		setPixmap(xActiveIcon);
	}
}
