/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_themebrowser.h"
#include <libkxdocker.h>
#include <kdebug.h>
#include <kfileitem.h>
#include <kio/netaccess.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <kstandarddirs.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kdebug.h>
#include <qdatetime.h>
#include <qcombobox.h>
#include <klistview.h>
#include <qlabel.h>
#include "xeplugin_themebrowser.moc"
#include <qtextedit.h>
#include <kurllabel.h>
#include <qpixmap.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qfileinfo.h>


extern "C" QObject *xeplugin_register(QObject *)
{
	const char NOME[]="xThemeManager";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEPlugin_ThemeBrowser(NULL,NOME));
}

XEPlugin_ThemeBrowser::XEPlugin_ThemeBrowser(QWidget *parent, const char *name)
    :wndbrowser(parent, name)
{
	m_TARBZ2="";
	m_Name="";
	m_Type="";
	prev_lastTheme="";
	XEObject::xPluginAdd(this);
}

XEPlugin_ThemeBrowser::~XEPlugin_ThemeBrowser()
{
	XEObject::xPluginDel(this);
}



/*!
    \fn XEPlugin_ThemeBrowser::xLoadXmlUrl(const QString)
 */
void XEPlugin_ThemeBrowser::xLoadXmlUrl(const QString &XMLConf)
{

	qWarning("WebBrowser::xmlLoadXml(const QString &XMLConf)");
	QFile xmlFile;
	xmlFile.setName(XMLConf);
	QDomDocument doc( "KXDocker_Conf" );
	if ( !xmlFile.open( IO_ReadOnly ) )
	{
		return;
	}
	if ( !doc.setContent( &xmlFile) ) {
		xmlFile.close();
		return;
	}
	xmlFile.close();
	QFileInfo fInfo(XMLConf);
	lastupdate->setText(fInfo.lastModified().toString("d MMM yyyy hh:mm"));
	qWarning("WebBrowser::xmlLoadXml(const QString &XMLConf) !doc.setContent( &xmlFile)");
	// Document Root
	QDomElement docElem = doc.documentElement();
	// .general
	//QDomNodeList xmlGeneral=docElem.elementsByTagName("xiaprojects");
	//if(xmlGeneral.count()>0)
	{
	qWarning("WebBrowser::xmlLoadXml(const QString &XMLConf) xmlGeneral.count()>0");
		//QDomNodeList xmlEngine=xmlGeneral.item(0).toElement().elementsByTagName("level");
		QDomNodeList xmlEngine=docElem.elementsByTagName("level");
		if(xmlEngine.count()>0)
		{
	qWarning("WebBrowser::xmlLoadXml(const QString &XMLConf) xmlEngine.count()>0");

			for(uint kLevel=0;kLevel<xmlEngine.count();kLevel++)
			{
				//qWarning(xmlEngine.item(kLevel).toElement().attribute("name",""));
				if(xmlEngine.item(kLevel).toElement().attribute("name","")=="kxdocker_themes")
				{
					//qWarning("fetched correctly");
					xmlMenu=xmlEngine.item(kLevel).toElement().elementsByTagName("menu");
					xmlMirrors=xmlEngine.item(kLevel).toElement().elementsByTagName("mirror");
					xmlContent=xmlEngine.item(kLevel).toElement().elementsByTagName("theme");
					if(xmlContent.count()>0)xSetupParameter("lasttheme",xmlContent.item(xmlContent.count()-1).toElement().attribute("name",""));
					cfg_fill_theme_mirror(xmlContent);
					cfg_fill_theme_menu(xmlMenu);
					cfg_fill_theme_list(xmlContent);
					//xmlRefreshContent(xmlContent);
					int conta=0;
					int hasAdded=0;
					for(uint kLevel=0;kLevel<xmlContent.count();kLevel++)
					{
						if(xmlContent.item(kLevel).toElement().attribute("ready","")!="1")continue;
						conta++;
						if(prev_lastTheme=="")if(hasAdded<1){hasAdded=1;continue;}
						if(prev_lastTheme==xmlContent.item(kLevel).toElement().attribute("name",""))
						{
							if(hasAdded<1){hasAdded=1;continue;}
						}
						if(hasAdded>0)hasAdded++;
					}
					if(hasAdded==1)
					{
						// none added we revert last theme
						hasAdded=0;
					}
					count->setText(QString("%1").arg(conta));
					nuovi->setText(QString("%1").arg(hasAdded));

				}
			}
		}
	}

}


/*!
    \fn XEPlugin_ThemeBrowser::xParse(const QString &, int, void *)
 */
void XEPlugin_ThemeBrowser::xParse(const QString &action, int, void *)
{
	if(action=="show")this->show();
	if(action=="hide")this->hide();
	if(action.startsWith("xUpdate("))
	{
		QString ModuleToLoad=action.mid(strlen("xUpdate("));
		if(ModuleToLoad.length()>0&&ModuleToLoad[ModuleToLoad.length()-1]==')')
		{
			ModuleToLoad=ModuleToLoad.left(ModuleToLoad.length()-1);
		}
		kdWarning()<<"Trying to download: "<<ModuleToLoad<<"\n";
		EditingFields=1;
		xLoadXmlUrl( ModuleToLoad);
		EditingFields=0;
	}

}


/*!
    \fn XEPlugin_ThemeBrowser::xConfigure()
 */
void XEPlugin_ThemeBrowser::xConfigure()
{
	QString tmpFile=::locateLocal("data","kxdocker/")+"kxdocker_updates.xml";
	xLoadXmlUrl(tmpFile);

	show();
}

void XEPlugin_ThemeBrowser::filter_textChanged(const QString&)
{
	if(EditingFields)return;
	cfg_fill_theme_list(xmlContent);
}
#include <stdlib.h>
void XEPlugin_ThemeBrowser::install_clicked()
{
	// download .tar.bz2 to tmp
	QString u=QString("%1/themes/%1").arg(Mirror->currentText()).arg(m_TARBZ2);
	QString tmpFile;
	qWarning(u);
	if( KIO::NetAccess::download( u, tmpFile, this ) )
	{
		// run tar -jxf tmp
		int ret=system(QString("tar -omjxf '%1' -C '%1'").arg(tmpFile).arg(::locateLocal("data","kxdocker/")));
		if(ret<0)
		{
		}
		else {
			install->setEnabled(false);
			install_theme(m_Name,m_Type);
			remove->setEnabled(true);
			apply->setEnabled(true);
		}
		// check for installation type
		KIO::NetAccess::removeTempFile( tmpFile );
	}
	else
	{
		//KMessageBox::error(this, KIO::NetAccess::lastErrorString() );
	}
}

void XEPlugin_ThemeBrowser::Username_textChanged(const QString&)
{
	if(EditingFields>0)return;
	EditingFields=1;
	xSetupParameter("username",Username->text());
	EditingFields=0;
}

void XEPlugin_ThemeBrowser::Mirror_textChanged(const QString&)
{
	if(EditingFields>0)return;
	EditingFields=1;
	xSetupParameter("mirror",Mirror->currentText());
	EditingFields=0;
}

void XEPlugin_ThemeBrowser::lineEdit3_textChanged(const QString&)
{
}

void XEPlugin_ThemeBrowser::update_clicked()
{

	// download again the xml
	if(Username->text()=="")xSetupParameter("username",QString("Anonymous%1").arg(long(this)));//Username->setText(QString("Anonymous%1").arg(long(this)));
	QString usr=Username->text();
	QString pwd=Password->text();
	QString tmpFile=::locateLocal("data","kxdocker/")+"kxdocker_updates.xml";
	QString u=Mirror->currentText();
	if(u=="")u="http://www.xiaprojects.com/www/prodotti/kxdocker";
	u=u+QString("/getupdates.php?usr=%1&pwd=%1").arg(usr).arg(pwd);
	qWarning(u);
	if( KIO::NetAccess::download( u, tmpFile, this ) )
	{
		//loadFile( tmpFile );
		EditingFields=1;
		xLoadXmlUrl(tmpFile);
		EditingFields=0;
		//KIO::NetAccess::removeTempFile( tmpFile );
	}
	else
	{
		//KMessageBox::error(this, KIO::NetAccess::lastErrorString() );
	}
}

void XEPlugin_ThemeBrowser::cfg_fill_theme_menu(QDomNodeList &xmlThemes)
{
	filter->clear();
	filter->insertItem(i18n("All"));
	filter->insertItem(i18n("Added recently"));
	filter->insertItem(i18n("Installed"));
	for(uint kLevel=0;kLevel<xmlThemes.count();kLevel++)
	{
		QString pinfo=xmlThemes.item(kLevel).toElement().attribute("label","");
		filter->insertItem(i18n(pinfo));
	}
	filter->setCurrentText("All");
}
void XEPlugin_ThemeBrowser::cfg_fill_theme_mirror(QDomNodeList &xmlThemes)
{
}
void XEPlugin_ThemeBrowser::cfg_fill_theme_list(QDomNodeList &xmlThemes)
{
	themelist->clear();
	QString filt=filter->currentText();
	int mustAdd=0;
	int hasAdded=0;
	for(uint kLevel=0;kLevel<xmlThemes.count();kLevel++)
	{
		mustAdd=0;
		if(xmlThemes.item(kLevel).toElement().attribute("ready","")!="1")continue;
		QString pinfo=xmlThemes.item(kLevel).toElement().attribute("label","");
		QString ptipo=xmlThemes.item(kLevel).toElement().attribute("type","");
		if(filter->currentItem()==0)mustAdd=1;
		else if(fetch_label_type(ptipo)==filt)mustAdd=1;
		else if(pinfo.find(filt,0,false)>=0)mustAdd=1;
		else if(filter->currentItem()==1)
		{
			// recently
			if(prev_lastTheme=="")if(hasAdded<1){hasAdded=1;}
			if(prev_lastTheme==xmlThemes.item(kLevel).toElement().attribute("name",""))
			{
				hasAdded++;
			}
			if(hasAdded>0)hasAdded++;
			mustAdd=hasAdded;
		}
		else if(filter->currentItem()==2)
		{
			// installed
			QString pname=xmlThemes.item(kLevel).toElement().attribute("name","");
			QString ninstall=::locateLocal("data",QString("kxdocker/uninstalls/%1").arg(pname));
			QFile ifr(ninstall);
			if(ifr.exists() && ninstall!="" and ninstall!=QString::null and pname!="")
			{
				mustAdd=1;
			}
		}
		if(mustAdd>0)
		{
			QListViewItem	*item=new QListViewItem((QListView *)themelist);
			item->setText(2,pinfo);
			item->setText(1,ptipo);
			item->setText(0,xmlThemes.item(kLevel).toElement().attribute("updated",""));
			themelist->insertItem(item);
		}
	}
}

void XEPlugin_ThemeBrowser::themelist_selectionChanged(QListViewItem*item)
{
	if(item==NULL)return;
	QString selectedItem=item->text(2);

	for(uint kLevel=0;kLevel<xmlContent.count();kLevel++)
	{
		QString pinfo=xmlContent.item(kLevel).toElement().attribute("label","");
		if(selectedItem==pinfo)
		{
			QString ptipo=xmlContent.item(kLevel).toElement().attribute("type","");
			theme_info->setText(selectedItem);
			//theme_type->setText(ptipo);
			info->setText(xmlContent.item(kLevel).toElement().attribute("comment",""));
			QString tmpFile;
			QString u=QString("%1/themes/%1").arg(Mirror->currentText()).arg(xmlContent.item(kLevel).toElement().attribute("image",""));
			m_TARBZ2=xmlContent.item(kLevel).toElement().attribute("file","");
			m_Name=xmlContent.item(kLevel).toElement().attribute("name","");
			m_Type=xmlContent.item(kLevel).toElement().attribute("type","");
			if( KIO::NetAccess::download( u, tmpFile, this ) )
			{
				QPixmap *p=theme_preview->pixmap();
				if(p==NULL)
				{
					p=new QPixmap();
				}
				p->load(tmpFile);
				theme_preview->setPixmap(*p);
			}
			theme_mail->setText(xmlContent.item(kLevel).toElement().attribute("author",""));
			m_Uninstall=::locateLocal("data",QString("kxdocker/uninstalls/%1").arg(m_Name));
			qWarning(m_Uninstall);
			QFile ifr(m_Uninstall);
			if(ifr.exists() && m_Uninstall!="" and m_Uninstall!=QString::null and m_Name!="")
			{
				remove->setEnabled(true);
				apply->setEnabled(true);
				install->setEnabled(false);
			}
			else
			{
				remove->setEnabled(false);
				apply->setEnabled(false);
				install->setEnabled(true);
			}
			break;
		}
	}
}



/*!
    \fn XEPlugin_ThemeBrowser::fetch_label_type(const QString &)
 */
QString XEPlugin_ThemeBrowser::fetch_label_type(const QString &ptipo)
{
	for(uint kLevel=0;kLevel<xmlMenu.count();kLevel++)
	{
		if(ptipo==xmlMenu.item(kLevel).toElement().attribute("name",""))
		{
			QString a=i18n(xmlMenu.item(kLevel).toElement().attribute("label",""));
			return a;
		}
	}
	return ptipo;
}


/*!
    \fn XEPlugin_ThemeBrowser::xGetInfo(QStringList &)
 */
void XEPlugin_ThemeBrowser::xGetInfo(QStringList &a)
{
	QStringList PluginInformations;
	QString Version="0.1";
	PluginInformations.append("KXDocker Theme Manager");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20060202"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=manual");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download")); // url update
	a=PluginInformations;
}


/*!
    \fn XEPlugin_ThemeBrowser::xGetParameter(const QString, QString &)
 */
void XEPlugin_ThemeBrowser::xGetParameter(const QString sName, QString &sValue)
{
	if(sName=="username")
	{
		sValue=(Username->text());
	}
	if(sName=="password")
	{
		sValue=(Password->text());
	}
	if(sName=="lasttheme")
	{
		sValue=lastTheme;
	}
}


/*!
    \fn XEPlugin_ThemeBrowser::xGetParameterList(QStringList *)
 */
void XEPlugin_ThemeBrowser::xGetParameterList(QStringList *a)
{
	a->append("password");
	a->append("username");
	a->append("lasttheme");

}


/*!
    \fn XEPlugin_ThemeBrowser::xSetup()
 */
void XEPlugin_ThemeBrowser::xSetup()
{
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	EditingFields=1;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
		
			if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
			{
				xSetupParameter("password",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("password",""));
				xSetupParameter("username",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("username",""));
				xSetupParameter("lasttheme",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("lasttheme",""));
				prev_lastTheme=lastTheme;
			}
			else
			{
				// Creating fake document
				QDomDocument 	doc( "KXDocker_Conf" );
				// the fake root
				QDomElement fakeRoot=doc.createElement("FakeRoot");
				// appending childs
				doc.appendChild(fakeRoot);
				// now creating the configuration
				QDomElement CreatingCfg=doc.createElement("pluginconf");
				// Ok this is a plugin Configuration
				QStringList	a;
				// Creating the Attributes via the standard plugin interface
				xGetParameterList(&a);
				for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
				{
					QString returnValue;
					xGetParameter(a[istoringXML],returnValue);
					CreatingCfg.setAttribute(a[istoringXML],returnValue);
				}
				// Now appending to the configuration
				fakeRoot.appendChild(CreatingCfg);
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
			}
			break;
		}
	}
	EditingFields=0;
}


/*!
    \fn XEPlugin_ThemeBrowser::xSetupParameter(const QString, const QString)
 */
void XEPlugin_ThemeBrowser::xSetupParameter(const QString sName, const QString sValue)
{
	if(sName=="username")
	{
		Username->setText(sValue);
	}
	if(sName=="password")
	{
		Password->setText(sValue);
	}
	if(sName=="lasttheme")
	{
		lastTheme=sValue;
	}
	updateXMLcfg(sName,sValue);
}


/*!
    \fn XEPlugin_ThemeBrowser::xStart()
 */
void XEPlugin_ThemeBrowser::xStart()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_ThemeBrowser::xStop()
 */
void XEPlugin_ThemeBrowser::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_ThemeBrowser::updateXMLcfg(const QString, const QString)
 */
void XEPlugin_ThemeBrowser::updateXMLcfg(const QString sName, const QString sValue)
{
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute(sName, sValue);
			break;
		}
	}
}


/*!
    \fn XEPlugin_ThemeBrowser::install_theme(const QString, const QString)
 */
void XEPlugin_ThemeBrowser::install_theme(const QString n, const QString t)
{
	QString newPath=::locateLocal("data","kxdocker/");
	if(t=="background")
	{
		newPath=QString("%1/%1/%1").arg(newPath).arg("themes/bar").arg(n);
		ActiveConfiguration->Theme.BackgroundPath=::locate("data",newPath);
		xGDocker->xChangeBackground(ActiveConfiguration->Theme.BackgroundPath);
	}
	else
	if(t=="pillow")
	{
		newPath=QString("%1/%1/%1").arg(newPath).arg("themes/bar").arg(n);
		ActiveConfiguration->Icons.OverTextFont.BackgroundPath=::locate("data",newPath);
		ActiveConfiguration->Icons.MiniTextFont.BackgroundPath=::locate("data",newPath);
	}
	else if(t=="trobber")
	{
	}
	else if(t=="gamarok")
	{
		newPath=QString("%1/%1/%1").arg(newPath).arg("plugins/gamarok").arg(n);
		if(connect(this, SIGNAL(xSetupParameterTo(const QString,const QString)),XEObject::xFindObject("GAmarok"),SLOT(xSetupParameter(const QString,const QString))))
		{
			xSetupParameterTo("themepath",newPath);
			disconnect(this, SIGNAL(xSetupParameterTo(const QString,const QString)));
		}

	}
	else if(t=="gcpu")
	{
		newPath=QString("%1/%1/%1").arg(newPath).arg("plugins/gcpu").arg(n);
		if(connect(this, SIGNAL(xSetupParameterTo(const QString,const QString)),XEObject::xFindObject("GCpu"),SLOT(xSetupParameter(const QString,const QString))))
		{
			xSetupParameterTo("themepath",newPath);
			disconnect(this, SIGNAL(xSetupParameterTo(const QString,const QString)));
		}

	}
	else if(t=="gaclock")
	{
		newPath=QString("%1/%1/%1").arg(newPath).arg("plugins/gaclock").arg(n);
		if(connect(this, SIGNAL(xSetupParameterTo(const QString,const QString)),XEObject::xFindObject("GAClock"),SLOT(xSetupParameter(const QString,const QString))))
		{
			xSetupParameterTo("themepath",newPath);
			disconnect(this, SIGNAL(xSetupParameterTo(const QString,const QString)));
		}

	}
}

void XEPlugin_ThemeBrowser::remove_clicked()
{
	if(m_Uninstall!="" and m_Uninstall!=QString::null)
	{
		int ret=system(QString("cd '%1' && '%1'").arg(::locateLocal("data","kxdocker/")).arg(m_Uninstall));
		if(ret>=0)
		{
			remove->setEnabled(false);
			apply->setEnabled(false);
			install->setEnabled(true);
		}
	}
}

void XEPlugin_ThemeBrowser::apply_clicked()
{
	install_theme(m_Name,m_Type);
}
