/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeevents.h"
#include "xeobject.h"

XEEvents::XEEvents(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xSetEngineEvents(this);
}


XEEvents::~XEEvents()
{
}


#include "xeevents.moc"


/*!
    \fn XEEvents::xReset()
 */
void XEEvents::xReset()
{
    // this will clear the queue
}


/*!
    \fn XEEvents::xSetup()
 */
void XEEvents::xSetup()
{
	/// @This is called when all objects are ready to be connected
	connect(
		XEObject::xGetDocker(),SIGNAL(xWarningMsg(const QObject *, const QString &)),
		XEObject::xFindObject("xTray"),SLOT(xWarningMsg(const QObject *, const QString &))
		);
	connect(
		XEObject::xGetMatrix(),SIGNAL(xWarningMsg(const QObject *, const QString &)),
		XEObject::xFindObject("xTray"),SLOT(xWarningMsg(const QObject *, const QString &))
		);
	connect(
		XEObject::xGetConfiguration(),SIGNAL(xCfgChanged( QObject *)),
		XEObject::xGetMatrix(),SLOT(xCfgChanged( QObject *))
		);	
	connect(
		XEObject::xGetConfiguration(),SIGNAL(xCfgChanged( QObject *)),
		XEObject::xGetDocker(),SLOT(xCfgChanged( QObject *))
		);
}


/*!
    \fn XEEvents::xStart()
 */
void XEEvents::xStart()
{
    /// @todo implement me
}
