/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GTRASH_H
#define XEPLUGIN_GTRASH_H

#include <qstring.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>
#include <libkxdocker.h>
#include <qpixmap.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <kdirlister.h>



/**
@author Stefano
*/
class XEPlugin_GTrash : public gPluginSDK
{
Q_OBJECT
public:
    XEPlugin_GTrash(QObject *parent = 0, const char *name = 0);
    ~XEPlugin_GTrash();

protected:
	//KDirWatch *KDEWatcher;
	KDirLister *mpDirLister;

	QString			incomingIcon;
	QPixmap			BasePixmap;
	QPixmap			IncomingPixmap;
	QString			TrashPath;
	int			iMiniText;

public slots:
    void xGetParameterList(QStringList *);
    void xPaint(int nEmails);
    void xApplyCfg();
    void xGetParameter(const QString, QString&);
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void polling();
    void dirty(const QString &);
    void slotClear();
    void slotCompleted();
    void slotDeleteItem(KFileItem *);

protected:
    void loadImages();
public:
    QObject *Respawn(QObject *p);
};

#endif
