/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "configurationwindow.h"
#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>

#include <kicondialog.h>

WMConfigurationWindow::WMConfigurationWindow(QObject *parent, const char *name)
 : GPluginSDKCfg(0, name)
{
connect(this,SIGNAL(xApplyParameter(const QString, const QString)),parent,SLOT(xSetupParameter(const QString, const QString)));
}


WMConfigurationWindow::~WMConfigurationWindow()
{
}


#include "configurationwindow.moc"

void WMConfigurationWindow::pOK_clicked()
{
	//qWarning("void gPluginSDKCfgWnd::onOK()");

	/*
	xApplyParameter("themepath",ThemePath->text());
	xApplyParameter("showgauge",mGauge->currentText());
	xApplyParameter("icon_mounted",tMounted->currentText());
	xApplyParameter("icon_unmounted",tuMounted->currentText());
	xApplyParameter("mountcmd",MountCmd->currentText());
	xApplyParameter("umountcmd",uMountCmd->currentText());
	xApplyParameter("device",MountPoint->currentText());
	*/
/*
	xApplyParameter("ImageFX_GrayScale",GrayScale->currentText());
	QString stringa;
	stringa.setNum(XDegree->value());
	xApplyParameter("ImageFX_X_degree",stringa);
	stringa.setNum(YDegree->value());
	xApplyParameter("ImageFX_Y_degree",stringa);
	stringa.setNum(Intensity->value());
	xApplyParameter("ImageFX_Intensity",stringa);
*/
	/**************************************/

	//qWarning("void gPluginSDKCfgWnd::onOK()");
//	xApplyParameter("themepath",ThemePath->text());
	emit xApplyParameter("trashscan_empty",baseIcon->icon());
	emit xApplyParameter("trashscan_full",incomingIcon->icon());
	emit xApplyParameter("minitext",QString("%1").arg(MiniText->currentItem()));

	hide();
	


}

void WMConfigurationWindow::xSetupParameter(QString vname,QString vvalue)
{
	bool okRet=false;
/*
	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}

*/
	if(vname=="trashscan_full")
	{
		incomingIcon->setIcon(vvalue);
	}
	if(vname=="trashscan_empty")
	{
		baseIcon->setIcon(vvalue);
	}
	if(vname=="minitext")
	{
		int i=vvalue.toInt(&okRet);
		MiniText->setCurrentItem(i);
	}



	/*
	if(vname=="device")
	{
		MountPoint->setCurrentText(vvalue);
	}
	if(vname=="mountcmd")
	{
		MountCmd->setCurrentText(vvalue);
	}
	if(vname=="umountcmd")
	{
		uMountCmd->setCurrentText(vvalue);
	}

	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}
	if(vname=="showgauge")
	{
		mGauge->setCurrentText(vvalue);
	}
	if(vname=="icon_mounted")
	{
		tMounted->setCurrentText(vvalue);
	}
	if(vname=="icon_unmounted")
	{
		tuMounted->setCurrentText(vvalue);
	}
	*/


/*
	if(vname=="ImageFX_GrayScale")
	{
		GrayScale->setCurrentText(vvalue);
	}
	if(vname=="ImageFX_X_degree")
	{
		XDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)XDegree->setValue(0);
	}
	if(vname=="ImageFX_Y_degree")
	{
		YDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)YDegree->setValue(0);
	}
	if(vname=="ImageFX_Intensity")
	{
		Intensity->setValue(vvalue.toInt(&okRet));
		if(!okRet)Intensity->setValue(100);
	}

*/
}




/*!
    \fn gPluginSDKCfgWnd::onBrowseThemes()
 */
void WMConfigurationWindow::onBrowseThemes()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	//ThemePath->setText(cfgPath);

}

