//
// C++ Implementation: gtrash
//
// Description: 
//
//
// Author: Stefano <stefano@xiaprojects.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gtrash.h"
#include "gtrash.moc"

#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <string.h>
#include <kconfig.h>
#include <kurlrequester.h>
#include <kglobalsettings.h>
#include <klocale.h>

extern "C" QObject *xeplugin_register(QObject *parent)
{
	qWarning("GTrash xeplugin_register()");
	return new GTrash(parent,"GTrash");
}


GTrash::GTrash(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="Trashscan";


	// compatibility with 0.29
	QString Version="0.4";
	PluginInformations.append("KXDocker GTrash");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20050819"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gtrash");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gtrash");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update

/*
	// ok, here we have to find the path of trash
	KConfig *cfg=KGlobal::config();
	cfg->setGroup("Paths");
	//TrashPath=KURL(cfg->readEntry("Trash"));//.directory();
	//TrashPath=cfg->readEntry("Trash");
	KURLRequester *urTrash ;
	urTrash = new KURLRequester();
	urTrash->setMode( KFile::Directory );
	urTrash->setURL( KGlobalSettings::trashPath() );
	TrashPath=urTrash->url();


	
	KDEWatcher=new KDirWatch();
	connect(KDEWatcher, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));

*/
	TrashPath="trash:/";

	mpDirLister = new KDirLister();


	mpDirLister->openURL(TrashPath);
	iMiniText=1;


}


GTrash::~GTrash()
{
}




/*!
    \fn GTrash::xGetParameterList(QStringList *a)
 */
void GTrash::xGetParameterList(QStringList *a)
{
	a->append("trashscan_empty");
	a->append("trashscan_full");
	a->append("minitext");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
	
}


/*!
    \fn GTrash::xGetParameter(const QString vname, QString&vvalue)
 */
void GTrash::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="trashscan_empty")
	{
		vvalue=IconsPath;
	}
	if(vname=="trashscan_full")
	{
		vvalue=incomingIcon;
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	
	gPluginSDK::xGetParameter(vname,vvalue);
}




void GTrash::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;


	if(vname=="trashscan_full")
	{
		incomingIcon=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("trashscan_full",incomingIcon);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);

	}
	if(vname=="trashscan_empty")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("trashscan_empty",IconsPath);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
	}
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}



	gPluginSDK::xSetupParameter(vname,vvalue);

}

void GTrash::xStart()
{
	connect( mpDirLister, SIGNAL( clear() ),
                 this, SLOT( slotClear() ) );
	connect( mpDirLister, SIGNAL( completed() ),
                 this, SLOT( slotCompleted() ) );
	connect( mpDirLister, SIGNAL( deleteItem( KFileItem * ) ),
		this, SLOT( slotDeleteItem( KFileItem * ) ) );


	gPluginSDK::xStart();

//	KDEWatcher->addDir(TrashPath);
}


void GTrash::xStop()
{
//	KDEWatcher->removeDir(TrashPath);
	disconnect( mpDirLister, SIGNAL( clear() ),
                 this, SLOT( slotClear() ) );
	disconnect( mpDirLister, SIGNAL( completed() ),
                 this, SLOT( slotCompleted() ) );
	disconnect( mpDirLister, SIGNAL( deleteItem( KFileItem * ) ),
		this, SLOT( slotDeleteItem( KFileItem * ) ) );


	gPluginSDK::xStop();
	//internalStatus=0;


}



void GTrash::polling()
{
	if(isStopped){
		return;
	}
	Value=0;
	/*
	if(TrashPath=="")return;
	
	QDir a;
	a.setPath(TrashPath);
	//if(a.exists()==false)return;
	a.setFilter(QDir::All);
	KIconLoader KDEIconLoader;
	QPixmap Pixmap;
	if(a.entryList().count()>2)
	{
		Value=a.entryList().count()-2;
	}
	else
	{
		Value=0;
	}
	*/
	Value = mpDirLister->items(KDirLister::AllItems).count();
	
	//qWarning(QString("Cestino: %1 %1").arg(Value).arg(TrashPath));
	xRefreshIcon(xGIcon);
}


void GTrash::loadImages()
{
	KIconLoader KDEIconLoader;
	QString kdeshare="kxdocker/plugins/gtrash/";
	QString iPaths=IconsPath;
	//qWarning(iPaths);
	xFindResource("icon",iPaths);
	//iPaths=::locate("data",iPaths);
	//qWarning(iPaths);
	QFile a(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"trashscan_empty.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		iPaths=IconsPath;
		BasePixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{
		BasePixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}

	iPaths=incomingIcon;
	xFindResource("icon",iPaths);
	//iPaths=::locate("data",iPaths);
	a.setName(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail_incoming.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		//IncomingPixmap=BasePixmap;
		iPaths=incomingIcon;
		IncomingPixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{
		IncomingPixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
		//IncomingPixmap.load(iPaths);
	}
	if(IncomingPixmap.isNull())IncomingPixmap=BasePixmap;
}



void GTrash::xPaint(int iTrash)
{
	if(!iTrash)
	{
		// we restore the base Image
		*xImgSource=BasePixmap.convertToImage();
		ToolTip=i18n("empty");
		if(iMiniText==1)ToolTip2="";
	}
	else
	{
		*xImgSource=IncomingPixmap.convertToImage();
		ToolTip=i18n(QString("%1 trashed").arg(iTrash));
		if(iMiniText==1)ToolTip2.setNum(iTrash);
	}
}


/*!
    \fn GTrash::xApplyCfg()
 */
void GTrash::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("trashcan_empty","trashcan_empty");
			incomingIcon=xXMLIconConfig->item(0).toElement().attribute("trashcan_full","trashcan_full");
			QString sMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1");

			bool okRet=false;
			iMiniText=sMiniText.toInt(&okRet);
			if(okRet==false)iMiniText=1;
	}
	BasePixmap.convertFromImage(*xImgSource);
	loadImages();
	lastValue=-1;
}


/*!
    \fn GTrash::dirty(const QString &)
 */
void GTrash::dirty(const QString &)
{
	polling();
}


/*!
    \fn GTrash::slotClear()
 */
void GTrash::slotClear()
{
	polling();
}


/*!
    \fn GTrash::slotCompleted()
 */
void GTrash::slotCompleted()
{
	polling();
}


/*!
    \fn GTrash::slotDeleteItem(KFileItem *)
 */
void GTrash::slotDeleteItem(KFileItem *)
{
//	Value--;
	polling();
}
