/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GTHROTTLE_H
#define XEPLUGIN_GTHROTTLE_H

#include <qobject.h>
#include <libkxdocker.h>

class DCOPClient;
class ACPI_CPU_Info;
class gPluginPainter;

class GThrottle : public gPluginSDK
{
  Q_OBJECT
public:
	GThrottle(QObject *parent = 0, const char *name = 0);
	~GThrottle();
	QObject *   Respawn(QObject *);
public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void dirty(int);
    virtual void xStop();
    virtual void xStart();

protected:
	QString themepath;
	QString defaultBackground;

	void loadResources(const QString);
	//int IconSize;
	ACPI_CPU_Info *acpi;
	//gPluginPainter *Painter;
	//gPluginPainter *PainterFan;
	QImage	*Painters[3];
	QImage	lastImage;
	QImage	background;
	QImage	imgCPU;
	QImage	imgNumber[10];

	QString cpuName;
	/*
	QPixmap lastImage;
	QPixmap background;
	QPixmap imgCPU;
	QPixmap imgNumber[10];
	*/
	long fan;
	long	ThermalValue;
	long	ThrottleValue;
	int	GaugeInfo[3];
	long	GaugeMax[3];
	long	GaugeMin[3];
};


class ACPI_CPU_Info
{
	public:
		ACPI_CPU_Info();
		~ACPI_CPU_Info();
		int open(const QString);
		void close();
		int temperature();
		int fan();
    long scaling();
	protected:
		QString cpuName;
		QString procTemperature;
		QString procTemperature2;
		QString procTemperature3;
		QString procThrottle;
		QString sysThrottle;
		QString procI8K;
		FILE *fd;
		FILE *fdfan;
		FILE *fdscaling;
		char buf[128];
		char intString[5];
};

#endif
