//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gpluginsdkcfgwnd.h"

#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>
#include "gpluginsdkcfgwnd.moc"

#include <kicondialog.h>
#include <qcheckbox.h>

gPluginSDKCfgWnd::gPluginSDKCfgWnd(QObject *parent, const char *name)
    :GPluginSDKCfg(0, name)
{
	Plugin=parent;
	connect(this,SIGNAL(xApplyParameter(const QString, const QString)),
		Plugin,SLOT(xSetupParameter(const QString, const QString)));
	connect(pOK,SIGNAL(clicked()),this,SLOT(onOK()));
//	connect(pBrowseTheme,SIGNAL(clicked()),this,SLOT(onBrowseThemes()));

}

void gPluginSDKCfgWnd::onOK()
{
	//qWarning("void gPluginSDKCfgWnd::onOK()");

	/*
	xApplyParameter("themepath",ThemePath->text());
	xApplyParameter("showgauge",mGauge->currentText());
	xApplyParameter("icon_mounted",tMounted->currentText());
	xApplyParameter("icon_unmounted",tuMounted->currentText());
	xApplyParameter("mountcmd",MountCmd->currentText());
	xApplyParameter("umountcmd",uMountCmd->currentText());
	xApplyParameter("device",MountPoint->currentText());
	*/
	xApplyParameter("ImageFX_GrayScale",GrayScale->currentText());
	QString stringa;
	stringa.setNum(XDegree->value());
	xApplyParameter("ImageFX_X_degree",stringa);
	stringa.setNum(YDegree->value());
	xApplyParameter("ImageFX_Y_degree",stringa);
	stringa.setNum(Intensity->value());
	xApplyParameter("ImageFX_Intensity",stringa);

	/**************************************/
	stringa.setNum(slideSeconds->value());
	xApplyParameter("slideSeconds",stringa);
	stringa.setNum(SpawnEvery->value());
	xApplyParameter("SpawnEvery",stringa);

	xApplyParameter("cmdRun",cmdRun->currentText());

	if(bBackground->isChecked())xApplyParameter("background",Background->icon());
	else xApplyParameter("background","");

	stringa.setNum(resizeimage->value());
	if(bresizeimage->isChecked())xApplyParameter("resizeimage",stringa);
	else xApplyParameter("resizeimage","0");


	hide();
	

}

void gPluginSDKCfgWnd::xSetParameter(QString vname,QString vvalue)
{
	bool okRet=false;
	if(vname=="cmdRun")
	{
		cmdRun->setCurrentText(vvalue);
	}
	if(vname=="background")
	{
		Background->setIcon(vvalue);
		if(vvalue!="")
		{
			bBackground->setChecked(true);
		}
		else bBackground->setChecked(false);
	}
	if(vname=="slideSeconds")
	{
		slideSeconds->setValue(vvalue.toInt(&okRet));
		if(!okRet)slideSeconds->setValue(60);
	}
	if(vname=="resizeimage")
	{
		resizeimage->setValue(vvalue.toInt(&okRet));
		if(!okRet)resizeimage->setValue(0);
		if(resizeimage->value()>0)
		{
			bresizeimage->setChecked(true);
		}
		else bresizeimage->setChecked(false);

	}
	if(vname=="SpawnEvery")
	{
		SpawnEvery->setValue(vvalue.toInt(&okRet));
		if(!okRet)SpawnEvery->setValue(600);
	}
	/*
	if(vname=="device")
	{
		MountPoint->setCurrentText(vvalue);
	}
	if(vname=="mountcmd")
	{
		MountCmd->setCurrentText(vvalue);
	}
	if(vname=="umountcmd")
	{
		uMountCmd->setCurrentText(vvalue);
	}

	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}
	if(vname=="showgauge")
	{
		mGauge->setCurrentText(vvalue);
	}
	if(vname=="icon_mounted")
	{
		tMounted->setCurrentText(vvalue);
	}
	if(vname=="icon_unmounted")
	{
		tuMounted->setCurrentText(vvalue);
	}
	*/
	if(vname=="ImageFX_GrayScale")
	{
		GrayScale->setCurrentText(vvalue);
	}
	if(vname=="ImageFX_X_degree")
	{
		XDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)XDegree->setValue(0);
	}
	if(vname=="ImageFX_Y_degree")
	{
		YDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)YDegree->setValue(0);
	}
	if(vname=="ImageFX_Intensity")
	{
		Intensity->setValue(vvalue.toInt(&okRet));
		if(!okRet)Intensity->setValue(100);
	}
}




/*!
    \fn gPluginSDKCfgWnd::onBrowseThemes()
 */
void gPluginSDKCfgWnd::onBrowseThemes()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
//	ThemePath->setText(cfgPath);

}
