//
// C++ Implementation: gnetio
//
// Description: 
//
//
// Author: Stefano <stefano@xiaprojects.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gnetio.h"
#include "gnetio.moc"



#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <kconfig.h>
#include <kurlrequester.h>
#include <kglobalsettings.h>
#include <klocale.h>

#include "ktn_proc.cpp"

extern "C" QObject *xeplugin_register(QObject *parent)
{
	qWarning("GNetIO xeplugin_register()");
	return new GNetIO(parent,"GNetIO");
}


GNetIO::GNetIO(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="Network Meter";


	// compatibility with 0.29
	QString Version="0.6";
	PluginInformations.append("KXDocker GNetIO");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20050820"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gnetio");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gnetio");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update


	netWorkDevice="eth0";
	devicesList.clear();
	devicesList.append(netWorkDevice);
	proc.setDevicesNetwork(devicesList);
	Scale=1024;
	PollingRate=1000;
	iMiniText=1;

}



GNetIO::~GNetIO()
{
}




/*!
    \fn GNetIO::xGetParameterList(QStringList *a)
 */
void GNetIO::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("device");
	a->append("rate_bytes");
	a->append("polling");
	a->append("minitext");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}






/*!
    \fn GNetIO::xGetParameter(const QString vname, QString&vvalue)
 */
void GNetIO::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=IconsPath;
	}
	if(vname=="device")
	{
		vvalue=netWorkDevice;
	}
	if(vname=="rate_bytes")
	{
		vvalue.setNum(Scale);
	}
	if(vname=="polling")
	{
		vvalue.setNum(PollingRate);
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}

	gPluginSDK::xGetParameter(vname,vvalue);
}



void GNetIO::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("themepath",IconsPath);
		}
		// done in 0.4
		//lastValue=-1;
		loadImages();
		//xRefreshIcon(xGIcon);
	}



	bool okRet=false;
	if(vname=="device")
	{
		netWorkDevice=vvalue;
		devicesList.clear();
		devicesList.append(netWorkDevice);
		proc.setDevicesNetwork(devicesList);
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("device",netWorkDevice);
		}
		
	}
	if(vname=="polling")
	{
		PollingRate=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			PollingRate=1000;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("polling",PollingRate);
		}
	}
	if(vname=="rate_bytes")
	{
		Scale=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			Scale=1024;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("rate_bytes",Scale);
		}
	}
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}


	gPluginSDK::xSetupParameter(vname,vvalue);
}

void GNetIO::xStart()
{
	gPluginSDK::xStart();
}


void GNetIO::xStop()
{
	gPluginSDK::xStop();
}


void GNetIO::polling()
{
	if(isStopped){
		return;
	}

	if(proc.networkPoll()==0);
	
	const float *newIns=proc.getNetworkRX();
	const float *newOuts=proc.getNetworkTX();
	ToolTip="";	

	for(uint i=0; i<10 && i<devicesList.count();i++)
	{
		float newIn=	newIns[i];
		float newOut=	newOuts[i];
		rateIn=newIn-totalIn[i];
		rateOut=newOut-totalOut[i];
		totalIn[i]=newIn;
		totalOut[i]=newOut;
		
		// only 1 device

		break;
	}
	
	// 0.1 version will show the sum
	Value=int((rateIn+rateOut)/Scale);
	int rateInRound=rateIn;
	int rateOutRound=rateOut;
	int rateInRoundt=rateIn;
	int rateOutRoundt=rateOut;
	QString labelIn="Bytes";
	QString labelOut="Bytes";


	rateInRoundt=rateInRound/1024;
	if(rateInRoundt>0)
	{
		labelIn="KB";
		rateInRound=rateInRoundt;
		rateInRoundt=rateInRound/1024;
		if(rateInRoundt>0)
		{
			labelIn="MB";
			rateInRound=rateInRoundt;
		}
	}



	rateOutRoundt=rateOutRound/1024;
	if(rateOutRoundt>0)
	{
		labelOut="KB";
		rateOutRound=rateOutRoundt;
		rateOutRoundt=rateOutRound/1024;
		if(rateOutRoundt>0)
		{
			labelOut="MB";
			rateOutRound=rateOutRoundt;
		}
	}

	ToolTip=ToolTip+i18n(devicesList[0]);
	ToolTip=ToolTip+QString(" %1% (%1%1/%1%1) ").arg(Value).arg(int(rateInRound)).arg(labelIn).arg(int(rateOutRound)).arg(labelOut);
	ToolTip=ToolTip+i18n("usage");

	if(iMiniText==1)ToolTip2="";
	switch(iMiniText)
	{
		case 0:
			// nothing
		break;
		case 1:
			// RX/TX
			ToolTip2=QString("%1%1/%1%1")
					.arg(int(rateInRound))
					.arg(labelIn)
					.arg(int(rateOutRound))
					.arg(labelOut);
		break;
		case 2:
			// RX
			ToolTip2=QString("%1%1")
					.arg(int(rateInRound))
					.arg(labelIn);
		break;
		case 3:
			// TX
			ToolTip2=QString("%1%1")
					.arg(int(rateOutRound))
					.arg(labelOut);
		break;
		case 4:
			// %
			if(Value>0)ToolTip2=QString("%1%").arg(Value);
			else ToolTip2="";
		break;
		case 5:
			// eth0
			ToolTip2=i18n(devicesList[0]);
		break;
		case 6:
			// funny
			//ToolTip2="";
			if(int(rateInRound)>0)ToolTip2=QString("%1%1/").arg(int(rateInRound)).arg(labelIn);
			else ToolTip2=QString("-/");
			if(int(rateOutRound)>0)ToolTip2=ToolTip2+QString("%1%1").arg(int(rateOutRound)).arg(labelOut);
			else ToolTip2=ToolTip2+QString("-");
		break;
	}




	QTimer::singleShot( PollingRate, this, SLOT(polling()));
	lastValue=-1;
	xRefreshIcon(xGIcon);

}


void GNetIO::loadImages()
{
	// base Image
	QString kdeshare="kxdocker/plugins/gnetio/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/CPUMonitor.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"CPUMonitor.png";
	}
	BasePixmap.load(::locate("data",cpuPaths));
	BufferPixmap.resize(BasePixmap.size());
	
	BufferPixmap.fill(Qt::black);

}


void GNetIO::xPaint(int nPercentage)
{

	
	QPixmap line;
	QString kdeshare="kxdocker/plugins/gnetio/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/line.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"line.png";
	}
	
	QPixmap Pixmap;
	// copying background
	
	Pixmap.load(::locate("data",cpuPaths));
	cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/empty.png";
	a.setName(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"empty.png";
	}
	QPixmap Empty;
	Empty.load(::locate("data",cpuPaths));
	
	// sliding the buffer
	//QPixmap	offScreen(128,128);
	QPixmap	offScreen=BasePixmap;
	QPixmap	offScreen2(128,128);
	//offScreen.fill(Qt::black);
	offScreen2.fill(Qt::black);
	QBitmap	maskera(128,128);
	maskera.fill(Qt::color0);
	// the base monitor
	//bitBlt(&offScreen,0,0,&BasePixmap,Qt::CopyROP);
	//offScreen=BasePixmap;
	// the green layout
	// moving to right
	bitBlt(&offScreen2,13+Pixmap.size().width(),15,&BufferPixmap,13,15);
	// clean the line with backgrund transparent
	bitBlt(&offScreen2,13,15,&Empty);
	// draw the percentage
	bitBlt(&offScreen2,13,115-nPercentage,&Pixmap,0,100-nPercentage,Pixmap.size().width(),nPercentage);
	// draw to the layout
	bitBlt(&BufferPixmap,0,0,&offScreen2,0,0,BasePixmap.size().width()-13);
	//bitBlt(&maskera,0,0,&BufferPixmap,0,0,BasePixmap.size().width()-13);
	
	//BufferPixmap.setMask(maskera);
/*	
	
	offScreen.setMask(offScreen.createHeuristicMask());
*/	
	BufferPixmap.setMask(BufferPixmap.createHeuristicMask());
	
	bitBlt(&offScreen,0,0,&BufferPixmap);
	*xImgSource=offScreen.convertToImage();

}


/*!
    \fn GNetIO::xApplyCfg()
 */
void GNetIO::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker");
			netWorkDevice=xXMLIconConfig->item(0).toElement().attribute("device","eth0");
			devicesList.clear();
			devicesList.append(netWorkDevice);
			proc.setDevicesNetwork(devicesList);

			QString vvalue=xXMLIconConfig->item(0).toElement().attribute("rate_bytes","1024");
			bool okRet=false;
			Scale=vvalue.toInt(&okRet);
			if(okRet==false)
			{
				Scale=1024;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("polling","1000");
			PollingRate=vvalue.toInt(&okRet);
			if(okRet==false)
			{
				PollingRate=1000;
			}
			QString sMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1");

			okRet=false;
			iMiniText=sMiniText.toInt(&okRet);
			if(okRet==false)iMiniText=1;

	}
	BasePixmap.convertFromImage(*xImgSource);
	loadImages();
	lastValue=-1;
}

