/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wmconfigurationwindow.h"
#include "wmconfigurationwindow.moc"

#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>


WMConfigurationWindow::WMConfigurationWindow(QObject *parent, const char *name)
 : GPluginSDKCfg(0, name)
{
connect(this,SIGNAL(xApplyParameter(const QString, const QString)),parent,SLOT(xSetupParameter(const QString, const QString)));
}


WMConfigurationWindow::~WMConfigurationWindow()
{
}

void WMConfigurationWindow::pOK_clicked()
{
	emit xApplyParameter("themepath",ThemePath->text());
	emit xApplyParameter("showgauge",mGauge->currentText());
	emit xApplyParameter("icon_mounted",tMounted->currentText());
	emit xApplyParameter("icon_unmounted",tuMounted->currentText());
	emit xApplyParameter("mountcmd",MountCmd->currentText());
	emit xApplyParameter("umountcmd",uMountCmd->currentText());
	emit xApplyParameter("device",MountPoint->currentText());
	emit xApplyParameter("minitext",QString("%1").arg(iMiniText->currentItem()));
	/*
	xApplyParameter("ImageFX_GrayScale",GrayScale->currentText());
	QString stringa;
	stringa.setNum(XDegree->value());
	xApplyParameter("ImageFX_X_degree",stringa);
	stringa.setNum(YDegree->value());
	xApplyParameter("ImageFX_Y_degree",stringa);
	stringa.setNum(Intensity->value());
	xApplyParameter("ImageFX_Intensity",stringa);
	*/

	hide();
}



/*!
    \fn WMConfigurationWindow::xSetupParameter(const QString,const QString)
 */
void WMConfigurationWindow::xSetupParameter(const QString vname,const QString vvalue)
{
	if(vname=="device")
	{
		MountPoint->setCurrentText(vvalue);
	}
	if(vname=="mountcmd")
	{
		MountCmd->setCurrentText(vvalue);
	}
	if(vname=="umountcmd")
	{
		uMountCmd->setCurrentText(vvalue);
	}

	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}
	if(vname=="showgauge")
	{
		mGauge->setCurrentText(vvalue);
	}
	if(vname=="icon_mounted")
	{
		tMounted->setCurrentText(vvalue);
	}
	if(vname=="icon_unmounted")
	{
		tuMounted->setCurrentText(vvalue);
	}
	bool okRet=false;

	if(vname=="minitext")
	{
		int i=vvalue.toInt(&okRet);
		iMiniText->setCurrentItem(i);
	}
	/*
	if(vname=="ImageFX_GrayScale")
	{
		GrayScale->setCurrentText(vvalue);
	}
	if(vname=="ImageFX_X_degree")
	{
		XDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)XDegree->setValue(0);
	}
	if(vname=="ImageFX_Y_degree")
	{
		YDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)YDegree->setValue(0);
	}
	if(vname=="ImageFX_Intensity")
	{
		Intensity->setValue(vvalue.toInt(&okRet));
		if(!okRet)Intensity->setValue(100);
	}
	*/
}

void WMConfigurationWindow::pBrowseTheme_clicked()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	ThemePath->setText(cfgPath);
}

