/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GTHROTTLE__H
#define GTHROTTLE__H

#include "gpluginsdk.h"
#include <qpixmap.h>
#include <kiconloader.h>
class QPixmap;


class gPluginPainter;

class GMount : public gPluginSDK
{
  Q_OBJECT
public:
	GMount(QObject *parent = 0, const char *name = 0);
	~GMount();
public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void dirty(const QString &);
    virtual void xStop();
    virtual void xStart();
    virtual void mount();
    virtual void umount();
    virtual void pollingActivity();
    void pollingGauge();

protected:
	int iMiniText;
	class QTimer *pollIO;
	class QTimer *pollGauge;
	void loadResources(const QString newPath);
	void managePopUp();
	int ioActivity;
	QString icon_unmounted;
	QString icon_mounted;
	QString device;
	QString deviceDev;
	QString deviceSys;

	class KDirWatch	*KDEWatch;
	int lastPercentage;
	QString themepath;
	QString MountCmd;
	QString uMountCmd;

	class gPluginPainter *Painter;
	class gPluginPainter *ioWriting;
	class gPluginPainter *ioReading;
	class gPluginPainter *ioEither;
	QPixmap iMounted;
	QPixmap iunMounted;
	QPixmap Pixmap;

	KIconLoader KDEIconLoader;
	int isMounted;
	int dfPercent;
	// Engine:
	char buf[128];
	char dfMountPoint[128];
	char dfDevice[128];
	char dfSize[128];
	char dfUsed[128];
	char dfFree[128];
	char dfPercentage[128];

	long dfiSize;
	long dfiUsed;
	long dfiFree;

	unsigned long dstatReads;
	unsigned long dstatWrites;
	unsigned long lastdstatReads;
	unsigned long lastdstatWrites;

	QString ShowGauge;
};


#endif
