/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gmail.h"
#include "xeplugin_gmail.moc"
#include <wmconfigurationwindow.h>

#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <string.h>
#include <klocale.h>

extern "C" QObject *xeplugin_register(QObject *parent)
{
	return new GMail(parent,"GMail");
}


GMail::GMail(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="KMail";
	//lastNum=-1;
	//eNum=0;
	//internalStatus=1;
	seconds=60;
	folderName="/Local/urgent";
	NotebookLED=0;
	// compatibility with 0.29
	QString Version="0.11";
	PluginInformations.append("KXDocker GMail");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20060130"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gmail");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gmail");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update

	folders.clear();
	iMiniText=1;

	overlay_none="";
	overlay_incoming="";
	mailFile = new QFile();
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);

}


GMail::~GMail()
{
	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}



QObject *   GMail::Respawn(QObject *p)
{
	//0.40
	return (QObject *  )new GMail(p,"GMail");
}


/*!
    \fn GMail::xGetParameterList(QStringList *a)
 */
void GMail::xGetParameterList(QStringList *a)
{
	a->append("baseIcon");
	a->append("incomingIcon");
	a->append("warningIcon");
	a->append("SecondsRefresh");
	a->append("folderName");
	a->append("NotebookLEDKind");
	a->append("folders");
	a->append("minitext");
	a->append("overlay_none");
	a->append("overlay_incoming");

	gPluginSDK::xGetParameterList(a);
}


/*!
    \fn GMail::xGetParameter(const QString vname, QString&vvalue)
 */
void GMail::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="baseIcon")
	{
		vvalue=IconsPath;
	}
	if(vname=="warningIcon")
	{
		vvalue=warningIcon;
	}
	if(vname=="SecondsRefresh")
	{
		vvalue.setNum(seconds);
	}
	if(vname=="incomingIcon")
	{
		vvalue=incomingIcon;
	}
	if(vname=="folderName")
	{
		vvalue=folderName;
	}
	if(vname=="overlay_none")
	{
		vvalue=overlay_none;
	}
	if(vname=="overlay_incoming")
	{
		vvalue=overlay_incoming;
	}


	if(vname=="NotebookLEDKind")
	{
		vvalue.setNum(NotebookLED);
	}

	if(vname=="folders")
	{
		if(folders.count()>0)
		{
			QString sfolders=folders[0];
			for(uint i=1;i<folders.count();i++)
			{
				sfolders=sfolders+":";
				sfolders=sfolders+folders[i];
			}
			vvalue=sfolders;
		}
		else
		{
		vvalue="";
		}
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}

	gPluginSDK::xGetParameter(vname, vvalue);
}




void GMail::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;

	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}

	if(vname=="incomingIcon")
	{
		incomingIcon=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("incomingIcon",incomingIcon);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);

	}
	if(vname=="warningIcon")
	{
		warningIcon=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("warningIcon",warningIcon);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);

	}
	if(vname=="folderName")
	{
		folderName=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("folderName",folderName);
		}
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}
	if(vname=="overlay_none")
	{
		overlay_none=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("overlay_none",overlay_none);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
	}
	if(vname=="overlay_incoming")
	{
		overlay_incoming=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("overlay_incoming",overlay_incoming);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
	}

	if(vname=="baseIcon")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("baseIcon",IconsPath);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
		
	}
	if(vname=="folders")
	{
		folders.clear();
		//qWarning(QString("vvalue='%1'").arg(vvalue));
		folders=QStringList::split (":",vvalue,FALSE);
		for(int i=(int)folders.count();i>=0;i--)if(folders[i]=="")folders.remove(folders[i]);
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("folders",vvalue);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
		
	}

	if(vname=="SecondsRefresh")
	{
		seconds=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			seconds=60;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("SecondsRefresh",seconds);
		}
	}
	
	if(vname=="NotebookLEDKind")
	{
		NotebookLED=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			NotebookLED=0;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("NotebookLEDKind",NotebookLED);
		}
	}
	
	gPluginSDK::xSetupParameter(vname, vvalue);

}

void GMail::xStart()
{
	// 0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new WMConfigurationWindow(this);
	}

	gPluginSDK::xStart();
}


void GMail::xStop()
{
	gPluginSDK::xStop();
	//internalStatus=0;
}



void GMail::polling()
{

	if(isStopped){
		return;
	}


	Value=0;
	warningIncoming=0;
	static DCOPClient *client=NULL;
	if(client==NULL)
	{
		client= new DCOPClient();
		client->attach();
	}
    if(client->isApplicationRegistered("kmail")){
        QByteArray data;
        QByteArray replyData /* data1 */,
                replyData2;
        QCString replyType /*datas*/,
                replyType2;
        QDataStream arg(data, IO_WriteOnly);
        int unread=0;

        if(client->call("kmail",             // the remote application's id
                        "KMailIface",        // the remote object id
                        "folderList()",        // the remote function id 
                        data,                // the data to send
                        replyType,           // the type of the reply will be written here
                        replyData,           // the data of the reply will be written here 
                        false)){

            QDataStream reply(replyData, IO_ReadOnly);
            if (replyType == "QStringList") {
                QStringList result;
                reply >> result;
                for ( QStringList::Iterator it = ++result.begin(); it != result.end(); ++it ) {
			QString FolderReading=*it;
			//qWarning(FolderReading);
			int trovato=0;
			if(FolderReading==folderName)trovato=1;
			else
			{
				//qWarning(QString("folders.count()=%1").arg(folders.count()));
				if(folders.count()<1)
				{
					folders=result;
					QString vvparse="";
					xGetParameter("folders", vvparse);
					xSetupParameter("folders", vvparse);
					//qWarning(QString("vvparse=%1").arg(vvparse));
				}
				for(uint cercatore=0;cercatore<folders.count();cercatore++)
				{
					//qWarning(QString("folders[cercatore]='%1'").arg(folders[cercatore]));
					if(FolderReading==folders[cercatore])
					{
					trovato=2;
					break;
					}
				}
			}
			if(trovato==0)continue;


                    QByteArray outgoingData;
                    QDataStream outgoingStream( outgoingData, IO_WriteOnly );
                    outgoingStream << *it;
                    if(client->call("kmail",             // the remote application's id
                                    "KMailIface",        // the remote object id
                                    "getFolder(QString)",        // the remote function id  
                                    outgoingData,                // the data to send
                                    replyType2,           // the type of the reply will be written here
                                    replyData2,           // the data of the reply will be written here 
                                    false)){
                        if(replyType2=="DCOPRef"){
                            QDataStream argIn( replyData2, IO_ReadOnly );
                            DCOPRef ref;
                            argIn >> ref;
                            DCOPReply dcopReply=ref.call("unreadMessages()",QString::null);
                            if(dcopReply.isValid())
				{
                                unread+=(int)dcopReply;
				if(trovato==1)warningIncoming+=(int)dcopReply;
				}
                            else
                                qWarning("DCOPReply: data not valid");
                        }else
                            qWarning("DCOP kmail KMailIface getfolder: reply type not valid");
                    }else
                        qWarning("DCOP kmail KMailIface getfolder: call error");
                }
            } else
                qWarning("DCOP kmail KMailIface folderlist: reply type not valid");
            // From here we have the number of unread messeages
	    if(NotebookLED==1)
	    {
            //#ifdef WITH_ASUS_SUPPORT
            // This section enables the Asus notebooks email led support
            // unread=0 no messages => led off
            // unread!=0 led on
            mailFile->setName("/proc/acpi/asus/mled");
            if(unread==0){
                if(mailFile->open(IO_WriteOnly)){
                    mailFile->putch('0');
                    mailFile->close();
                }else{
                    qWarning("GMail::pollMails() Unable to reset mail led");
                }
            }else{
                if(mailFile->open(IO_WriteOnly)){
                    mailFile->putch('1');
                    mailFile->close();
                }else{
                    qWarning("GMail::pollMails() Unable to set mail led");
                }
            }
//#endif
		}
	    if(NotebookLED==2)
	    {
            //#ifdef WITH_ASUS_SUPPORT
            // This section enables the Asus notebooks email led support
            // unread=0 no messages => led off
            // unread!=0 led on
            mailFile->setName("/proc/acpi/acer/mailled");
            if(unread==0){
                if(mailFile->open(IO_WriteOnly)){
                    //mailFile->putch('0');
                    mailFile->writeBlock("enabled: 0",strlen("enabled: 0"));
			//qWarning("no");
                    mailFile->close();
                }else{
                    qWarning("GMail::pollMails() Unable to reset mail led");
                }
            }else{
                if(mailFile->open(IO_WriteOnly)){
                    //mailFile->putch('1');
                    //mailFile->puts("enabled: 0");
			//qWarning("si");
                    mailFile->writeBlock("enabled: 1",strlen("enabled: 1"));
                    mailFile->close();
                }else{
                    qWarning("GMail::pollMails() Unable to set mail led");
                }
            }
//#endif
		}


			Value=unread;
        }else
            qWarning("DCOP kmail KMailIface folderlist: call error");
    }

xRefreshIcon(xGIcon);
    if(!isStopped)QTimer::singleShot(seconds*1000, this, SLOT(polling()));
}


void GMail::loadImages()
{
	KIconLoader KDEIconLoader;
	QString kdeshare="kxdocker/plugins/gmail/";
	QString iPaths=IconsPath;
	//qWarning(iPaths);
	xFindResource("icon",iPaths);
	//iPaths=::locate("data",iPaths);
	//qWarning(iPaths);
	QFile a(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		iPaths=IconsPath;
		BasePixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{
		BasePixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}

	iPaths=incomingIcon;
	xFindResource("icon",iPaths);
	//iPaths=::locate("data",iPaths);
	a.setName(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail_incoming.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		//IncomingPixmap=BasePixmap;
		iPaths=incomingIcon;
		IncomingPixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{
		IncomingPixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
		//IncomingPixmap.load(iPaths);
	}
	if(IncomingPixmap.isNull())IncomingPixmap=BasePixmap;

	iPaths=warningIcon;
	xFindResource("icon",iPaths);
	//iPaths=::locate("data",iPaths);
	a.setName(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail_warning.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		//IncomingPixmap=BasePixmap;
		iPaths=warningIcon;
		warningPixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{
		warningPixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);

	}
	if(warningPixmap.isNull())warningPixmap=BasePixmap;

	//
		QImage TBuffer;
		TBuffer.create(
			1,
			1,
			32);
		TBuffer.setAlphaBuffer(false);
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);

	if(overlay_incoming!="")
	{
		iPaths=overlay_incoming;
		xFindResource("icon",iPaths);
		QPixmap pixmaploaded;
		//iPaths=::locate("data",iPaths);
		a.setName(iPaths);
		if(!a.exists() || iPaths==QString::null)
		{
			// what can we do if i cannot find noting?
			//IncomingPixmap=BasePixmap;
			iPaths=overlay_incoming;
			pixmaploaded=KDEIconLoader.loadIcon(
					iPaths,
					KIcon::NoGroup,
					128
					);
		}
		else
		{
			pixmaploaded=KDEIconLoader.loadIcon(
					iPaths,
					KIcon::NoGroup,
					128
					);
	
		}
		if(pixmaploaded.isNull())overlay_incomingImage=TBuffer;
		else overlay_incomingImage=pixmaploaded.convertToImage();
	}
	else
	{
		overlay_incomingImage=TBuffer;
	}
	if(overlay_none!="")
	{
		iPaths=overlay_none;
		xFindResource("icon",iPaths);
		QPixmap pixmaploaded;
		//iPaths=::locate("data",iPaths);
		a.setName(iPaths);
		if(!a.exists() || iPaths==QString::null)
		{
			// what can we do if i cannot find noting?
			//IncomingPixmap=BasePixmap;
			iPaths=overlay_none;
			pixmaploaded=KDEIconLoader.loadIcon(
					iPaths,
					KIcon::NoGroup,
					128
					);
		}
		else
		{
			pixmaploaded=KDEIconLoader.loadIcon(
					iPaths,
					KIcon::NoGroup,
					128
					);
	
		}
		if(pixmaploaded.isNull())overlay_noneImage=TBuffer;
		else overlay_noneImage=pixmaploaded.convertToImage();
	}
	else
	{
		overlay_noneImage=TBuffer;
	}
}



void GMail::xPaint(int nEmails)
{
	if(!nEmails)
	{
		// we restore the base Image
		*xImgSource=BasePixmap.convertToImage();
		ToolTip=QString("KMail");
		if(iMiniText>0)ToolTip2="";
		// 0.37
		// must be dont after *xImgSource=
		// GIcon will restore xImgOriginal not Source if this call fail into GIcon body
		if(overlay_none!="")xSetOverlayImage(0,0,overlay_noneImage);
	}
	else
	{
		if(warningIncoming>0)
		{
			ToolTip=QString(i18n("You have %1 urgents (%1 unreads)")).arg(warningIncoming).arg(Value);
			*xImgSource=warningPixmap.convertToImage();
		}
		else
		{
			ToolTip=QString(i18n("You have %1 unreads")).arg(Value);
			*xImgSource=IncomingPixmap.convertToImage();
		}
		switch(iMiniText)
		{
			case 1:
				ToolTip2.setNum(Value);
			break;
			case 2:
				if(warningIncoming>0)ToolTip2=QString("%1*").setNum(Value);
				else ToolTip2.setNum(Value);
				
			break;
			case 3:
				if(warningIncoming>0)ToolTip2=QString("%1").setNum(warningIncoming);
				else ToolTip2="";
			break;
			case 4:
				if(warningIncoming>0)ToolTip2=QString("%1 (%1)").arg(Value).arg(warningIncoming);
				else ToolTip2.setNum(Value);
			break;
		}
		// 0.37
		// must be dont after *xImgSource=
		// GIcon will restore xImgOriginal not Source if this call fail into GIcon body
		if(overlay_incoming!="")xSetOverlayImage(0,0,overlay_incomingImage);
		
	}
}


/*!
    \fn GMail::xApplyCfg()
 */
void GMail::xApplyCfg()
{
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("baseIcon","kmail");
			incomingIcon=xXMLIconConfig->item(0).toElement().attribute("incomingIcon","kmail_incoming");
			warningIcon=xXMLIconConfig->item(0).toElement().attribute("warningIcon","kmail_warning");
			folderName=xXMLIconConfig->item(0).toElement().attribute("folderName","/Local/inbox");
			overlay_incoming=xXMLIconConfig->item(0).toElement().attribute("overlay_incoming","");
			overlay_none=xXMLIconConfig->item(0).toElement().attribute("overlay_none","");
			QString sfolders=xXMLIconConfig->item(0).toElement().attribute("folders","/Local/urgent:/Local/inbox");
			folders=QStringList::split (":",sfolders,FALSE);
			for(int i=(int)folders.count();i>=0;i--)if(folders[i]=="")folders.remove(folders[i]);
			bool okRet=false;
			seconds=xXMLIconConfig->item(0).toElement().attribute("SecondsRefresh","60").toInt(&okRet);
			if(okRet==false)
			{
				seconds=60;
			}
			iMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1").toInt(&okRet);
			if(okRet==false)
			{
				iMiniText=1;
			}
			
			
			
			// Loading Notebook kind led-lid
			okRet=false;
			NotebookLED=xXMLIconConfig->item(0).toElement().attribute("NotebookLEDKind","0").toInt(&okRet);
			if(okRet==false)
			{
				NotebookLED=0;
			}
			
		}
		
	BasePixmap.convertFromImage(*xImgSource);
	loadImages();
	lastValue=-1;
}


/*!
    \fn GMail::xGetParameterType(const QString &, QString &)
 */
void GMail::xGetParameterType(const QString &vname, QString &vvalue)
{
	if(vname=="baseIcon")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="warningIcon")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="SecondsRefresh")
	{
		vvalue=KXDOCKER_VARTYPE_INT;
	}
	if(vname=="incomingIcon")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="folderName")
	{
		vvalue=KXDOCKER_VARTYPE_STRING;
	}
	if(vname=="overlay_none")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="overlay_incoming")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}


	if(vname=="NotebookLEDKind")
	{
		vvalue=KXDOCKER_VARTYPE_RANGE;
		vvalue=vvalue+":int:0:1";
	}

	if(vname=="folders")
	{
		vvalue=KXDOCKER_VARTYPE_LIST;
	}
	if(vname=="minitext")
	{
		vvalue=KXDOCKER_VARTYPE_RANGE;
		vvalue=vvalue+":int:0:4";
	}
	gPluginSDK::xGetParameterType(vname,vvalue);
}
