#include "ipcontrack.h"
#include "ipcontrack.moc"

#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <string.h>
#include <iostream>
#include <string>
class IPContracker
{
public:
	IPContracker(const char *);
	~IPContracker();
	unsigned long int fetchToIp(const char *);
	void track(const char *);
	unsigned long int fetchFromIp(const char *);
	unsigned long int fetchToFromIp(const char *IP,int &Direction);
protected:
	char procIPContrack[51];
};


IPContracker::IPContracker(const char *procfs)
{
	strcpy(procIPContrack,procfs);
}
IPContracker::~IPContracker()
{

}

unsigned long int IPContracker::fetchFromIp(const char *IP)
{
	FILE *ip_contrack=fopen(procIPContrack,"r");
	if(ip_contrack==NULL)return 0;
	char ip_contrackRow[13][30];
	unsigned long int	ip_contrackRowInt;
	unsigned long int	ip_contrackRowLast;
	unsigned long int conta=0;
	char buffer[1025];
	while(!feof(ip_contrack))
	{
/*
udp      17 148 src=217.113.66.116 dst=192.168.0.11 sport=6346 dport=63247 src=192.168.0.11 dst=217.113.66.116 sport=63247 dport=
6346 [ASSURED] use=1
tcp      6 431977 ESTABLISHED src=80.219.173.101 dst=192.168.0.11 sport=1836 dport=63211 src=192.168.0.11 dst=80.219.173.101 sport=63211 dport=1836 [ASSURED] use=1
*/

		fgets(buffer,1024,ip_contrack);
		sscanf(buffer,
			"%s %lu %lu %s %s %s %s %s %s %s %s %s %s",
			ip_contrackRow[0],
			&ip_contrackRowInt,
			&ip_contrackRowLast,
			ip_contrackRow[3],
			ip_contrackRow[4],
			ip_contrackRow[5],
			ip_contrackRow[6],
			ip_contrackRow[7],
			ip_contrackRow[8],
			ip_contrackRow[9],
			ip_contrackRow[10],
			ip_contrackRow[11],
			ip_contrackRow[12]
			);
		if(strcmp("udp",ip_contrackRow[0])==0)
		{
			if(strcmp(IP,ip_contrackRow[3]+4)==0)
			{
				//printf("%d %d %s\n",ip_contrackRowInt,ip_contrackRowLast,ip_contrackRow[4]+4);
				// conta++;
				//conta=ip_contrackRowLast;
				if(conta<ip_contrackRowLast)conta=ip_contrackRowLast;
				//break;
			}
		}
		else
		{
			if(strcmp("ESTABLISHED",ip_contrackRow[3])==0)
			if(strcmp(IP,ip_contrackRow[4]+4)==0)
			{
				if(conta<ip_contrackRowLast)conta=ip_contrackRowLast;
			}
		}
	}
	fclose(ip_contrack);
	return conta;
}

unsigned long int IPContracker::fetchToIp(const char *IP)
{
	FILE *ip_contrack=fopen(procIPContrack,"r");
	if(ip_contrack==NULL)return 0;
	char ip_contrackRow[13][30];
	unsigned long int	ip_contrackRowInt;
	unsigned long int	ip_contrackRowLast;
	unsigned long int conta=0;
	char buffer[1025];
	while(!feof(ip_contrack))
	{
/*
udp      17 148 src=217.113.66.116 dst=192.168.0.11 sport=6346 dport=63247 src=192.168.0.11 dst=217.113.66.116 sport=63247 dport=
6346 [ASSURED] use=1
tcp      6 431977 ESTABLISHED src=80.219.173.101 dst=192.168.0.11 sport=1836 dport=63211 src=192.168.0.11 dst=80.219.173.101 sport=63211 dport=1836 [ASSURED] use=1
*/

		fgets(buffer,1024,ip_contrack);
		sscanf(buffer,
			"%s %lu %lu %s %s %s %s %s %s %s %s %s %s",
			ip_contrackRow[0],
			&ip_contrackRowInt,
			&ip_contrackRowLast,
			ip_contrackRow[3],
			ip_contrackRow[4],
			ip_contrackRow[5],
			ip_contrackRow[6],
			ip_contrackRow[7],
			ip_contrackRow[8],
			ip_contrackRow[9],
			ip_contrackRow[10],
			ip_contrackRow[11],
			ip_contrackRow[12]
			);
		if(strcmp("udp",ip_contrackRow[0])==0)
		{
			if(strcmp(IP,ip_contrackRow[4]+4)==0)
			{
				if(conta<ip_contrackRowLast)conta=ip_contrackRowLast;

			}
		}
		else
		{
			if(strcmp("ESTABLISHED",ip_contrackRow[3])==0)
			if(strcmp(IP,ip_contrackRow[5]+4)==0)
			{
				if(conta<ip_contrackRowLast)conta=ip_contrackRowLast;

			}
		}
	}
	fclose(ip_contrack);
	return conta;
}


unsigned long int IPContracker::fetchToFromIp(const char *IP,int &Direction)
{
	Direction=0;
	FILE *ip_contrack=fopen(procIPContrack,"r");
	if(ip_contrack==NULL)return 0;
	char ip_contrackRow[13][30];
	unsigned long int	ip_contrackRowInt;
	unsigned long int	ip_contrackRowLast;
	unsigned long int conta=0;
	char buffer[1025];
	while(!feof(ip_contrack))
	{
/*
udp      17 148 src=217.113.66.116 dst=192.168.0.11 sport=6346 dport=63247 src=192.168.0.11 dst=217.113.66.116 sport=63247 dport=
6346 [ASSURED] use=1
tcp      6 431977 ESTABLISHED src=80.219.173.101 dst=192.168.0.11 sport=1836 dport=63211 src=192.168.0.11 dst=80.219.173.101 sport=63211 dport=1836 [ASSURED] use=1
*/

		fgets(buffer,1024,ip_contrack);
		sscanf(buffer,
			"%s %lu %lu %s %s %s %s %s %s %s %s %s %s",
			ip_contrackRow[0],
			&ip_contrackRowInt,
			&ip_contrackRowLast,
			ip_contrackRow[3],
			ip_contrackRow[4],
			ip_contrackRow[5],
			ip_contrackRow[6],
			ip_contrackRow[7],
			ip_contrackRow[8],
			ip_contrackRow[9],
			ip_contrackRow[10],
			ip_contrackRow[11],
			ip_contrackRow[12]
			);
		if(strcmp("udp",ip_contrackRow[0])==0)
		{
			if(strcmp(IP,ip_contrackRow[3]+4)==0)
			{
				//printf("%d %d %s\n",ip_contrackRowInt,ip_contrackRowLast,ip_contrackRow[4]+4);
				// conta++;
				//conta=ip_contrackRowLast;
				if(conta<ip_contrackRowLast)
				{
					conta=ip_contrackRowLast;
					Direction=1;
				}
				//break;
			}
			else
			if(strcmp(IP,ip_contrackRow[4]+4)==0)
			{
				if(conta<ip_contrackRowLast)
				{
					conta=ip_contrackRowLast;
					Direction=2;
				}
			}

		}
		else
		{
			if(strcmp("ESTABLISHED",ip_contrackRow[3])==0)
			if(strcmp(IP,ip_contrackRow[4]+4)==0)
			{
				if(conta<ip_contrackRowLast)
				{
					conta=ip_contrackRowLast;
					Direction=1;
				}
			}
			else
			if(strcmp(IP,ip_contrackRow[5]+4)==0)
			{
				if(conta<ip_contrackRowLast)
				{
					conta=ip_contrackRowLast;
					Direction=2;
				}
			}

		}
	}
	fclose(ip_contrack);
	return conta;
}

void IPContracker::track(const char *IP)
{
	unsigned long int lastValue=0;
	unsigned long int thisValue=0;
	while(1)
	{
		thisValue=fetchToIp(IP);
		if(thisValue==0)return;
		if(thisValue>=lastValue)
		{
			
			printf("1\n");
		}
		else printf("0\n");
		lastValue=thisValue;
		//printf("%d\n",thisValue);
		sleep(2);
	}
}



extern "C" QObject *xeplugin_register(QObject *parent)
{
	qWarning("GIPContrack xeplugin_register()");
	return new GIPContrack(parent,"GIPContrack");
}


GIPContrack::GIPContrack(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="IP Contracker";
	//lastNum=-1;
	//eNum=0;
	//internalStatus=1;
	seconds=60;
	// compatibility with 0.29
	QString Version="0.1";
	PluginInformations.append("KXDocker GIPContrack");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20051001"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gipcontrack");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gipcontrack");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update

	iMiniText=1;

	overlay_outgoing="kxdocker/plugins/gipcontrack/spin_outgoing";
	overlay_incoming="kxdocker/plugins/gipcontrack/spin_incoming";
	IP="127.0.0.1";
	ipContracker=new IPContracker("/proc/net/ip_conntrack");
	longValue=0;
	lastlongValue=0;
	longValue2=0;
	lastlongValue2=0;



}


GIPContrack::~GIPContrack()
{
}




/*!
    \fn GIPContrack::xGetParameterList(QStringList *a)
 */
void GIPContrack::xGetParameterList(QStringList *a)
{
	a->append("nearIcon");
	a->append("incomingIcon");
	a->append("outgoingIcon");
	a->append("SecondsRefresh");
	a->append("minitext");
	a->append("overlay_outgoing");
	a->append("overlay_incoming");
	a->append("ip");

	gPluginSDK::xGetParameterList(a);
}


/*!
    \fn GIPContrack::xGetParameter(const QString vname, QString&vvalue)
 */
void GIPContrack::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="nearIcon")
	{
		vvalue=IconsPath;
	}
	if(vname=="outgoingIcon")
	{
		vvalue=warningIcon;
	}
	if(vname=="SecondsRefresh")
	{
		vvalue.setNum(seconds);
	}
	if(vname=="incomingIcon")
	{
		vvalue=incomingIcon;
	}
	if(vname=="overlay_outgoing")
	{
		vvalue=overlay_outgoing;
	}
	if(vname=="overlay_incoming")
	{
		vvalue=overlay_incoming;
	}
	if(vname=="ip")
	{
		vvalue=IP;
	}

	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}

	gPluginSDK::xGetParameter(vname, vvalue);
}




void GIPContrack::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;

	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}

	if(vname=="ip")
	{
		IP=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ip",IP);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);

	}

	if(vname=="incomingIcon")
	{
		incomingIcon=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("incomingIcon",incomingIcon);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);

	}
	if(vname=="outgoingIcon")
	{
		warningIcon=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("outgoingIcon",warningIcon);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);

	}
	if(vname=="overlay_outgoing")
	{
		overlay_outgoing=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("overlay_outgoing",overlay_outgoing);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
	}
	if(vname=="overlay_incoming")
	{
		overlay_incoming=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("overlay_incoming",overlay_incoming);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
	}

	if(vname=="nearIcon")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("nearIcon",IconsPath);
		}
		lastValue=-1;
		loadImages();
		xRefreshIcon(xGIcon);
		
	}

	if(vname=="SecondsRefresh")
	{
		seconds=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			seconds=60;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("SecondsRefresh",seconds);
		}
	}
	
	gPluginSDK::xSetupParameter(vname, vvalue);

}

void GIPContrack::xStart()
{
	gPluginSDK::xStart();
}


void GIPContrack::xStop()
{
	gPluginSDK::xStop();
	//internalStatus=0;
}



void GIPContrack::polling()
{
	if(isStopped){
		return;
	}
	/*
	longValue=ipContracker->fetchToIp(IP);
	//qWarning(QString("%1").arg(longValue));
	if(longValue==0)
	{
		Value=0;
		// checking for outgoings
		longValue2=ipContracker->fetchFromIp(IP);
		//qWarning(QString("%1").arg(longValue));
		if(longValue2==0)
		{
		}
		else
		if(longValue2>=lastlongValue2)Value=4;
		else Value=4;
		lastlongValue2=longValue2;


	}
	else
	if(longValue>=lastlongValue)Value=2;
	else
	{
		Value=1;
		// checking for outgoings
		longValue2=ipContracker->fetchFromIp(IP);
		//qWarning(QString("%1").arg(longValue));
		if(longValue2==0)
		{
		}
		else
		if(longValue2>=lastlongValue2)Value=4;
		else Value=4;
		lastlongValue2=longValue2;
	}
	*/
	longValue=ipContracker->fetchToFromIp(IP,Direction);
	if(longValue==0)
	{
		Value=0;
	}
	else
	if(longValue>=lastlongValue)Value=2;
	else
	{
		Value=1;
	}


	lastlongValue=longValue;
	xRefreshIcon(xGIcon);
	if(!isStopped)QTimer::singleShot(seconds*1000, this, SLOT(polling()));
}


void GIPContrack::loadImages()
{
}



void GIPContrack::xPaint(int nEmails)
{
	//qWarning(QString("I=%1").arg(nEmails));
	if(!nEmails)
	{
		// we restore the base Image
		*xImgSource=BasePixmap.convertToImage();
		ToolTip=QString("No connections");
		if(iMiniText>0)ToolTip2="";
		// 0.37
		// must be dont after *xImgSource=
		// GIcon will restore xImgOriginal not Source if this call fail into GIcon body
		if(overlay_outgoing!="")xSetOverlayImage(0,0,"");
	}
	else
	{
		if(nEmails==1)
		{
			if(Direction==1)
			{
				// near
				ToolTip=QString("Host %1 has connected").arg(IP);
				//*xImgSource=IncomingPixmap.convertToImage();
				if(overlay_incoming!="")xSetOverlayImage(0,0,"");
			}
			else
			{
				ToolTip=QString("Host %1 connected").arg(IP);
				// near
				//*xImgSource=IncomingPixmap.convertToImage();
				if(overlay_incoming!="")xSetOverlayImage(0,0,"");
			}
		}
		else
		if(nEmails==2)
		{
			if(Direction==1)
			{
				// activity
				ToolTip=QString("Talking to %1").arg(IP);
				//*xImgSource=warningPixmap.convertToImage();
				QString ovrfile=overlay_incoming;
				xFindResource("icon", ovrfile);
				if(ovrfile!="")
				{
					xSetOverlayImage(0,0,ovrfile);
					xStartStepping();
				}
			}
			else
			{
				// activity
				ToolTip=QString("Listening %1").arg(IP);
				//*xImgSource=warningPixmap.convertToImage();
				QString ovrfile=overlay_outgoing;
				xFindResource("icon", ovrfile);
				if(ovrfile!="")
				{
					xSetOverlayImage(0,0,ovrfile);
					xStartStepping();
				}
			}
		}
	
	/*
		switch(iMiniText)
		{
			case 1:
				ToolTip2.setNum(Value);
			break;
			case 2:
				if(warningIncoming>0)ToolTip2=QString("%1*").setNum(Value);
				else ToolTip2.setNum(Value);
				
			break;
			case 3:
				if(warningIncoming>0)ToolTip2=QString("%1").setNum(warningIncoming);
				else ToolTip2="";
			break;
			case 4:
				if(warningIncoming>0)ToolTip2=QString("%1 (%1)").arg(Value).arg(warningIncoming);
				else ToolTip2.setNum(Value);
			break;
		}
	*/
		// 0.37
		// must be dont after *xImgSource=
		// GIcon will restore xImgOriginal not Source if this call fail into GIcon body
		
	}
}


/*!
    \fn GIPContrack::xApplyCfg()
 */
void GIPContrack::xApplyCfg()
{
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("nearIcon","host");
			
			IP=xXMLIconConfig->item(0).toElement().attribute("ip","");
			if(IP=="")xGetIconName(IP);
			if(IP=="")IP="127.0.0.1";
			incomingIcon=xXMLIconConfig->item(0).toElement().attribute("incomingIcon","incoming");
			warningIcon=xXMLIconConfig->item(0).toElement().attribute("outgoingIcon","outgoing");
			overlay_incoming=xXMLIconConfig->item(0).toElement().attribute("overlay_incoming","kxdocker/plugins/gipcontrack/spin_incoming");
			overlay_outgoing=xXMLIconConfig->item(0).toElement().attribute("overlay_outgoing","kxdocker/plugins/gipcontrack/spin_outgoing");
			bool okRet=false;
			seconds=xXMLIconConfig->item(0).toElement().attribute("SecondsRefresh","2").toInt(&okRet);
			if(okRet==false)
			{
				seconds=60;
			}
			iMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1").toInt(&okRet);
			if(okRet==false)
			{
				iMiniText=1;
			}
		}
		
	BasePixmap.convertFromImage(*xImgSource);
	loadImages();
	lastValue=-1;
}


/*!
    \fn GIPContrack::xGetParameterType(const QString &, QString &)
 */
void GIPContrack::xGetParameterType(const QString &vname, QString &vvalue)
{
	if(vname=="nearIcon")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="outgoingIcon")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="SecondsRefresh")
	{
		vvalue=KXDOCKER_VARTYPE_INT;
	}
	if(vname=="incomingIcon")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="overlay_outgoing")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="overlay_incoming")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="minitext")
	{
		vvalue=KXDOCKER_VARTYPE_RANGE;
		vvalue=vvalue+":int:0:4";
	}
	gPluginSDK::xGetParameterType(vname,vvalue);
}
