/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GNETIO_H
#define GNETIO_H

#include <libkxdocker.h>

#include <qstring.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qimage.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <kdirlister.h>

#include "ktn_proc.h"



/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class GNetIO : public gPluginSDK
{
Q_OBJECT
public:
    GNetIO(QObject *parent = 0, const char *name = 0);
    ~GNetIO();
    QObject * Respawn(QObject *);
protected:
	QImage				imgBuffer;
	QImage				imgOriginal;
	QImage				imgBackground;
	QImage				imgOffscreen;
	QImage				imgOffscreen2;
	QImage				imgTrans;
	QImage				imgLine;
	bool m_firstTime;
	KTN_Proc proc;
	QString		netWorkDevice;
	QStringList devicesList;
	float rateIn;
	float rateOut;
	float totalIn[10];
	float totalOut[10];
	float Scale;
	int PollingRate;
	int	iMiniText;
	int	dotPitch;
	int	drawDirection;
public slots:
    void xGetParameterList(QStringList *);
    void xPaint(int nEmails);
    void xApplyCfg();
    void xGetParameter(const QString, QString&);
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void polling();
protected:
    void loadImages();
    void loadResources(const QString &);
};

#endif
