/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GCPU_H
#define XEPLUGIN_GCPU_H

#include <qobject.h>
#include <qstring.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qimage.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <kdirlister.h>
#include <libkxdocker.h>

class QPixmap;
class gPluginPainter;

    class CpuData
    {
      public:
        CpuData() { user = nice = sys = idle = 0; }

        QString name;
        unsigned long user;
        unsigned long nice;
        unsigned long sys;
        unsigned long idle;

        CpuData &operator-=(const CpuData &rhs)
        {
          if (name != rhs.name)
            return *this;

          user -= rhs.user;
          nice -= rhs.nice;
          sys -= rhs.sys;
          idle -= rhs.idle;
          return *this;
        }
    };

    class Cpu
    {
      public:
        Cpu()
        {
          m_num = 0;
        }

        Cpu(const QString &name,
           const QString &format,
           int number)
           : m_name(name),
           m_format(format),
           m_num(number)
        {
        }

        ~Cpu()
        {
        }

        bool operator==(const Cpu &rhs) const
        {
          return m_name == rhs.m_name &&
             m_format == rhs.m_format;
        }

        bool operator!=(const Cpu &rhs) const
        {
          return !operator==(rhs);
        }

        void cleanup()
        {
        }

        void setData(const CpuData &data)
        {
          m_old = m_data;
          m_data = data;
        }

        const CpuData &oldData() const
        {
          return m_old;
        }

        const QString &format() const
        {
          return m_format;
        }

        int number() const
        {
          return m_num;
        }


      private:
        CpuData m_data;
        CpuData m_old;
        QString m_name;
        QString m_format;
        int m_num;
    };
    typedef QValueList<Cpu> CpuList;


/**
@author Stefano
*/
class GCpu : public gPluginSDK
{
Q_OBJECT
public:
    GCpu(QObject *parent = 0, const char *name = 0);
	QObject *   Respawn(QObject *);
    ~GCpu();

protected:
	int	dotPitch;
	int	drawDirection;
	QImage				imgBuffer;
	QImage				imgOriginal;
	QImage				imgBackground;
	QImage				imgOffscreen;
	QImage				imgOffscreen2;
	QImage				imgTrans;
	QImage				imgLine;
	Cpu current;
	CpuList m_cpus;
	int PollingRate;
	int iMiniText;
#ifdef __linux__
    FILE *m_procFile;
    QTextStream *m_procStream;
#endif


public slots:
    void xGetParameterList(QStringList *);
    void xPaint(int nEmails);
    void xApplyCfg();
    void xGetParameter(const QString, QString&);
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void polling();

protected:
    void updateCpu(CpuData &cpu, int cpuNumber);
    void loadResources(const QString &);
};


#endif
