/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gbattery.h"
#include "xeplugin_gbattery.moc"
#include "wmconfigurationwindow.h"
#include "portable.h"


#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>
#include <string.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <krun.h>
#include <qtimer.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kdebug.h>



extern "C" QObject *xeplugin_register(QObject *parent)
{
	return new GBattery(parent,"GBattery");
}



GBattery::GBattery(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{

	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.8";
	// Project name
	PluginInformations.append("KXDocker GBattery");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20060127");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gbattery");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gbattery");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	//int IconSize=128;
	/*
	PainterTop=new QImage();
	PainterGauge=new QImage();
	PainterBG=new QImage();
	*/

	themepath="kxdocker/plugins/gbattery/";

	lastAnimationStep=0;
	//ThemeYMinTop=90;
	//ThemeYMaxTop=30;
	Animator=new QTimer();
	connect(Animator, SIGNAL(timeout()),this,SLOT(pollingAnimation()));
	iMiniText=1;

	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);
}

GBattery::~GBattery()
{
	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}

QObject *   GBattery::Respawn(QObject *p)
{
	//0.40
	return (QObject *  )new GBattery(p,"GBattery");
}

void GBattery::xSetupParameter(const QString vname, const QString vvalue)
{

	if(vname=="themepath")
	{
		themepath=vvalue;
		gb08LoadNewTheme(themepath);
		dirty(1,-1);
		
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
	
			xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);
	
		}
		else
		{
			createXMLTree();
		}

	}
	bool okRet=false;
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}
	gPluginSDK::xSetupParameter(vname,vvalue);
	// update the resources
	loadResources(themepath);
	// restart the polling
	//if(ShowGauge=="yes")QTimer::singleShot(30000, this, SLOT(polling()));
	//dirty("");

}

void GBattery::xGetParameter(const QString vname, QString&vvalue)
{

	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	gPluginSDK::xGetParameter(vname, vvalue);

}
void GBattery::xGetParameterList(QStringList *a)
{

	a->append("themepath");
	a->append("minitext");
	gPluginSDK::xGetParameterList(a);
}


void GBattery::xPaint(int)
{
	//if(lastAnimationStep==0)
	//{
	//	Pixmap.load(iconName);
	//}
	*xImgSource=ImageBuffer;
	
}


void GBattery::polling()
{
	if(isStopped){
		qWarning("void GBattery::polling() exiting...");
		return;
	}
	if(laptop_portable::has_power_management())
	{
		int num_batteries;
		QStringList names;
		QStringList state;
		QStringList values;
		laptop_portable::get_battery_status(num_batteries, names, state, values);
		struct power_result binfo=laptop_portable::poll_battery_state();
		//int ac=laptop_portable::get_acpi_ac();
		int ac=binfo.powered;
		//ToolTip="Monitoring...";
	/*
		static int simulatore=0;
		simulatore=(simulatore+1);
		if(simulatore>100)simulatore=0;
		binfo.percentage=simulatore;
		ac=1;
		num_batteries=1;
		kdWarning()<<QString("Batery:[%1][%1][%1]\n").arg(binfo.powered).arg(num_batteries).arg(binfo.percentage);
	*/

		if(iMiniText==1)ToolTip2="";
		if(ac>0)
		{
			// external power
			//TODO: plugged without battery
			if(binfo.percentage>0)ToolTip=QString("%1 (%1%)").arg(i18n("Charging...")).arg(binfo.percentage);
			else ToolTip=i18n("AC On-line");
			if(iMiniText==1)ToolTip2=QString("%1%").arg(binfo.percentage);
			if(iMiniText==2)ToolTip2="";
			dirty(1,binfo.percentage);
			// we have to check if it's charging
		}
		else
		{
			if(num_batteries<1)return;
			if(iMiniText==1)ToolTip2=QString("%1%").arg(binfo.percentage);
			if(binfo.time>0)
			{
			int h=binfo.time/60;
			int m=binfo.time-h*60;
			char stringa[50];
			sprintf(stringa,"%02d:%02d",h,m);
			ToolTip=QString("%1 %1 (%1%)").arg(i18n(QString("%1 left").arg(names[0]))).arg(stringa).arg(values[0]);
				if(iMiniText==2)ToolTip2=QString("%1:%1").arg(h).arg(m);
			}
			else
			{
				ToolTip=QString("%1: (%1%)").arg(i18n(QString("%1 left").arg(names[0]))).arg(values[0]);
				if(iMiniText>0)ToolTip2=QString("%1%").arg(values[0]);
			}
			dirty(0,binfo.percentage);
		}
		QTimer::singleShot( 60*1000, this, SLOT(polling()));
		//QTimer::singleShot( 100, this, SLOT(polling()));
	}
	else
	{
		// you dont have ACPI installed than we can put a plug?
		ToolTip=i18n("AC On-line");
		if(iMiniText==1)ToolTip2="";
		dirty(1,-1);
		// i don't want update more
	}



	//QTimer::singleShot(10000, this, SLOT(polling()));
}


void GBattery::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{

		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gbattery/");
		xSetupParameter("minitext",xXMLIconConfig->item(0).toElement().attribute("minitext","1"));

	}
	// to enable the first pass
	lastValue=-1;
	// update the resources
	if(themepath=="")themepath="kxdocker/plugins/gbattery/";
	loadResources(themepath);
	gb08LoadNewTheme(themepath);

	//dirty("");
}


void GBattery::dirty(int AC, int B)
{

	Animator->stop();

	if(isStopped){
		qWarning("void GBattery::dirty exiting...");
		return;
	}

	//qWarning(QString("void GBattery::dirty(%1, %1)").arg(AC).arg(B));

	if(lastAC==AC and lastB == B and lastAnimationStep==0)return;
	if(lastAC!=AC || lastB != B)
	{
		lastAC=AC;
		lastB=B;
		lastAnimationStep=0;
	
	/*
		if(!loadNewTheme(AC,B))
		{
			loadOldTheme(AC,B);
			if(iconName==NULL or iconName.isEmpty())return;
		}
		
	*/
		gb08Paint(AC,B);
	}
	else
	{
		// animate it
		if(AC>0)
		{
			if(B<=lastAnimationStep)lastAnimationStep=1;

			/*
			if(!loadNewTheme(AC,lastAnimationStep))
			{
				lastAnimationStep=0;
				return;
			}
			*/
			if(!gb08Paint(AC,lastAnimationStep))
			{
				lastAnimationStep=0;
				return;
			}
			
			//QTimer::singleShot( 300, this, SLOT(pollingAnimation()));
			Animator->start(250);
		}
	}
	Value=AC*100+B+lastAnimationStep*1000;
	xRefreshIcon(xGIcon);
}


void GBattery::xStop()
{

	gPluginSDK::xStop();

}


void GBattery::xStart()
{
	// 0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new WMConfigurationWindow(this);
	}
	gPluginSDK::xStart();
}


void GBattery::loadResources(const QString)
{
}


/*!
    \fn GBattery::managePopUp(int)
 */
void GBattery::managePopUp()
{
	PluginPopupMenu->clear();
}



QString GBattery::tryFindIcon(int AC ,QString B, QString themePath)
{
	// search for theme/c95.png
	QString basePath=themePath+"/";
//qWarning(B);
	QString batteryPaths=B;
	//batteryPaths.setNum(B);
	if(AC>0)
	{
	batteryPaths="c"+batteryPaths;
	}
	else
	{
	
	}
	batteryPaths=basePath+batteryPaths;
	batteryPaths=batteryPaths+".png";
	
	batteryPaths=::locate("data",batteryPaths);
//qWarning(batteryPaths);
	QFile a(batteryPaths);
	//qWarning(QString("Alimentazione: %1 %1 %1 %1").arg(AC).arg(B).arg(themePath).arg(batteryPaths));
	if(!a.exists() || batteryPaths==QString::null)
	{
		return NULL;
	}
	return batteryPaths;	
}

void GBattery::loadOldTheme(int AC, int B)
{
	// base Image
	IconsPath=themepath+"/";
	QString kdeshare="kxdocker/plugins/gbattery/";
	QString batteryPaths=IconsPath;
	batteryPaths=batteryPaths+"/0.png";
	QFile a(batteryPaths);
	if(!a.exists() || batteryPaths==QString::null)
	{
		batteryPaths=kdeshare+"na.png";
	}
	QPixmap Pixmap;
	Pixmap.load(::locate("data",batteryPaths));
	// TODO!!
	if(!Pixmap.isNull())*xImgSource=Pixmap.convertToImage();
	QString Bstring;
	iconName="";
	// ACOnline without battery
	if(AC>0 && B<1)
	{
		//iconName=tryFindIcon(0,"charged",IconsPath);
		//if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",kdeshare);
	}

	// try theme c98.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),IconsPath);
	// try theme c9.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),IconsPath);
	// try kde c98.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),kdeshare);
	// try kde c9.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),kdeshare);
	// try >8 
	if(iconName==NULL or iconName.isEmpty())
	{
		if(B>80)
		{
			if(AC>0)
			{
				iconName=tryFindIcon(0,"charged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_plugged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_plugged",kdeshare);
			}
			else 
			{
				B=80;
			}
		}
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),IconsPath);
		// try kde c98.png
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),kdeshare);
		// try kde c9.png
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),kdeshare);

		
		if(B>=70)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_full",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_full",kdeshare);
		}
		if(B<70 && B>40)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_two_thirds",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_two_thirds",kdeshare);
		}
		if(B<40 && B>10)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_low",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_low",kdeshare);
		}
		if(B<10 && B>0)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_empty",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_empty",kdeshare);
		}
		if(B<=0)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",kdeshare);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"na",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"na",kdeshare);
		}
	}
}

/*
int GBattery::loadNewTheme(int AC,int B)
{
	//qWarning("int GBattery::loadNewTheme(int AC,int B)");
	QString FileName;
	QString endFileName;
	QFile a;
	// searching for new themes

	if(B>99)
	{
		//qWarning(QString("if(B>100)"));
		return 0;
	}
	if(B<0)
	{
		//qWarning(QString("if(B<0)"));
		return 0;
	}

	if(B==0)
	{
		//qWarning(QString("if(B=0)"));
		//return 0;
	}


	if(B>0)endFileName=QString("bg%1.png").arg(1);
	else endFileName=QString("bg%1.png").arg(0);

	//
	if(AC==0)FileName=themepath+"/battery_analog_";
	else FileName=themepath+"/battery_analog_plug_";

	FileName=FileName+endFileName;

	FileName=::locate("data",FileName);

	a.setName(FileName);
	if(!a.exists() || FileName==QString::null)
	{
		// old theme format
		return 0;
	}
	Pixmap.load(FileName);
	//qWarning(QString("Pixmap.load(FileName=%1);").arg(FileName));
	//PainterBG->load(FileName);
	if(B>0)
	{

		if(AC==0)FileName=themepath+"/battery_analog_gauge.png";
		else FileName=themepath+"/battery_analog_plug_gauge.png";

		FileName=::locate("data",FileName);
		a.setName(FileName);
		if(!a.exists() || FileName==QString::null)return 0;
		else PainterGauge->load(FileName);
		//
		if(AC==0)FileName=themepath+"/battery_analog_level.png";
		else FileName=themepath+"/battery_analog_plug_level.png";
		FileName=::locate("data",FileName);
		a.setName(FileName);
		if(!a.exists() || FileName==QString::null)return 0;
		else PainterTop->load(FileName);
		//
		if(AC==0)FileName=themepath+"/battery_analog_fg.png";
		else FileName=themepath+"/battery_analog_plug_fg.png";
		FileName=::locate("data",FileName);
		a.setName(FileName);
		if(!a.exists() || FileName==QString::null)return 0;
		else PainterBG->load(FileName);
		//
		int dy=Pixmap.width()-PainterGauge->width();
		dy=dy+ThemeYMinTop;
		double k=ThemeYMinTop-ThemeYMaxTop;
		k=k/(double)100;
		int dy0=dy-(int)k*B;
		bitBlt(&Pixmap,0,dy0,PainterGauge,0,dy0,PainterGauge->width(),dy);
		bitBlt(&Pixmap,0,dy0-PainterTop->height()/2,PainterTop,0,0);
		bitBlt(&Pixmap,0,0,PainterBG,0,0);

		//qWarning(QString("bitBlt(&Pixmap,0,dy0-PainterTop->height()/2,PainterTop,0,0); %1").arg(dy0));
	}

	// enable new themes
	lastAnimationStep++;

	return lastAnimationStep;
}
*/


void GBattery::pollingAnimation()
{
	dirty(lastAC,lastB);
}



void GBattery::gb08LoadNewTheme( const QString &localnewPath)
{
	//kdWarning()<<QString("XXXXXX  new theme%1\n").arg(localnewPath);
	QString newPath=localnewPath;
	if(newPath=="")newPath="kxdocker/plugins/gbattery/";
	QString XMLConf="";


	QFile a;
	XMLConf=QString("%1/%1").arg(newPath).arg("theme.xml");
	XMLConf=::locate("data",XMLConf);
	a.setName(XMLConf);
	if(!a.exists() || XMLConf==QString::null)
	{
		// enable old theme style
		/*
		bTheme.battery_none="na.png";
		bTheme.battery_ac="externalpower.png";
		bTheme.battery_full="battery_plugged.png";
		bTheme.battery_plug_full="battery_full.png";
		bTheme.battery_plug_over="battery_analog_plug_fg.png";
		bTheme.battery_plug_back="battery_analog_plug_bg1.png";
		bTheme.battery_plug_top="battery_analog_plug_level.png";
		bTheme.battery_plug_middle="battery_analog_plug_gauge.png";
		bTheme.battery_plug_empty="battery_analog_plug_bg0.png";
		bTheme.battery_prefix="";
		bTheme.battery_prefix_plug="";
		bTheme.battery_back="battery_analog_bg1.png";
		bTheme.battery_empty="battery_analog_bg0.png";
		bTheme.battery_over="";
		bTheme.battery_top="battery_analog_level.png";
		bTheme.battery_middle="battery_analog_gauge.png";
		bTheme.align=1;
		bTheme.xbase=0;
		bTheme.ybase=101;
		*/
		bTheme.align=-1;
		//kdWarning()<<"GBattery: old theme loaded\n";
	}
	else
	{
		QFile 	xmlFile;
		xmlFile.setName(XMLConf);
		QDomDocument doc( "KXDocker_Plugin_ThemeScheme" );
		if ( !xmlFile.open( IO_ReadOnly ) )
		{
			return;
		}
		if ( !doc.setContent( &xmlFile) ) {
			xmlFile.close();
			return;
		}
		xmlFile.close();
		QDomElement docElem = doc.documentElement();
		{
			bool okRet=false;
			bTheme.align=docElem.attribute("align","1").toInt(&okRet);
			if(okRet==false)bTheme.align=1;
			bTheme.xbase=docElem.attribute("xbase","0").toInt(&okRet);
			if(okRet==false)bTheme.xbase=0;
			bTheme.ybase=docElem.attribute("ybase","101").toInt(&okRet);
			if(okRet==false)bTheme.ybase=101;
			bTheme.battery_none=docElem.attribute("battery_none","na.png");
			bTheme.battery_ac=docElem.attribute("battery_ac","externalpower.png");
			bTheme.battery_full=docElem.attribute("battery_full","battery_full.png");
			bTheme.battery_plug_full=docElem.attribute("battery_plug_full","battery_plugged.png");
			bTheme.battery_plug_over=docElem.attribute("battery_plug_over","battery_analog_plug_fg.png");
			bTheme.battery_plug_back=docElem.attribute("battery_plug_back","battery_analog_plug_bg1.png");
			bTheme.battery_plug_top=docElem.attribute("battery_plug_top","battery_analog_plug_level.png");
			bTheme.battery_plug_middle=docElem.attribute("battery_plug_middle","battery_analog_plug_gauge.png");
			bTheme.battery_plug_empty=docElem.attribute("battery_plug_empty","battery_analog_plug_bg0.png");
			bTheme.battery_prefix=docElem.attribute("battery_prefix","");
			bTheme.battery_prefix_plug=docElem.attribute("battery_prefix_plug","");
			bTheme.battery_back=docElem.attribute("battery_back","battery_analog_bg1.png");
			bTheme.battery_empty=docElem.attribute("battery_empty","battery_analog_bg0.png");
			bTheme.battery_over=docElem.attribute("battery_over","");
			bTheme.battery_top=docElem.attribute("battery_top","battery_analog_level.png");
			bTheme.battery_middle=docElem.attribute("battery_middle","battery_analog_gauge.png");
		}

		// loading images:
		gb08LoadImage(bTheme.img_battery_none,newPath,bTheme.battery_none);
		gb08LoadImage(bTheme.img_battery_ac,newPath,bTheme.battery_ac);
		gb08LoadImage(bTheme.img_battery_full,newPath,bTheme.battery_full);
		gb08LoadImage(bTheme.img_battery_plug_full,newPath,bTheme.battery_plug_full);
		gb08LoadImage(bTheme.img_battery_plug_over,newPath,bTheme.battery_plug_over);
		gb08LoadImage(bTheme.img_battery_plug_back,newPath,bTheme.battery_plug_back);
		gb08LoadImage(bTheme.img_battery_plug_top,newPath,bTheme.battery_plug_top);
		gb08LoadImage(bTheme.img_battery_plug_middle,newPath,bTheme.battery_plug_middle);
		gb08LoadImage(bTheme.img_battery_plug_empty,newPath,bTheme.battery_plug_empty);
		gb08LoadImage(bTheme.img_battery_back,newPath,bTheme.battery_back);
		gb08LoadImage(bTheme.img_battery_empty,newPath,bTheme.battery_empty);
		gb08LoadImage(bTheme.img_battery_over,newPath,bTheme.battery_over);
		gb08LoadImage(bTheme.img_battery_top,newPath,bTheme.battery_top);
		gb08LoadImage(bTheme.img_battery_empty,newPath,bTheme.battery_empty);
		gb08LoadImage(bTheme.img_battery_middle,newPath,bTheme.battery_middle);
	}
}


/*!
    \fn GBattery::gb08LoadImage(QImage &, const QString &,const QString &)
 */
void GBattery::gb08LoadImage(QImage &tg_img, const QString &fp,const QString &fn)
{
	QFile a;
	QString FileName;
	QString FileNameResource;
	if(fp=="")FileName=fn;
	else FileName=QString("%1/%1").arg(fp).arg(fn);
	FileNameResource=FileName;
	//Configurator->
	FileName=::locate("data",FileNameResource);
	a.setName(FileName);
	if(!a.exists() || FileName==QString::null)
	{
		// create black image
		tg_img.create(1,1,32);
		tg_img.setAlphaBuffer(false);
		tg_img.fill(0);
		tg_img.setAlphaBuffer(true);
	}
	else 
	{
		tg_img.load(FileName);
	}
}

int GBattery::gb08Paint(int pAC,int pCharge)
{
	if(bTheme.align<0)
	{
		// oldStyle
		loadOldTheme(pAC, pCharge);
		ImageBuffer.load(iconName);
		return 0;
	}
	QImage Gauge;
	QImage ITop;
	QImage Logo;
	if(pAC)
	{
		if(pCharge<0)
		{
			ImageBuffer=bTheme.img_battery_ac.copy();
			return 0;
		}
		else if(pCharge>=99)
		{
			ImageBuffer=bTheme.img_battery_plug_full.copy();
			return 0;
		}
		else if(pCharge==0)
		{
			ImageBuffer=bTheme.img_battery_plug_empty.copy();
			return 0;
		}
		else
		{
			ImageBuffer=bTheme.img_battery_plug_back.copy();
			Gauge=bTheme.img_battery_plug_middle;
			ITop=bTheme.img_battery_plug_top;
			Logo=bTheme.img_battery_plug_over;
		}
	}
	else
	{
		if(pCharge<0)
		{
			ImageBuffer=bTheme.img_battery_none.copy();
			return 0;
		}
		else if(pCharge>=99)
		{
			ImageBuffer=bTheme.img_battery_full.copy();
			return 0;
		}
		else if(pCharge==0)
		{
			ImageBuffer=bTheme.img_battery_empty.copy();
			return 0;
		}
		else
		{
			ImageBuffer=bTheme.img_battery_back.copy();
			Gauge=bTheme.img_battery_middle;
			ITop=bTheme.img_battery_top;
			Logo=bTheme.img_battery_over;
		}
	}
	
	int startPaintMiddleFrom=0;
	int startPaintMiddleFor=0;
	if(bTheme.align)
	{
		startPaintMiddleFor=Gauge.height();
		startPaintMiddleFor=(int)(((double)(startPaintMiddleFor))/((double)100)*(double)pCharge);
		startPaintMiddleFrom=bTheme.ybase-startPaintMiddleFor;
		bitBlt(&ImageBuffer,bTheme.xbase,startPaintMiddleFrom,&Gauge,0,Gauge.height()-startPaintMiddleFor,Gauge.width(),startPaintMiddleFor);
		bitBlt(&ImageBuffer,bTheme.xbase,startPaintMiddleFrom-ITop.height()/2,&ITop,0,0,ITop.width(),ITop.height());
		bitBlt(&ImageBuffer,0,0,&Logo,0,0,Logo.width(),Logo.height());
	}
	else
	{
		startPaintMiddleFor=Gauge.width();
		startPaintMiddleFor=(int)(((double)(startPaintMiddleFor))/((double)100)*(double)pCharge);
		startPaintMiddleFrom=bTheme.xbase-startPaintMiddleFor;
		bitBlt(&ImageBuffer,startPaintMiddleFrom,bTheme.ybase,&Gauge,Gauge.width()-startPaintMiddleFor,0,startPaintMiddleFor,Gauge.height());
		bitBlt(&ImageBuffer,startPaintMiddleFrom-ITop.width()/2,bTheme.ybase,&ITop,0,0,ITop.width(),ITop.height());
		bitBlt(&ImageBuffer,0,0,&Logo,0,0,Logo.width(),Logo.height());
	}
	lastAnimationStep++;
	return lastAnimationStep;
}
