/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GTHROTTLE__H
#define GTHROTTLE__H

#include "gpluginsdk.h"
#include <qpixmap.h>
#include <kiconloader.h>
class QPixmap;


class gPluginPainter;

class GBattery : public gPluginSDK
{
  Q_OBJECT
public:
	GBattery(QObject *parent = 0, const char *name = 0);
	~GBattery();
public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void dirty(int, int);
    virtual void xStop();
    virtual void xStart();
    void pollingAnimation();


protected:
	void loadResources(const QString newPath);
	void managePopUp();

	int lastAC, lastB;
	gPluginPainter *Painter;
	QPixmap *PainterGauge;
	QPixmap *PainterTop;
	QPixmap *PainterBG;
	//gPluginPainter *PainterBottom;
	//gPluginPainter *PainterBG;
	
	int lastAnimationStep;
	int	ThemeYMinTop;
	int	ThemeYMaxTop;
	class QTimer	*Animator;
	int iMiniText;

	QString themepath;
	QPixmap Pixmap;
	QString iconName;
	QString tryFindIcon(int,QString, QString);
    void loadOldTheme(int, int);
    int loadNewTheme(int,int);
};


#endif
