/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GAMAROK_H
#define XEPLUGIN_GAMAROK_H

#include <qobject.h>
#include <libkxdocker.h>

class DCOPClient;


class XEPlugin_GAmarok : public gPluginSDK
{
  Q_OBJECT
public:
	XEPlugin_GAmarok(QObject *parent = 0, const char *name = 0);
	~XEPlugin_GAmarok();
public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void dirty(const QString &);
    virtual void xStop();
    virtual void xStart();
    void setAlbum(const QString);
    void getAlbumImage(QString &);
    void getTitle(QString &);
protected:
	QString themepath;
	QString defaultBackground;
	QString lastAlbumImage;
	void loadResources(const QString);
	int getTotalTime();
	int getCurrentTime();
	int getPlayPercentage();
	void loadThemeScheme(const QString &);
    QObject *  Respawn(QObject *);
	//int IconSize;
	DCOPClient *client;
	QString lastTitle;
	QString Title;
	QString theme_gaugefilename;
	int theme_gaugetype;
	int theme_xalbum;
	int theme_yalbum;
	int theme_zalbum;

	QImage	lastImage;
	QImage	Original;
	QImage	miniPlay;
	QImage	background;
	QImage	gaugeFilled;
	QImage	Album;
};

#endif
