/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_DCOPBASE_H
#define XEPLUGIN_DCOPBASE_H

#include <qobject.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qimage.h>


/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_DCOPBase : public QObject
{
Q_OBJECT
public:
    XEPlugin_DCOPBase(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_DCOPBase();
    void loadPlugin(const QString);
    void parse(const QString,const QString, int);
    void swapIcons(int a,int b);
protected:
	static class XEPlugin_DCOPInterface *DCOPInterface;
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	class XEConfiguration *Configurator;
public slots:
	virtual void changeBackground(const QString);
	virtual void changeImage(int index, const QString);
	virtual void queryExit();
	virtual void changeText(int index,const QString);
	virtual int findIcon(const QString);
	virtual void addIcon(
		const QString newName,
		const QString newImg,
		const QString overText,
		const QString onClickExec,
		const QString className,
		const QString groupName,
		const QString fileName,
		const QString windowTitle,
		const QString taskName,
		const QString taskClass
	);
	virtual void removeIcon(int index);
	virtual void changeImageByName(const QString,const QString);
	virtual void changeTextByName(const QString,const QString);
	//void changeUtf8TextByName(const QString ,const QString);
	//void changeLocal8TextByName(const QString ,const QString);
	//void changeEncodedTextByName(const QString ,const QString, const QString);
	virtual void bounceByName(const QString);
	virtual void rollUpIcon(uint);
	virtual void rollDownIcon(uint);
	virtual void rollUpIconByName(const QString);
	virtual void rollDownIconByName(const QString);
	virtual void addAlias(const QString);
	virtual void removeByName(const QString);
	virtual QStringList getPluginParameters(const QString);
	virtual QStringList getPluginList();
	virtual void addPlugin(const QString);
	virtual void configurePlugin(const QString);
	virtual void hide();
	virtual void startPluginIconByName(const QString);
	virtual void removePlugin(const QString);
	virtual void setPluginParameter(const QString Name, const QString Parameter,const QString Value);
	virtual void show();
	virtual void startPlugin(const QString);
	virtual void stopPlugin(const QString);
	virtual int getRunningByName(const QString);
	virtual void setRunningByName(const QString,int);
	virtual void changeImage(int, QPixmap);
	virtual void changeImage(const QString, QPixmap);
	virtual void changeImage(int, QImage);
	virtual void changeImage(const QString, QImage);
	virtual void changeMiniTextByName(const QString,const QString);
	virtual void changeTextPropertyByName(const QString,const QString, const QString);
	virtual int getConfigurationInt(const QString);
	virtual QString getConfigurationString(const QString);
	virtual QStringList getConfigurationStringList(const QString);
	virtual void setOverlayImageByName(const QString ,int ,int , const QString);
	virtual void setConfigurationInt(const QString,int);
	virtual void fadeByName(const QString,int);
	virtual void xSetup();
	virtual void xStop();
	virtual void xStart();
	virtual void xGetParameter(const QString,QString&);
	virtual void xGetInfo(QStringList &);
	virtual void xStopAnimateBackground();
	virtual void xStartAnimateBackground();
	virtual void removeRollingIcon(uint Index);
	virtual void stopBounceByName(const QString);
	virtual void startBounceByName(const QString);
signals:
	void xGetParameterList(QStringList*);
	void xTargetSetupParameter(const QString,const QString);
	void xGetTargetParameterList(QStringList *);
	void xGetTargetParameter(const QString,QString&);
	void xParseTo(const QString &,const QString &, int, void *);
};

#endif
