/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef XEPLUGIN_CFGICON_H
#define XEPLUGIN_CFGICON_H

#include "cfgwnd_icon.h"
#include <libkxdocker.h>
class QListViewItem;

class XEPlugin_CfgIcon : public cfgwnd_icon
{
  Q_OBJECT

public:
  XEPlugin_CfgIcon(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~XEPlugin_CfgIcon();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/

protected:
  /*$PROTECTED_FUNCTIONS$*/
KPopupMenu *pMenu;
KPopupMenu *pTaskMenu;
QListViewItem *casella;
QListViewItem *casellaTask;
XEConfiguration *Configurator;
XGDocker *xGDocker;
struct XSConfigurations *ActiveConfiguration;
int UpdatingFields;
XSGObjectIcon *ObjectIcon;

protected slots:
  /*$PROTECTED_SLOTS$*/
void kl_remove();
void kl_insert();

public slots:
    virtual void onOK();
    virtual void onConfigurePlugin();
    void xUpdateForm(const QString &);
    void xSetup();
    void xUpdateForm(XSGObjectIcon *);
    void xUpdateForm(int);
    virtual void obj_icon_textChanged(const QString&);
    virtual void minitext_toggled(bool);
    virtual void kListView1_rightButtonClicked(QListViewItem*,const QPoint&,int);
    virtual void wizard2_clicked();
    virtual void downloadMoreThemes_leftClickedURL(const QString&);
    virtual void plugin_update_leftClickedURL(const QString&);
    virtual void plugin_manual_leftClickedURL(const QString&);
    virtual void plugin_update_leftURL(const QString&);
    virtual void plugin_update_enteredURL(const QString&);
    virtual void plugin_manual_leftURL(const QString&);
    virtual void plugin_mail_leftClickedURL(const QString&);
    virtual void plugin_download_leftClickedURL(const QString&);
    virtual void Configure_clicked();
    virtual void kIconButton1_iconChanged(QString);
    virtual void obj_image_spinner_textChanged(const QString&);
    virtual void obj_overlay_textChanged(const QString&);
    virtual void obj_image_drop_textChanged(const QString&);
    virtual void obj_image_arrow_textChanged(const QString&);
    virtual void obj_overtext_textChanged(const QString&);
    virtual void obj_class_textChanged(const QString&);
    virtual void obj_group_textChanged(const QString&);
    virtual void obj_name_textChanged(const QString&);
/*
    virtual void action_drop_2_2_textChanged(const QString&);
    virtual void action_drop_2_2_returnPressed();
    virtual void action_drop_2_textChanged(const QString&);
    virtual void action_click_2_textChanged(const QString&);
*/
    virtual void action_drop_textChanged(const QString&);
    virtual void action_click_textChanged(const QString&);
    virtual void kListView9_rightButtonClicked(QListViewItem*,const QPoint&,int);
    virtual void kListView9_itemRenamed(QListViewItem*);
    void task_list_add_title();
    void task_list_add_class();
    void task_list_add_dcop();
    void task_list_add_task();
    void task_list_del();
    virtual void cfg_dcopclose_textChanged(const QString&);
    virtual void cfg_dcopraise_textChanged(const QString&);
    virtual void cfg_dcopnew_textChanged(const QString&);
protected:
    virtual void kListView1_itemRenamed(QListViewItem*);
    virtual void XDegree_valueChanged(int);
    void cfg_update_status();
    void updateComboFromFolderPNG(KComboBox *,const QString &);
    void tryReloadIcon();
    void updateComboFromFolder(KComboBox *,const QString &,const QString &,const QString &);
protected:
    int cerca_in_plugins_cfg(XSGObjectIcon *);
    void cfg_update_tasklist();
    void cfg_update_plugin_info();
signals:
	void xFetchGetInfo(QStringList &);
protected:
    void apply_this_update_to_everyone(const QString &);
};

#endif

