/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XGDOCKER_H
#define XGDOCKER_H

#include "xeconfiguration.h"


/*--HEADERSTART--*/
#include <qwidget.h>

class XGIcon;
class QTimer;
class XSConfigurations;


/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XGDocker : public QWidget
{
Q_OBJECT
public:
    XGDocker(QWidget *parent = 0, const char *name = 0,int i=0);

    ~XGDocker();
    virtual void xDockerRedraw(QObject *);
    virtual XGIcon * xGetPointerObjectIcon(int);
    virtual int getRaised();
    virtual void xUpdate(int t=0,int p=0);
    virtual QImage * xGetBackground();
    virtual void xCheckBackgroundSeparators();
    virtual int xGetIconIndex(const QObject*);
    virtual void mouseMoveEventSW(int,int,int force=0,Qt::ButtonState button=Qt::NoButton);
    virtual void paintIn(QImage &,int);
    QTimer * polling;
	int isAnimating;
	int xLastX,xLastY;

public slots:
    virtual void xChangeBackground(const QString &);
    virtual void xGetObjectIcon(int,XGIcon *&);
//    virtual void xReloadIcon(int);
    virtual void xEventTaskAppend(int);
    virtual void xGetInfo(QStringList &);
    virtual void xStart();
    virtual void xStep();
    virtual void xStop();
    virtual void xEventReloadIcon(int);
    virtual void wheelEvent(QWheelEvent *);
    virtual void xParse(const QString &, int, void *);
    virtual void xUpdateRepaint(int);
    virtual void xSetup();
    virtual void xEventShowRaised();
    virtual void xMouseMoveSoftware(int,int);
    virtual void paint(QImage &);
    virtual void xDockerRedraw();
    virtual void xSwapIcons(int,int);
    virtual void xUpdateSense();
protected:
    class XSConfigurations *ActiveConfiguration;
};

/*--HEADERSTOP--*/

#endif
