/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEOBJECT_H
#define XEOBJECT_H

#include <qobject.h>
#include <qptrlist.h> 
#include <qstringlist.h>
/*
#include <time.h>

extern timespec microSeconds;
//void minisleep(unsigned long);


static void minisleep(unsigned long uSeconds)
{
	static timespec rem;
	microSeconds.tv_nsec=1000*uSeconds;
	microSeconds.tv_sec=0;
	nanosleep(&microSeconds,&rem);
}
*/


/**
@author Stefano
*/
class XEObject : public QObject
{
Q_OBJECT
public:
    XEObject(QObject *parent = 0, const char *name = 0);

    ~XEObject();
    static QObject * xGetRoot();
    static QObject * xGetConfiguration();
    static QObject * xGetMatrix();
    static QObject * xGetDocker();
    static QObject * xGetXMLParser();
    static QObject * xFindObject(const QString &hisName);
    
    static void xSetEngineDocker(QObject *);
    static void xSetXMLParser(QObject *);
    static void xSetEngineEvents(QObject *);
    static void xSetEngineConfiguration(QObject *);
    static void xSetEngineMatrix(QObject *);
    void xWarningMsg(const QObject *, const QString &);
    static const QStringList xGetPluginListNames();
protected:
    static QObject * xEngineRoot;
    static QObject * xEngineMatrix;
    static QObject * xXMLParser;
    static QObject * xEngineDocker;
    static QObject * xEngineConfiguration;
    static QObject * xEngineEvents;
    static QPtrList<QObject> xPlugins; 
    static QStringList	xPluginList;
public slots:
    
    static void xPluginAdd(QObject *);
    static void xPluginDel(QObject *);
    void xGetDocker(QObject *&);
    void xGetConfiguration(QObject  *&);
    void xParse(const QString &, int, void *);
};

#endif
