/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xktray.h"
#include <klocale.h>
#include <kiconloader.h>
#include <kpopupmenu.h>
#include <qcheckbox.h>
#include "xeobject.h"

#include <kxdocker_setup_sources.h>


#include <kaboutdialog.h>
#include <kaboutapplication.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <qfile.h>
#include <qdir.h>
#include "xeconfiguration.h"


extern const char version [];

#include "xktray.moc"


XKTray::XKTray(QWidget *parent, const char *name)
 : KSystemTray(parent, name)
{
	XEObject::xPluginAdd(this);
	trobbler="kxdocker/themes/trobblers/default";
	connect(&trobblerAnimator,SIGNAL(timeout()),this,SLOT(step()));
	connect(this,SIGNAL(xFindResource(const QString,QString&)),
		parent,SLOT(xFindResource(const QString,QString&)));
	trobblerlastStep=0;
	trobblerList.clear();
	trobblerLastabsolutePath="";
}


XKTray::~XKTray()
{
	XEObject::xPluginDel(this);
}



/*!
    \fn XKTray::xWarning(const QString &)
 */
void XKTray::xWarning(const QString &Message)
{
	qWarning(i18n(Message));
}


/*!
    \fn XKTray::xWarningMsg(const Object *, const QString &)
 */
void XKTray::xWarningMsg(const QObject *Sender, const QString &Message)
{
	QString WarningMsg=Sender->name();
	WarningMsg=WarningMsg+": "+i18n(Message);
	qWarning(WarningMsg);
}


/*!
    \fn XKTray::xSetup()
 */
void XKTray::xSetup()
{
	// Emits Signal of warning
#ifndef ENABLE_FINAL
	xWarningMsg(this,"xSetup");
#endif
	// load cfg
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	fetchDefaultParameters();

	QString baseImage="";
	xFindTrobbler(trobbler,baseImage,0);
	if(baseImage=="")
	{
		xFindTrobbler("kxdocker/themes/trobblers/default/",baseImage,0);
	}
	if(baseImage=="")
	{
		xFindTrobbler("kxdocker/themes/icons/kxdocker-help.png",baseImage,0);
	}
	if(baseImage=="")
	{
		xActiveIcon=loadIcon("kxdocker");
	}
	//else(xActiveIcon.load(baseImage));
	else(xActiveIcon=loadIcon(baseImage));
	setPixmap(xActiveIcon);
	
	// setup the popup configurations
	KPopupMenu *Menu=contextMenu();
	Menu->setCheckable ( true);
	Menu->insertTitle(loadIcon("window_new"),"Task manager");
	//QCheckBox	*aaaa=new QCheckBox("Show windows from all desktops",NULL);
	//Menu->insertItem(aaaa);
	//m_popup->setItemChecked(m_selectedItem, false);
	QObject	*xTaskManager=XEObject::xFindObject("xTaskManager");
	idShowAll=0;
	if(xTaskManager)
	{
		idShowAll=Menu->insertItem(loadIcon("desktop"),"Show windows from all desktops",
			this,SLOT(xToggleShowAll()));
		connect
		(
			this,
			SIGNAL(xTaskMgr_GetParameter(const QString, int&)),
			xTaskManager,
			SLOT(xGetParameter(const QString, int&))
		);
		connect
		(
			this,
			SIGNAL(xToggleShowAllDispatch()),
			xTaskManager,
			SLOT(xToggleShowAll())
		);
		
		int allshow=0;
		if(allshow==0)
		{
			Menu->setItemChecked(idShowAll, false);
		}
		else
		{
			Menu->setItemChecked(idShowAll, true);
		}
		xTaskMgr_GetParameter(QString("showWindowsOnlyFromThisDesktop"),allshow);
	}
	
	if(XEObject::xFindObject("xConfigurator")!=NULL)
	{
	Menu->insertTitle(loadIcon("configure"),"Setup docker");
	Menu->insertItem(loadIcon("iconthemes"),"Configurator",
		XEObject::xFindObject("xConfigurator"),SLOT(xConfigure()));
	}
	Menu->insertItem(loadIcon("player_play"),"Start background Animations",
		XEObject::xGetDocker(),SLOT(xStartAnimateBackground()));
	Menu->insertItem(loadIcon("player_pause"),"Stop background Animations",
		XEObject::xGetDocker(),SLOT(xStopAnimateBackground()));

	Menu->insertTitle(loadIcon("kxdocker"),i18n("Informations"));
	Menu->insertItem(loadIcon("idea"),"About KXDocker",
		this,SLOT(xAbout()));


	/*
	Menu->insertItem(loadIcon("desktop"),"Show windows from all desktops",
		this,SLOT(RunLastCmd()));
	*/
}


/*!
    \fn XKTray::xStart()
 */
void XKTray::xStart()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStart");
#endif
	show();
	trobblerAnimator.start(500);
}


/*!
    \fn XKTray::xStop()
 */
void XKTray::xStop()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStop");
#endif
	trobblerAnimator.stop();
	hide();


}


/*!
    \fn XKTray::xToggleShowAll()
 */
void XKTray::xToggleShowAll()
{
	KPopupMenu *Menu=contextMenu();
	xToggleShowAllDispatch();
		int allshow=0;
		if(allshow==0)
		{
			Menu->setItemChecked(idShowAll, false);
		}
		else
		{
			Menu->setItemChecked(idShowAll, true);
		}
}


/*!
    \fn XKTray::xGetParameter(const QString,QString&)
 */
void XKTray::xGetParameter(const QString vname,QString& vvalue)
{
	if(vname=="trobbler")
	{
		vvalue=trobbler;
	}
}


/*!
    \fn XKTray::xGetParameterList(QStringList*)
 */
void XKTray::xGetParameterList(QStringList*a)
{
	a->append("trobbler");

}

/*!
    \fn XKTray::xAbout()
 */
void XKTray::xAbout()
{
	static KAboutApplication *ad=new KAboutApplication();
/*
	static KAboutDialog *ad=new KAboutDialog();
	ad->setTitle(i18n("KXDocker the docker"));
	//qWarning(::locate("data","kxdocker/kxdocker_logo.jpg"));
	//ad->setImage(::locate("data","kxdocker/kxdocker_logo.png"));
	//ad->setProgramLogo(QPixmap(::locate("data","kxdocker/kxdocker_logo.png")));
	ad->setProduct(
		"KXDocker",
		KXDOCKERVERSION,
		"Stefano Zingarini",
		"2003"
		);
	ad->setAuthor(
		"Stefano Zingarini",
		"stefano@xiaprojects.com",
		"http://www.xiaprojects.com",
		"Core Developer"
		);
*/
	ad->show();
}


/*!
    \fn XKTray::step()
 */
void XKTray::step()
{
	//qWarning("void XKTray::step()");
	//setPixmap(xActiveIcon);
	QString lastFrameFile;
	if(trobblerList.count()<1)
	{
		trobblerlastStep=0;
		xFindTrobbler(trobbler,lastFrameFile,0);
		if(trobblerList.count()<1)
		{
			trobblerAnimator.stop();
			return;
		}
	}
	else lastFrameFile=trobblerList[trobblerlastStep];
	//qWarning("void XKTray::step2()");
	//qWarning(lastFrameFile);

	//xActiveIcon.load(lastFrameFile);
	xActiveIcon=loadIcon(lastFrameFile);
	trobblerlastStep++;
	if(trobblerlastStep>=trobblerList.count())trobblerlastStep=0;
	setPixmap(xActiveIcon);
	if(trobblerList.count()<2)trobblerAnimator.stop();
}


/*!
    \fn XKTray::xFindTrobbler(const QString, QString &, int)
 */
void XKTray::xFindTrobbler(const QString baseImage, QString &loadThis, int frameStep)
{
	//qWarning(QString("void XKTray::xFindTrobbler(const QString %1, QString &%1, int %1)").arg(baseImage).arg(loadThis).arg(frameStep));
	QString absolutePath;
	QString fileName;
	QFile a;
	QDir d;
	loadThis="";

	absolutePath=::locate("data",baseImage);
	if(absolutePath.isNull()||absolutePath=="")
	{
		return;
	}

	if(trobblerLastabsolutePath==absolutePath)
	{
		loadThis=trobblerList[frameStep];
		return;
	}


	d.setPath(absolutePath);
	if(d.exists())
	{
		trobblerLastabsolutePath=absolutePath;
		d.setFilter(QDir::Files | QDir::Hidden);
		d.setSorting(QDir::Name);
	        const QFileInfoList *list = d.entryInfoList();
        	QFileInfoListIterator it( *list );
        	QFileInfo *fi;
		while ( (fi = it.current()) != 0 ) {
			fileName=absolutePath+"/";
			fileName=fileName+fi->fileName();
			trobblerList.append(fileName);
			++it;
		}
	}
	else
	{
		// it's a filename
		a.setName(absolutePath);
		if(a.exists())
		{
			loadThis=absolutePath;
		}
		else
		{
			return;
		}
	}
}


/*!
    \fn XKTray::fetchDefaultParameters()
 */
void XKTray::fetchDefaultParameters()
{
	//qWarning("void XKTray::fetchDefaultParameters()");
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		//qWarning(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name);
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xTray")
		{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
		{
			trobbler=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("trobbler", "kxdocker/themes/trobblers/default/");
			//qWarning(QString("trobbler=%1").arg(trobbler));
		}
		else
		{
		// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
		
		}
		
		break;
		}
	
	}
}


/*!
    \fn XKTray::xSetupParameter(const QString,const QString)
 */
void XKTray::xSetupParameter(const QString vname,const QString vvalue)
{
	if(vname=="trobbler")
	{
		trobbler=vvalue;
		trobblerAnimator.stop();
		trobblerLastabsolutePath="";
		trobblerlastStep=0;
		trobblerList.clear();
		trobblerAnimator.start(500);
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xTray")
			{
			// update xml configuration
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
			("trobbler",trobbler);
			}
		}

	}
}
