/*
 * Copyright (C) 2004 Stefano <stefano@xiaprojects.com>
 */

#include "kxdocker.h"

#include <kapplication.h>
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "kxdocker_setup_sources.h"

static const char description[] =
    I18N_NOOP("KXDocker is an innovative <em>docker</em> <br><ul><LI><strong>Skinnable</strong> bar with animated background</LI><LI><strong>Rolling Icons</strong>, our most innovative feature!</LI><LI><strong>AutoResize</strong>, the first docker which will fit always in your screen</LI><LI><strong>Drag'n Drop</strong>support</LI> <LI>Configurable <strong>Xinerama</strong> support</LI><LI><strong>DCOP and Windows tracing</strong>: forget taskbar</LI><LI><strong>Speed</strong>! No computation at runtime</LI><LI>Support for many existing <strong>animation Designs</strong></LI><li>Lots of external <strong>plugins</strong> to manage applications and sensors</li></ul>");



static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kxdocker", I18N_NOOP("KXDocker"),
			KXDOCKERVERSION,
			description,
			KAboutData::License_GPL,
			"(C) 2002-2005 Stefano",
			0,
			"http://www.xiaprojects.com/www/prodotti/kxdocker",
			"stefano@xiaprojects.com");

about.addAuthor( "Stefano", I18N_NOOP("Core Developer"), "stefano@xiaprojects.com" );

about.addCredit( "Lucio", I18N_NOOP("Contributors"),
"lucio@xiaprojects.com","http://www.brainsfactory.org" );
about.addCredit( "Stefano", I18N_NOOP("Contributors"), "stefano@xiaprojects.com","http://www.xiaprojects.com" );
about.addCredit( "Eric", I18N_NOOP("Contributors"));
about.addCredit( "Magilla", I18N_NOOP("Contributors"));
about.addCredit( "Michel", I18N_NOOP("Contributors"));
about.addCredit( "Narcis", I18N_NOOP("Contributors"));
about.addCredit( "Andreas", I18N_NOOP("Contributors"));
about.addCredit( "Bruno", I18N_NOOP("Minor developers"));
about.addCredit( "Filip", I18N_NOOP("Minor developers"));
about.addCredit( "Lucio", I18N_NOOP("Minor developers"));
about.addCredit( "Magilla", I18N_NOOP("Minor developers"));
about.addCredit( "Thomas", I18N_NOOP("Minor developers"));
about.addCredit( "Saurabh", I18N_NOOP("Minor developers"));
about.addCredit( "Vagninu (Danilo)", I18N_NOOP("Minor developers"));


about.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\\nYour names")
 ,I18N_NOOP("_: EMAIL OF TRANSLATORS\\nYour emails"));
/*
I18N_NOOP("Maintainer")
*/

	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions( options );

#ifdef DAEMON
	if (!KUniqueApplication::start())
	{
		qWarning("KXDocker is already running!");
		return (0);
	}
	KUniqueApplication app;
	KXDocker *mainWin = 0;
	// no session.. just start up normally
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	
	/// @todo do something with the command line args here
	
	mainWin = new KXDocker();
	//app.setMainWidget( mainWin );
	//mainWin->show();
	
	args->clear();
#else
#endif


/*
    if (app.isRestored())
    {
        //RESTORE(KXDocker);
    }
    else
    {
*/
//    }

	// mainWin has WDestructiveClose flag by default, so it will delete itself.
	return app.exec();
}

