/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gmounts.h"

#include <kmountpoint.h>
#include <kpopupmenu.h>

#include "xeconfiguration.h"
#include "xgdocker.h"
#include "xgicon.h"

#include "xeplugin_gmounts.moc"


XEPlugin_GMounts::XEPlugin_GMounts(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xPluginAdd(this);
	KDEWatch	=new KDirWatch();
}


XEPlugin_GMounts::~XEPlugin_GMounts()
{
}




/*!
    \fn XEPlugin_GMounts::xSetup()
 */
void XEPlugin_GMounts::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GMounts::xSetup()");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	// reload xml
	onClickExec="konqueror --caption \"browse %MOUNTPOINT%\" \"%MOUNTPOINT%\"";
	prefixCaption="browse ";
	// supported formats:
	// %MOUNTPOINT%
	// %DEVICE%
	// %DEVICETYPE%

	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
			{
			AutoAddMounts=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("AutoAddMounts","yes");
			onClickExec=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onClickExec","konqueror --caption \"browse %MOUNTPOINT%\" \"%MOUNTPOINT%\"");
			prefixCaption=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("prefixCaption","browse ");

			}
			else
			{
		// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
			
			}
			break;
		}
	}



}


/*!
    \fn XEPlugin_GMounts::xStart()
 */
void XEPlugin_GMounts::xStart()
{
	
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (uint i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
#ifndef ENABLE_FINAL
		qWarning(DeviceMounted->mountPoint());
#endif
		
		MountAdded(DeviceMounted->mountPoint(),DeviceMounted->realDeviceName(),DeviceMounted->mountType());
		
	}
	
	KDEWatch->addFile("/etc/mtab");
	connect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	KDEWatch->startScan();
	
	
}


/*!
    \fn XEPlugin_GMounts::xStop()
 */
void XEPlugin_GMounts::xStop()
{
	disconnect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	KDEWatch->stopScan();
}


/*!
    \fn XEPlugin_GMounts::MountAdded(const QString &)
 */
void XEPlugin_GMounts::MountAdded(const QString &newMount,const QString &device,const QString &devicetype)
{
	for(uint i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
#ifndef ENABLE_FINAL
			qWarning("Matched icon for this mountpoint");
#endif
			// searching if it's being showed
			for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
#ifndef ENABLE_FINAL
				qWarning("xeplugin_gmounts.cpp:108");
#endif
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_GMounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
#ifndef ENABLE_FINAL
				qWarning("NON e' null");
				qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->OverText);
#endif
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
#ifndef ENABLE_FINAL
			qWarning("xeplugin_gmounts.cpp:115");
#endif
		// is disabled?
		if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Info.className=="disabled")return;
	// if there are too icons, we can exit because no more will be added
	// TODO: MaxIconsShowed=0
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)
	{
		//qWarning(name());
		return;
	}
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();


//			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			//addedCfg->Info.className=name();
			addedCfg->Info.className="xGMounts";
			
			addedCfg->Tasks.Proces.clear();
			addedCfg->Tasks.TaskInfo=NULL;
			addedCfg->Tasks.MiniTextShow=2;
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images;
			addedCfg->Actions=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions;
//			ActiveConfiguration->ObjectsIcons.count()++;
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
			return;
		}
	}

	// 0.34
	// check if we like to auto attach
	if(AutoAddMounts!="no")
	{
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
	if(devicetype=="sysfs")return;
	if(devicetype=="proc")return;
	if(devicetype=="procfs")return;
	if(devicetype=="devpts")return;
	if(devicetype=="binfmt_misc")return;
			//XSGObjectIcon *addedCfg=new XSGObjectIcon;
			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

			
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			//ActiveConfiguration->ObjectsIcons.append(addedCfg);
			//ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=newMount;
			addedCfg->Info.fileName=newMount;
			addedCfg->Info.Name=newMount;
			addedCfg->Info.Group=newMount;
			//addedCfg->Info.className="xMounts";
			
			addedCfg->Tasks.Proces.clear();
			addedCfg->Tasks.MiniTextShow=2;
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=NULL;
			//addedCfg->Tasks.TaskName=newMount;
			//addedCfg->Tasks.WindowTitle=newMount;
			if(devicetype=="")addedCfg->Images.imgFileName="hdd_mount";
			else addedCfg->Images.imgFileName=QString("mount_%1").arg(devicetype);
			//addedCfg->Actions.onClickExec=QString("konqueror %1").arg(newMount);
			// 0.37
			addedCfg->Actions.onClickExec=onClickExec
					.replace("%MOUNTPOINT%",newMount);
					//.replace("%DEVICE%",newMount)


			XSCfgMatchIcons *addedCfgMatch=new XSCfgMatchIcons;
			//XSGObjectIcon *addedCfg2=new XSGObjectIcon;
			//addedCfg2=addedCfg;
			//addedCfg2->OverText="pippo";
			//addedCfg2->Info.className="GMounts";
			addedCfg->Info.className="GMounts";
			addedCfgMatch->Icon=addedCfg;
			addedCfgMatch->SystemName=newMount;
			addedCfg->Tasks.WindowTitle=QString("%1%1").arg(prefixCaption).arg(newMount);

			ActiveConfiguration->Plugins.Matches.append(addedCfgMatch);
			// 0.35
			MountAdded(newMount,device,devicetype);
//			ActiveConfiguration->ObjectsIcons.count()++;
			//xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
			return;
	}
}


/*!
    \fn XEPlugin_GMounts::dirty(const QString &)
 */
void XEPlugin_GMounts::dirty(const QString &)
{
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (uint i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
//		qWarning(DeviceMounted->mountPoint());

		MountAdded(DeviceMounted->mountPoint(),DeviceMounted->realDeviceName(),DeviceMounted->mountType());
		
	}
	// ok now removing the old one
	int indexfind;
	for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==name())
		{
			indexfind=-1;
			for (uint i=0;i<devList.count();i++)
			{
				DeviceMounted=devList[i];
				if(DeviceMounted==NULL)break;
				
if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==DeviceMounted->mountPoint()){
					indexfind=i;
					break;
				}
			}
			if(indexfind<0)
			{
				// remove it
				xGDocker->iconRemove(iconIndex);
			}
		}
	}
	
}


/*!
    \fn XEPlugin_GMounts::xGetParameter(const QString,QString&)
 */
void XEPlugin_GMounts::xGetParameter(const QString vname,QString& vvalue)
{
	if(vname=="AutoAddMounts")vvalue=(AutoAddMounts);
	if(vname=="onClickExec")vvalue=(onClickExec);
	if(vname=="prefixCaption")vvalue=(prefixCaption);
}


/*!
    \fn XEPlugin_GMounts::xGetParameterList(QStringList*)
 */
void XEPlugin_GMounts::xGetParameterList(QStringList* a)
{
	a->append("AutoAddMounts");
	a->append("onClickExec");
	a->append("prefixCaption");

}


/*!
    \fn XEPlugin_GMounts::xGetInfo(QStringList &)
 */
void XEPlugin_GMounts::xGetInfo(QStringList &a)
{
	QStringList PluginInformations;
	QString Version=KXDOCKERVERSION;
	Version=Version+"-0.4";
	PluginInformations.append("KXDocker GMounts");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append(KXDOCKERDATE); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=manual");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download")); // url update
	
	a=PluginInformations;

}


/*!
    \fn XEPlugin_GMounts::xSetupParameter(const QString, const QString)
 */
void XEPlugin_GMounts::xSetupParameter(const QString sName, const QString sValue)
{
/*
	bool okRet=false;
	if(sName=="desktopPreview")
	{
		desktopPreview=sValue.toInt(&okRet);
		if(okRet==false)
		{
			desktopPreview=0;
		}
	}
*/
	if(sName=="AutoAddMounts")
	{
		AutoAddMounts=sValue;
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
			{
			// update xml configuration
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("AutoAddMounts",AutoAddMounts);
			}
		}	
	}
	if(sName=="prefixCaption")
	{
		prefixCaption=sValue;
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
			{
			// update xml configuration
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("prefixCaption",prefixCaption);
			}
		}	
	}
	if(sName=="onClickExec")
	{
		onClickExec=sValue;
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
			{
			// update xml configuration
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("onClickExec",onClickExec);
			}
		}
	}
}
