/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gepillow.h"

#include <xeobject.h>
#include <xeconfiguration.h>
#include <xgdocker.h>
#include <xgicon.h>

#include <kwin.h>
#include <krootpixmap.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kapplication.h>
#include <kwinmodule.h>
#include <kwin.h>
#include <netwm.h>
#include <dcopclient.h>

#include <qpainter.h>
#include <qbitmap.h>

//#undef ENABLE_FINAL


#include "xeplugin_gepillow.moc"

XEPlugin_GEPillow::XEPlugin_GEPillow(QWidget *, const char *name)
 : QWidget(NULL, name)
{
	if(name!=NULL)XEObject::xPluginAdd(this);

	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);

	NegativeX=0;
}


XEPlugin_GEPillow::~XEPlugin_GEPillow()
{
}




/*!
    \fn XEPlugin_GEPillow::xSetupParameter(const QString, const QString)
 */
void XEPlugin_GEPillow::xSetupParameter(const QString, const QString)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GEPillow::paintEvent( QPaintEvent *e)
 */
void XEPlugin_GEPillow::paintEvent( QPaintEvent *e)
{
	rect = e->rect();
	l=rect.left();
	t=rect.top();
	w=rect.width();
	h=rect.height();
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);

}


/*!
    \fn XEPlugin_GEPillow::xRefresh
 */
void XEPlugin_GEPillow::xRefresh()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GEPillow::xStart
 */
void XEPlugin_GEPillow::xStart()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::xStart()");
#endif

//	qWarning("void XEPlugin_GEPillow::xStart()");
	paintBuffer.resize(QApplication::desktop()->width(),30);
	paintBuffer.fill(Qt::black);
	resize(QApplication::desktop()->width(),30);
	//show();
	KDesktopBackground->start();
}


/*!
    \fn XEPlugin_GEPillow::xStop
 */
void XEPlugin_GEPillow::xStop()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::stop()");
#endif
    /// @todo implement me
}


/*!
    \fn XEPlugin_GEPillow::xSetup
 */
void XEPlugin_GEPillow::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::xSetup()");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();

	KDesktopBackground=new KRootPixmap((QWidget*)this);
	connect(KDesktopBackground, 
		SIGNAL(backgroundUpdated(const QPixmap &)), 
		this, SLOT(backgroundUpdated(const QPixmap &)));
	
	KDesktopBackground->setCustomPainting(true);

	connect(xGDocker,
	SIGNAL(xEventWidgetMoved(int,int,int,int,int,int)),
	this,
	SLOT(xEventWidgetMoved(int,int,int,int,int,int))
	);

}


/*!
    \fn XEPlugin_GEPillow::externalDrawPillow(QObject *,int,int)
 */
void XEPlugin_GEPillow::externalDrawPillow(QObject *newIcon,int x,int y)
{
	//if(!isShown())return;

#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::externalDrawPillow(QObject *newIcon,int x,int y)");
#endif
/*
	XGIcon *xGIcon=(XGIcon *)newIcon;
	if(!xGIcon->isTextDrawed)xGIcon->xDrawText();
	// we don't want transparency at this time than we apply the automask
	paintBuffer.fill(Qt::red);
	//setMask(xGIcon->xImgText.createAlphaMask());
	//setMask(*xGIcon->xImgText.mask());
	
	QPixmap a;
	//a.convertFromImage(xGIcon->xImgText);
	const QBitmap *ma=xGIcon->xImgText.mask();
	if(ma)setMask(*ma);
	bitBlt(&paintBuffer,0,0,
				&xGIcon->xImgText,
//				bsw,
//				bsh,
				Qt::CopyROP);
	move(x,y);
	repaint(false);
*/
	XGIcon *xGIcon=(XGIcon *)newIcon;
	//if(!xGIcon->isTextDrawed)xGIcon->xDrawText();

	//paintBuffer.fill(Qt::red);

	bitBlt(&paintBuffer,0,0,
				&pixmapBackground,
				Qt::CopyROP);
	bitBlt(&paintBuffer,NegativeX+x,30-xGIcon->xIconTextPillow.xImageText.height()+y,
				xGIcon->xIconTextPillow.xGetPixmapText(),
//				bsw,
//				bsh,
				Qt::CopyROP);
	repaint(false);
}


/*!
    \fn XEPlugin_GEPillow::xGetInfo(QStringList &)
 */
void XEPlugin_GEPillow::xGetInfo(QStringList &)
{
    /// @todo implement me
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::xGetInfo(QStringList &)");
#endif
}


/*!
    \fn XEPlugin_GEPillow::backgroundUpdated(const QPixmap &)
 */
void XEPlugin_GEPillow::backgroundUpdated(const QPixmap &)
{
	//pixmapBackground=pb;
	//repaint(false);
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::backgroundUpdated(const QPixmap &)");
#endif
}


/*!
    \fn XEPlugin_GEPillow::xEventWidgetMoved(int,int,int , int , int,int)
 */
void XEPlugin_GEPillow::xEventWidgetMoved(int x,int y,int , int , int,int)
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::xEventWidgetMoved(int x,int y,int , int , int,int)");
#endif
	
	move(0,y-30);
	NegativeX=x;
}


/*!
    \fn XEPlugin_GEPillow::show()
 */
void XEPlugin_GEPillow::show()
{
	//return;
	if(isShown())return;
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::show()");
#endif

	KWin::setType(winId(), NET::Dock);

	pixmapBackground=QPixmap::grabWindow(
		QApplication::desktop()->winId(),
		x(), y(),
		width(),
		height()
		);
	// 0.37 fix
	bitBlt(&paintBuffer,0,0,
				&pixmapBackground,
				Qt::CopyROP);
	QWidget::show();
	setUnShadowed();
	KWin::setOnAllDesktops(winId(),true);
	KWin::setState( winId(), NET::StaysOnTop );
	raise();
}


/*!
    \fn XEPlugin_GEPillow::hide()
 */
void XEPlugin_GEPillow::hide()
{
//	lower();
	//KWin::setState( winId(), NET::KeepBelow);
	if(isShown())QWidget::hide();
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::hide()");
#endif
}


/*!
    \fn XEPlugin_GEPillow::setUnShadowed()
 */
inline void XEPlugin_GEPillow::setUnShadowed()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GEPillow::setUnShadowed()");
#endif

       QByteArray data2;
        QDataStream arg2(data2, IO_WriteOnly);
        //arg2 << topLevelWidget()->winId();
	arg2 << winId();
        kapp->dcopClient()->send(
           "kwin",
           "KWinInterface",
           "setUnshadowed(unsigned long int)"
           ,data2);
}
