/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_DCOP_H
#define XEPLUGIN_DCOP_H


#include <dcopobject.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qimage.h>

/**
@author Stefano
*/
class XEPlugin_DCOP : public QObject
{
Q_OBJECT
protected:
	static class XEPlugin_DCOPInterface *DCOPInterface;
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
public:
    XEPlugin_DCOP(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_DCOP();
    void changeBackground(const QString);
    void changeImage(int index, const QString);
    void queryExit();
    void changeText(int index,const QString);
    int findIcon(const QString);
    void addIcon(
	const QString newName,
	const QString newImg,
	const QString overText,
	const QString onClickExec,
	const QString className,
	const QString groupName,
	const QString fileName,
	const QString windowTitle,
	const QString taskName,
	const QString taskClass
    
    );
    void removeIcon(int index);
    void changeImageByName(const QString,const QString);
    void changeTextByName(const QString,const QString);
    void bounceByName(const QString);
    void rollUpIcon(uint);
    void rollDownIcon(uint);
    void rollUpIconByName(const QString);
    void rollDownIconByName(const QString);
    void addAlias(const QString);
    void removeByName(const QString);
    QStringList getPluginParameters(const QString);
    QStringList getPluginList();
    void addPlugin(const QString);
    void configurePlugin(const QString);
    void hide();
    void startPluginIconByName(const QString);
    void removePlugin(const QString);
    void setPluginParameter(const QString Name, const QString Parameter,const QString Value);
    void show();
    void startPlugin(const QString);
    void stopPlugin(const QString);
    int getRunningByName(const QString);
    void setRunningByName(const QString,int);
    void changeImage(int, QPixmap);
    void changeImage(const QString, QPixmap);
    void changeImage(int, QImage);
    void changeImage(const QString, QImage);
    void changeMiniTextByName(const QString,const QString);
    void changeTextPropertyByName(const QString,const QString, const QString);
    int getConfigurationInt(const QString);
    QString getConfigurationString(const QString);
public slots:
    void xSetup();
    void xStop();
    void xStart();
    void xGetParameter(const QString,QString&);
    void xGetInfo(QStringList &);
    void xStopAnimateBackground();
    void xStartAnimateBackground();
    void removeRollingIcon(uint Index);
    void stopBounceByName(const QString);
    void startBounceByName(const QString);
signals:
    void xGetParameterList(QStringList*);
    void xTargetSetupParameter(const QString,const QString);
    void xGetTargetParameterList(QStringList *);
    void xGetTargetParameter(const QString,QString&);
};

class XEPlugin_DCOPInterface: public DCOPObject
{
	K_DCOP
	private:
		QStringList functionsList;
	protected:
		static XEPlugin_DCOP *DockerInterface;

	public:
		XEPlugin_DCOPInterface(XEPlugin_DCOP *);

		~XEPlugin_DCOPInterface();

	k_dcop:
		QStringList list();
		bool exit();
		bool changebackground(const QString);
    void changeImage(int index,const QString newImage);
    void changeText(int index,const QString newText);
    int findIcon(const QString iconName);
    void addIcon(
	const QString newName,
	const QString newImg,
	const QString overText,
	const QString onClickExec,
	const QString className,
	const QString groupName,
	const QString fileName,
	const QString windowTitle,
	const QString taskName,
	const QString taskClass
    
    
    );
    void addAlias(const QString);
    void removeIcon(int index);
    void changeImageByName(const QString,const QString);
    void changeTextByName(const QString,const QString);
    void bounceByName(const QString);
    void rollUpIcon(int);
    void rollDownIcon(int);
    void rollUpIconByName(const QString);
    void rollDownIconByName(const QString);
    void removeByName(const QString);
    QStringList getPluginParameters(const QString);
    QStringList getPluginList();
    void addPlugin(const QString);
    void configurePlugin(const QString);
    void hide();
    void startPluginIconByName(const QString);
    void removePlugin(const QString);
    void setPluginParameter(const QString Name, const QString Parameter,const QString Value);
    void show();
    void startPlugin(const QString);
    void stopPlugin(const QString);
    void stopAnimateBackground();
    void startAnimateBackground();
    void stopBounceByName(const QString);
    void startBounceByName(const QString);
    int getRunningByName(const QString);
    void setRunningByName(const QString,int);
    void changeImage(int, QPixmap);
    void changeImageByName(const QString, QPixmap);
    void changeImage(int, QImage);
    void changeImageByName(const QString, QImage);
    void changeMiniTextByName(const QString,const QString);
    void changeTextPropertyByName(const QString,const QString, const QString);
    int getConfigurationInt(const QString);
    QString getConfigurationString(const QString);
};

#endif
