/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktn_proc.h"

KTN_Proc::KTN_Proc(QObject *parent, const char *name)
 : QObject(parent, name)
{
}


KTN_Proc::~KTN_Proc()
{
}


#include "ktn_proc.moc"


/*!
    \fn KTN_Proc::networkFindDevices(QStringList &)
 */
int KTN_Proc::networkFindDevices(QStringList &NewList)
{
	// local definitios to avoid thread mutex
	FILE *fd;
	int RetCode=0;

	char buf[512], tag[32],  *tmp, *tmp2;

	if((fd = fopen("/proc/net/dev", "r")) == NULL) return 0;

	fgets(buf, 512, fd);
	fgets(buf, 512, fd);

	while(!feof(fd)) {

		fgets(buf, 512, fd);

		memset(tag, 0, 32);

		tmp = buf;
		tmp2 = tag;

		while(*tmp == ' ') tmp++;
		while((*tmp2++ = *tmp++) != ':');

		*--tmp2 = '\0';
		if(
			NewList.count() > 0 && NewList[NewList.count()-1]==tag
			)continue;
		NewList.append(tag);
		RetCode++;
	}

	fclose(fd);
	return(RetCode);
}


/*!
    \fn KTN_Proc::setDevicesNetwork(const QStringList &)
 */
void KTN_Proc::setDevicesNetwork(const QStringList &newlist)
{
	devicesNetwork=newlist;	
}

int KTN_Proc::networkPoll()
{
	int RetCode=0;
	FILE *fd;
	if((fd = fopen("/proc/net/dev", "r")) == NULL) return RetCode;

	char buf[512];
	char tag[32];
	char *tmp,*tmp2;
	float cS[16];
	float tx[10];
	float rx[10];
	
	for (int oo=0;oo<10;oo++)
	{
		tx[oo]=0;
		rx[oo]=0;
	}
	
	// first line
	fgets(buf, 512, fd);
	fgets(buf, 512, fd);

	while(!feof(fd)) {

		fgets(buf, 512, fd);

		memset(tag, 0, 32);

		tmp = buf;
		tmp2 = tag;

		while(*tmp == ' ') tmp++;
		while((*tmp2++ = *tmp++) != ':');

		*--tmp2 = '\0';

		sscanf(tmp, "%f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f",
		&cS[0], &cS[1], &cS[2], &cS[3], &cS[4], &cS[5], &cS[6], &cS[7], &cS[8], &cS[9], &cS[10], &cS[11], &cS[12], &cS[13], &cS[14], &cS[15]);
		
		for(int i=0;i<devicesNetwork.count();i++)
		{
			if(devicesNetwork[i]==tag)
			{
				// got the enabled device...
				if(cS[0]!=networkRX[i] || cS[8]!=networkTX[i] )
				{
					RetCode++;

				}
				
			if(cS[0] > networkRX[i]) {
				rx[i]=cS[0];
			}

			if(cS[8] > networkTX[i]) {

				tx[i]=cS[8];
			}

			if(cS[0] <= networkRX[i] | cS[8] <= networkTX[i]) {
	
					rx[i]=cS[0];
					tx[i]=cS[8];
			}

			}
		}

	}
	fclose(fd);

	for(int oo=0;oo<10;oo++)
	{
		networkTX[oo]=tx[oo];
		networkRX[oo]=rx[oo];
		
	}
	return RetCode;
}

/*!
    \fn KTN_Proc::getNetworkTX()
 */
const float * KTN_Proc::getNetworkTX()
{
    /// @todo implement me
    return networkTX;
}

const float * KTN_Proc::getNetworkRX()
{
    /// @todo implement me
    return networkRX;
}
