/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gnetio.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <qimage.h>
#include <stdlib.h>



#include "gnetio.moc"

extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	qWarning("GNetIO xeplugin_register()");
	return new GNetIO(parent,"GNetIO");
}


int main()
{
	qWarning("You cannot run this plugin, lets KXDocker load it");
	//GNetIO NetIO;
	//NetIO.printStatus();
	GNetIO::printStatus();
	return 0;
}

GNetIO::GNetIO(QObject *parent, const char *name)
 : QObject(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="NetIO Meter";
	asKXDocker021=false;
	devicesList.clear();
	netWorkDevice="eth0";
	devicesList.append(netWorkDevice);
	proc.setDevicesNetwork(devicesList);
	Scale=1024;
	PollingRate=1000;
}

GNetIO::~GNetIO()
{

}

void GNetIO::printStatus()
{
	KTN_Proc proc;
	
	QStringList devicesList;
	devicesList.append("eth0");
	qWarning(devicesList[0]);
	
	// this will fill the list with networks devices
	//proc.networkFindDevices(lista);
	// ok than setup what we like to search
	proc.setDevicesNetwork(devicesList);
	for(;;)
	{
	if(proc.networkPoll()==0);
	
	const float *newIns=proc.getNetworkRX();
	const float *newOuts=proc.getNetworkTX();
	
	static float totalIn[10];
	static float totalOut[10];
	
	for(int i=0; i<10 && i<devicesList.count();i++)
	{
		float newIn=	newIns[i];
		float newOut=	newOuts[i];
		float rateIn=newIn-totalIn[i];
		float rateOut=newOut-totalOut[i];
		totalIn[i]=newIn;
		totalOut[i]=newOut;
		QString debugTest;
		debugTest.setNum(rateOut);
		qWarning(debugTest);
	}
	sleep(1);
	}
	
}

void GNetIO::updateNet()
{
	if(proc.networkPoll()==0);
	
	const float *newIns=proc.getNetworkRX();
	const float *newOuts=proc.getNetworkTX();
	
	for(int i=0; i<10 && i<devicesList.count();i++)
	{
		float newIn=	newIns[i];
		float newOut=	newOuts[i];
		rateIn=newIn-totalIn[i];
		rateOut=newOut-totalOut[i];
		totalIn[i]=newIn;
		totalOut[i]=newOut;
		
		// only 1 device
		break;
	}
	
	// 0.1 version will show the sum
	Percentage=(rateIn+rateOut)/Scale;
}

void GNetIO::xSetup()
{
	qWarning("GNetIO::xSetup()");
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
}


void GNetIO::xRefresh()
{
	if(xGIcon==NULL)return;
	
	xPaint();
	cachePurge();
	xSetSmoothZoom();
	if(Percentage!=lastPercentage)
	{
		drawPixmap(Percentage);
		ToolTip=QString("%1: %1% %1%").arg(netWorkDevice).arg(rateIn).arg(rateOut);
		xSetText(ToolTip);
		
	}
	// New engine 20040602
	// to avoid the full redraw
	if(asKXDocker021==true)xDockerRedraw(xGIcon);
	else xDockerRedraw();
	lastPercentage=Percentage;
}


void GNetIO::xStart()
{
	qWarning("GNetIO::xStart()");
	QTimer::singleShot(1000, this, SLOT(pollCpuStart()));
	// Threads!
	xRefresh();
}


void GNetIO::xStop()
{
}


void GNetIO::xAttach(QObject *newIcon)
{
	// ok have to write the buffer into
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=newIcon;
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));
		
		xGetPluginConfiguration(xXMLIconConfig);
		
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("path");
		}
		
		
		xGetImage(xImgSource);
		
		connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		asKXDocker021=connect(this,SIGNAL(xDockerRedraw(QObject *)),xGDocker,SLOT(xDockerRedraw(QObject *)));
		if(asKXDocker021==false)qWarning("GNetIO: You are using an older version of KXDocker, please upgrade to KXDocker >= 0.21 you can get it from http://www.xiaprojects.com [the plugin may be slow!]");
		else qWarning("GNetIO: found a good version of KXDocker [>=0.21] [this will increase perfomance]");
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIcon(QObject *)));
	
	// base Image
	QString kdeshare="kxdocker/plugins/gnetio/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/CPUMonitor.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"CPUMonitor.png";
	}
	BasePixmap.load(::locate("data",cpuPaths));
	BufferPixmap.resize(BasePixmap.size());
	
	BufferPixmap.fill(Qt::black);
	
	
		pollCpu();
		return;
	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
	}
}


void GNetIO::xPaint()
{
}
void GNetIO::xRefreshIcon(QObject *newIcon)
{

	if(newIcon==xGIcon)
	{
		pollCpu();
		xPaint();
		cachePurge();
		xSetSmoothZoom();
		// xGDocker will auto - repaint
	}
}


void GNetIO::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;
	if(vname=="path")
	{
		IconsPath=vvalue;
	}
	if(vname=="device")
	{
		netWorkDevice=vvalue;
		devicesList.clear();
		devicesList.append(netWorkDevice);
		proc.setDevicesNetwork(devicesList);
		
	}
	if(vname=="polling")
	{
		PollingRate=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			PollingRate=1000;
		}

	}
	if(vname=="rate_bytes")
	{
		Scale=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			Scale=1024;
		}
	}
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("path",IconsPath);
	}
	else
	{
		createXMLTree();
	}
	

}

void GNetIO::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="path")
	{
		vvalue=IconsPath;
	}
	
	if(vname=="device")
	{
		vvalue=netWorkDevice;
	}
	if(vname=="rate_bytes")
	{
		vvalue.setNum(Scale);
	}
	if(vname=="polling")
	{
		vvalue.setNum(PollingRate);
	}
}
void GNetIO::xGetParameterList(QStringList *a)
{
	a->append("path");
	a->append("device");
	a->append("rate_bytes");
	a->append("polling");
}

void GNetIO::createXMLTree()
{
// Ok, You don't have specified the xml configuration, we have to create it!!
	// Creating fake document
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("pluginconf");
	// Ok this is a plugin Configuration
	QStringList	a;
	// Creating the Attributes via the standard plugin interface
	xGetParameterList(&a);
	for(int istoringXML=0;istoringXML<a.count();istoringXML++)
	{
		QString returnValue;
		xGetParameter(a[istoringXML],returnValue);
		CreatingCfg.setAttribute(a[istoringXML],returnValue);
	}
	// Now appending to the configuration
	fakeRoot.appendChild(CreatingCfg);
	// this will do a right cast;
	QDomNodeList pfx=(QDomNodeList)*xXMLIconConfig;
	pfx=fakeRoot.childNodes();
//	*xXMLIconConfig=&fx;
	//xXMLIconConfig->appendChild(fakeRoot.childNodes());
	if(pfx.count()<1)
	{
		qWarning("Error! XML Plugin configuration will not be stored.");
	}
	else
		qWarning("kxdocker 0.19 will not store correctly the configuration, you have to add the path on pluginconf manually, please upgrade to kxdocker 0.20");
}

void GNetIO::pollCpu()
{
	//printStatus();
	updateNet();
	drawPixmap(Percentage);
	xRefresh();
	QTimer::singleShot( PollingRate, this, SLOT(pollCpu()));
}

void GNetIO::pollCpuStart()
{
	// todo: here we have to do threads
	return;
}

void GNetIO::drawPixmap(int nPercentage)
{

	
	QPixmap line;
	QString kdeshare="kxdocker/plugins/gnetio/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/line.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"line.png";
	}
	
	QPixmap Pixmap;
	// copying background
	
	Pixmap.load(::locate("data",cpuPaths));
	cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/empty.png";
	a.setName(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"empty.png";
	}
	QPixmap Empty;
	Empty.load(::locate("data",cpuPaths));
	
	// sliding the buffer
	//QPixmap	offScreen(128,128);
	QPixmap	offScreen=BasePixmap;
	QPixmap	offScreen2(128,128);
	//offScreen.fill(Qt::black);
	offScreen2.fill(Qt::black);
	QBitmap	maskera(128,128);
	maskera.fill(Qt::color0);
	// the base monitor
	//bitBlt(&offScreen,0,0,&BasePixmap,Qt::CopyROP);
	//offScreen=BasePixmap;
	// the green layout
	// moving to right
	bitBlt(&offScreen2,13+Pixmap.size().width(),15,&BufferPixmap,13,15);
	// clean the line with backgrund transparent
	bitBlt(&offScreen2,13,15,&Empty);
	// draw the percentage
	bitBlt(&offScreen2,13,115-nPercentage,&Pixmap,0,100-nPercentage,Pixmap.size().width(),nPercentage);
	// draw to the layout
	bitBlt(&BufferPixmap,0,0,&offScreen2,0,0,BasePixmap.size().width()-13);
	//bitBlt(&maskera,0,0,&BufferPixmap,0,0,BasePixmap.size().width()-13);
	
	//BufferPixmap.setMask(maskera);
/*	
	
	offScreen.setMask(offScreen.createHeuristicMask());
*/	
	BufferPixmap.setMask(BufferPixmap.createHeuristicMask());
	
	bitBlt(&offScreen,0,0,&BufferPixmap);
	*xImgSource=offScreen.convertToImage();
	
}


QString GNetIO::tryFindIcon(int AC ,QString B, QString themePath)
{
	// search for theme/c95.png
	QString basePath=themePath;
//qWarning(B);
	QString batteryPaths=B;
	//batteryPaths.setNum(B);
	if(AC>0)
	{
	batteryPaths="c"+batteryPaths;
	}
	else
	{
	
	}
	batteryPaths=basePath+batteryPaths;
	batteryPaths=batteryPaths+".png";
	
	batteryPaths=::locate("data",batteryPaths);
//qWarning(batteryPaths);
	QFile a(batteryPaths);
	if(!a.exists() || batteryPaths==QString::null)
	{
		return NULL;
	}
	return batteryPaths;	
}
