//
// C++ Interface: gmail
//
// Description: 
//
//
// Author: Stefano <stefano@xiaprojects.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GMAIL_H
#define GMAIL_H

#include <qobject.h>

#include <qstring.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>


/**
@author Stefano
*/
class GMail : public QObject
{
Q_OBJECT
public:
    GMail(QObject *parent = 0, const char *name = 0);

    ~GMail();
protected:
	QObject			*xGDocker;
	QObject			*xGIcon;
	QImage			*xImgSource;
	const QDomNodeList	*xXMLIconConfig;
	QString			IconsPath;
	QString			ToolTip;
	QString			incomingIcon;
	QPixmap			BasePixmap;
	QPixmap			IncomingPixmap;
//	QPixmap			BufferPixmap;
	int			lastNum;
	int			eNum;
	int			internalStatus;
	int			seconds;
	int			NotebookLED;
	QString			folderName;

signals:
    void xGetImage(QImage *&);
    void xSetSmoothZoom();
    void cachePurge();
    void xDockerRedraw();
    void xDockerRedraw(QObject *);
    void xGetDocker(QObject *&);
    void xGetPluginConfiguration(const QDomNodeList *&);
    void xSetText(const QString &);


public slots:
    void xGetParameterList(QStringList *);
    void xAttach(QObject *);
    void xGetParameter(const QString, QString&);
    void xRefresh();
    void xRefreshIcon(QObject *);
    void xSetup();
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void pollMails();
protected:
    void drawPixmap(int);
    void loadImages();
};

#endif
