/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gcpu.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <qimage.h>
#include <stdlib.h>


#include "gcpu.moc"

extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	qWarning("GCpu xeplugin_register()");
	return new GCpu(parent,"GCpu");
}


int main()
{
	qWarning("You cannot run this plugin, lets KXDocker load it");
	GCpu cpu;
	cpu.printStatus();
	return 0;
}

GCpu::GCpu(QObject *parent, const char *name)
 : QObject(parent, name)
{
#ifdef Q_OS_LINUX
  m_procStream = 0L;
  if ((m_procFile = fopen("/proc/stat", "r")))
    m_procStream = new QTextStream(m_procFile, IO_ReadOnly);
#endif

	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="CPU Meter";
	asKXDocker021=false;
}

GCpu::~GCpu()
{
	delete m_procStream;
}

void GCpu::printStatus()
{
	//qWarning("CPU0 Status:");
	CpuData cpuData;
	int cpuNumber=0;
	updateCpu(cpuData,cpuNumber);
	
	/*
	qWarning(QString("name: [%1] user: [%1] nice: [%1] sys: [%1] idle: [%1]")
		.arg(cpuData.name)
		.arg(cpuData.user)
		.arg(cpuData.nice)
		.arg(cpuData.sys)
		.arg(cpuData.idle)
		);
	*/	
		
    int cpuDiff = 0;
    current.setData(cpuData);
    cpuData -= current.oldData();
    
        cpuDiff = cpuData.sys + cpuData.user + cpuData.nice;
	//cpuDiff = cpuData.user;
      if (cpuDiff > 100)
        cpuDiff = 100;
	Percentage=cpuDiff;
    //qWarning(QString("Throttling: %1%").arg(cpuDiff));
    //usleep(1000000);
}

void GCpu::updateCpu(CpuData &cpu, int cpuNumber)
{
#ifdef Q_OS_LINUX
  if (!m_procStream)
    return;

  bool cpuFound = false;
  QString output;
  QString parser;
  QString cpuString;
  cpuString.setNum(cpuNumber).prepend("cpu");

  // Parse the proc file
  while (!m_procStream->atEnd()) {
    parser = m_procStream->readLine();
    // remove all the entries apart from the line containing 'cpuString'
    if (!cpuFound && parser.find(QRegExp(cpuString)) != -1) {
      output = parser;
      cpuFound = true;
    }
  }

  QStringList cpuList = QStringList::split(' ', output);

  if (!cpuList.isEmpty()) {
    cpu.name = cpuList[0].stripWhiteSpace();
    cpu.user = cpuList[1].toULong();
    cpu.nice = cpuList[2].toULong();
    cpu.sys = cpuList[3].toULong();
    cpu.idle = cpuList[4].toULong();
  }

  fseek(m_procFile, 0L, SEEK_SET);
#endif

#ifdef Q_OS_FREEBSD
#warning "add support for SMP on FreeBSD"
  static int name2oid[2] = { 0, 3 };
  static int oidCpuTime[CTL_MAXNAME + 2];
  static size_t oidCpuTimeLen = sizeof(oidCpuTime);
  long cpuTime[CPUSTATES];
  size_t cpuTimeLen = sizeof(cpuTime);
  static char *name = "kern.cp_time";
  static int initialized = 0;

  if (!initialized) {
    if (sysctl(name2oid, 2, oidCpuTime, &oidCpuTimeLen,
       name, strlen(name)) < 0)
      return;

    oidCpuTimeLen /= sizeof(int);
    initialized = 1;
  }

  if (sysctl(oidCpuTime, oidCpuTimeLen,
     cpuTime, &cpuTimeLen, 0, 0) < 0)
    return;

  cpu.user = cpuTime[CP_USER];
  cpu.nice = cpuTime[CP_NICE];
  cpu.sys = cpuTime[CP_SYS];
  cpu.idle = cpuTime[CP_IDLE];
#endif

#if defined(Q_OS_OPENBSD) || defined(Q_OS_NETBSD)
#warning "add support for SMP on OpenBSD and NetBSD"
  int name2oid[2] = { CTL_KERN, KERN_CPTIME };
  long cpuTime[CPUSTATES];
  unsigned int cpuTimeLen = sizeof(cpuTime);

  if (sysctl(name2oid, 2, &cpuTime, &cpuTimeLen,
     0, 0) < 0)
    return;

  cpu.user = cpuTime[CP_USER];
  cpu.nice = cpuTime[CP_NICE];
  cpu.sys = cpuTime[CP_SYS];
  cpu.idle = cpuTime[CP_IDLE];
#endif
}




/*!
    \fn XEPlugin_GApplet::xSetup()
 */
void GCpu::xSetup()
{
	qWarning("GCpu::xSetup()");
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
}


void GCpu::xRefresh()
{
	if(xGIcon==NULL)return;
	
	xPaint();
	cachePurge();
	xSetSmoothZoom();
	if(Percentage!=lastPercentage)
	{
		drawPixmap(Percentage);
		ToolTip=QString("CPU0: %1%").arg(Percentage);
		xSetText(ToolTip);
		
	}
	//xDockerRedraw();
	// New engine 20040602
	// to avoid the full redraw
	if(asKXDocker021==true)xDockerRedraw(xGIcon);
	else xDockerRedraw();
	lastPercentage=Percentage;
}


void GCpu::xStart()
{
	qWarning("GCpu::xStart()");
	QTimer::singleShot(1000, this, SLOT(pollCpuStart()));
	// Threads!
	xRefresh();
}


void GCpu::xStop()
{
}


/*!
    \fn XEPlugin_GApplet::xAttach(XGIcon *)
 */
void GCpu::xAttach(QObject *newIcon)
{
	// ok have to write the buffer into
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=newIcon;
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));
		
		xGetPluginConfiguration(xXMLIconConfig);
		
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("path");
		}
		
		
		xGetImage(xImgSource);
		
		connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		asKXDocker021=connect(this,SIGNAL(xDockerRedraw(QObject *)),xGDocker,SLOT(xDockerRedraw(QObject *)));
		if(asKXDocker021==false)qWarning("GCpu: You are using an older version of KXDocker, please upgrade to KXDocker >= 0.21 you can get it from http://www.xiaprojects.com [the plugin may be slow!]");
		else qWarning("GCpu: found a good version of KXDocker [>=0.21] [this will increase perfomance]");
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIcon(QObject *)));
	
	// base Image
	QString kdeshare="kxdocker/plugins/gcpu/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/CPUMonitor.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"CPUMonitor.png";
	}
	BasePixmap.load(::locate("data",cpuPaths));
	BufferPixmap.resize(BasePixmap.size());
	/*
	QImage TBuffer;
		TBuffer.create(
			128,
			128,
			32);
		
		TBuffer.setAlphaBuffer(false);
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		
	BufferPixmap.convertFromImage(TBuffer);
	*/
	BufferPixmap.fill(Qt::black);
	
	
		pollCpu();
		return;
	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
	}
}


void GCpu::xPaint()
{
}
void GCpu::xRefreshIcon(QObject *newIcon)
{

	if(newIcon==xGIcon)
	{
		pollCpu();
		xPaint();
		cachePurge();
		xSetSmoothZoom();
		// xGDocker will auto - repaint
	}
}


void GCpu::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="path")
	{
		IconsPath=vvalue;
	}
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("path",IconsPath);
	}
	else
	{
		createXMLTree();
	}
}

void GCpu::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="path")
	{
		vvalue=IconsPath;
	}
}
void GCpu::xGetParameterList(QStringList *a)
{
	a->append("path");
}

void GCpu::createXMLTree()
{
// Ok, You don't have specified the xml configuration, we have to create it!!
	// Creating fake document
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("pluginconf");
	// Ok this is a plugin Configuration
	QStringList	a;
	// Creating the Attributes via the standard plugin interface
	xGetParameterList(&a);
	for(int istoringXML=0;istoringXML<a.count();istoringXML++)
	{
		QString returnValue;
		xGetParameter(a[istoringXML],returnValue);
		CreatingCfg.setAttribute(a[istoringXML],returnValue);
	}
	// Now appending to the configuration
	fakeRoot.appendChild(CreatingCfg);
	// this will do a right cast;
	QDomNodeList pfx=(QDomNodeList)*xXMLIconConfig;
	pfx=fakeRoot.childNodes();
//	*xXMLIconConfig=&fx;
	//xXMLIconConfig->appendChild(fakeRoot.childNodes());
	if(pfx.count()<1)
	{
		qWarning("Error! XML Plugin configuration will not be stored.");
	}
	else
		qWarning("GBattery Version 0.0.1 with kxdocker 0.19 will not store correctly the configuration, you have to add the path on pluginconf manually, please upgrade to kxdocker 0.20");
}

void GCpu::pollCpu()
{
	printStatus();
	drawPixmap(Percentage);
	xRefresh();
	QTimer::singleShot( 1000, this, SLOT(pollCpu()));
}

void GCpu::pollCpuStart()
{
	// todo: here we have to do threads
	return;
//	for(;;)
	{
		printStatus();
		//usleep(1000000);
	}
	QTimer::singleShot( 1000, this, SLOT(pollCpuStart()));
}

void GCpu::drawPixmap(int nPercentage)
{

	
	QPixmap line;
	QString kdeshare="kxdocker/plugins/gcpu/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/line.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"line.png";
	}
	
	QPixmap Pixmap;
	// copying background
	
	Pixmap.load(::locate("data",cpuPaths));
	cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/empty.png";
	a.setName(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"empty.png";
	}
	QPixmap Empty;
	Empty.load(::locate("data",cpuPaths));
	
	// sliding the buffer
	//QPixmap	offScreen(128,128);
	QPixmap	offScreen=BasePixmap;
	QPixmap	offScreen2(128,128);
	//offScreen.fill(Qt::black);
	offScreen2.fill(Qt::black);
	QBitmap	maskera(128,128);
	maskera.fill(Qt::color0);
	// the base monitor
	//bitBlt(&offScreen,0,0,&BasePixmap,Qt::CopyROP);
	//offScreen=BasePixmap;
	// the green layout
	// moving to right
	bitBlt(&offScreen2,13+Pixmap.size().width(),15,&BufferPixmap,13,15);
	// clean the line with backgrund transparent
	bitBlt(&offScreen2,13,15,&Empty);
	// draw the percentage
	bitBlt(&offScreen2,13,115-nPercentage,&Pixmap,0,100-nPercentage,Pixmap.size().width(),nPercentage);
	// draw to the layout
	bitBlt(&BufferPixmap,0,0,&offScreen2,0,0,BasePixmap.size().width()-13);
	//bitBlt(&maskera,0,0,&BufferPixmap,0,0,BasePixmap.size().width()-13);
	
	//BufferPixmap.setMask(maskera);
/*	
	
	offScreen.setMask(offScreen.createHeuristicMask());
*/	
	BufferPixmap.setMask(BufferPixmap.createHeuristicMask());
	
	bitBlt(&offScreen,0,0,&BufferPixmap);
	*xImgSource=offScreen.convertToImage();
	
}


QString GCpu::tryFindIcon(int AC ,QString B, QString themePath)
{
	// search for theme/c95.png
	QString basePath=themePath;
//qWarning(B);
	QString batteryPaths=B;
	//batteryPaths.setNum(B);
	if(AC>0)
	{
	batteryPaths="c"+batteryPaths;
	}
	else
	{
	
	}
	batteryPaths=basePath+batteryPaths;
	batteryPaths=batteryPaths+".png";
	
	batteryPaths=::locate("data",batteryPaths);
//qWarning(batteryPaths);
	QFile a(batteryPaths);
	if(!a.exists() || batteryPaths==QString::null)
	{
		return NULL;
	}
	return batteryPaths;	
}
