/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "ganimations.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <qimage.h>
#include <stdlib.h>


#include "ganimations.moc"

extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	qWarning("GAnimations xeplugin_register()");
	return new GAnimations(parent,"GAnimations");
}


int main()
{
	qWarning("You cannot run this plugin, lets KXDocker load it");
	return 0;
}

GAnimations::GAnimations(QObject *parent, const char *name)
 : QObject(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="GAnimations";
	asKXDocker021=false;
	lastAnimationStep=-1;
	AnimationStep=0;
	AnimationSleep=100;
}

GAnimations::~GAnimations()
{
}


void GAnimations::xSetup()
{
	qWarning("GAnimations::xSetup()");
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
}


void GAnimations::xRefresh()
{
	if(xGIcon==NULL)return;
	
	xPaint();
	cachePurge();
	//xSetSmoothZoom();
	xSetZoom();
	/*
	if(AnimationStep!=lastAnimationStep)
	{
		drawPixmap(AnimationStep);
		//ToolTip=QString("CPU0: %1%").arg(Percentage);
		//xSetText(ToolTip);
		
	}
	*/
	//xDockerRedraw();
	// New engine 20040602
	// to avoid the full redraw
	if(asKXDocker021==true)xDockerRedraw(xGIcon);
	else xDockerRedraw();
	//lastAnimationStep=AnimationStep;
}


void GAnimations::xStart()
{
	qWarning("GAnimations::xStart()");
	//QTimer::singleShot(1000, this, SLOT(pollCpuStart()));
	// Threads!
	xRefresh();
}


void GAnimations::xStop()
{
}


void GAnimations::xAttach(QObject *newIcon)
{
	// ok have to write the buffer into
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=newIcon;
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		//connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		connect(this,SIGNAL(xSetZoom()),xGIcon,SLOT(xSetZoom()));
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));
		
		xGetPluginConfiguration(xXMLIconConfig);
		
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("path");
		}
		
		
		xGetImage(xImgSource);
		
		connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		asKXDocker021=connect(this,SIGNAL(xDockerRedraw(QObject *)),xGDocker,SLOT(xDockerRedraw(QObject *)));
		if(asKXDocker021==false)qWarning("GAnimations: You are using an older version of KXDocker, please upgrade to KXDocker >= 0.21 you can get it from http://www.xiaprojects.com [the plugin may be slow!]");
		else qWarning("GAnimations: found a good version of KXDocker [>=0.21] [this will increase perfomance]");
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIcon(QObject *)));
	
	// base Image
	QFile a(IconsPath);
	if(!a.exists() || IconsPath==QString::null)
	{
		qWarning(QString("Cannot find png: %1").arg(IconsPath));
		return;
	}
	
	
	multiImage.load(IconsPath);
	h=multiImage.height();
	w=multiImage.width();
	multiImageImage=multiImage.convertToImage();
		//pollCpu();
		stepAnimation();
		return;
	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
	}
}


void GAnimations::xPaint()
{
}

void GAnimations::xRefreshIcon(QObject *newIcon)
{

	if(newIcon==xGIcon)
	{
		//pollCpu();
		xPaint();
		cachePurge();
		//xSetSmoothZoom();
		xSetZoom();
		// xGDocker will auto - repaint
	}
}


void GAnimations::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;
	if(vname=="path")
	{
		IconsPath=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("path",IconsPath);
	}
	else
	{
		createXMLTree();
	}
	}
	if(vname=="msSleep")
	{
		AnimationSleep=vvalue.toInt(&okRet);
		if(okRet==false)
		{
			AnimationSleep=100;
		}
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("msSleep",IconsPath);
	}
	else
	{
		createXMLTree();
	}
	}
}

void GAnimations::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="path")
	{
		vvalue=IconsPath;
	}
	if(vname=="msSleep")
	{
		vvalue.setNum(AnimationSleep);
	}
}
void GAnimations::xGetParameterList(QStringList *a)
{
	a->append("path");
	a->append("msSleep");
}

void GAnimations::createXMLTree()
{
// Ok, You don't have specified the xml configuration, we have to create it!!
	// Creating fake document
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("pluginconf");
	// Ok this is a plugin Configuration
	QStringList	a;
	// Creating the Attributes via the standard plugin interface
	xGetParameterList(&a);
	for(int istoringXML=0;istoringXML<a.count();istoringXML++)
	{
		QString returnValue;
		xGetParameter(a[istoringXML],returnValue);
		CreatingCfg.setAttribute(a[istoringXML],returnValue);
	}
	// Now appending to the configuration
	fakeRoot.appendChild(CreatingCfg);
	// this will do a right cast;
	QDomNodeList pfx=(QDomNodeList)*xXMLIconConfig;
	pfx=fakeRoot.childNodes();
//	*xXMLIconConfig=&fx;
	//xXMLIconConfig->appendChild(fakeRoot.childNodes());
	if(pfx.count()<1)
	{
		qWarning("Error! XML Plugin configuration will not be stored.");
	}
	else
		qWarning("GAnimations Version 0.0.1 with kxdocker 0.19 will not store correctly the configuration, you have to add the path on pluginconf manually, please upgrade to kxdocker 0.20");
}

void GAnimations::stepAnimation()
{
	
	drawPixmap(AnimationStep);
	AnimationStep++;
	xRefresh();
	QTimer::singleShot(AnimationSleep, this, SLOT(stepAnimation()));
}

void GAnimations::drawPixmap(int &nAnimationStep)
{
	//qWarning(QString("Loaded [%1](%1)(%1) [%1]").arg(IconsPath).arg(w).arg(h).arg(nAnimationStep));
	
	if(h==w)
	{
		*xImgSource=multiImageImage;
		return;
	}
	else
	{
		//QPixmap  offScreen;
		QImage offScreen;
		
		if(w>h)
		{
	//		qWarning("w>h");
			int maxstep=w/h;
			if(nAnimationStep>=maxstep)nAnimationStep=0;
			/*
			offScreen.resize(h,h);
			offScreen.fill(Qt::red);
			bitBlt(&offScreen,0,0,&multiImage,nAnimationStep*h,0,h,h);
			*/
			offScreen.create(h,h,32);
		
			offScreen.setAlphaBuffer(false);
			//TBuffer.fill(QColor(255,0,0).pixel());
			offScreen.fill(0);
			offScreen.setAlphaBuffer(true);
			
			bitBlt(&offScreen,0,0,&multiImageImage,nAnimationStep*h,0,h,h);
		}
		else
		{
	//		qWarning("h>w");
			int maxstep=h/w;
			if(nAnimationStep>=maxstep)nAnimationStep=0;
			/*
			offScreen.resize(h,h);
			offScreen.fill(Qt::red);
			bitBlt(&offScreen,0,0,&multiImage,nAnimationStep*h,0,h,h);
			*/
			offScreen.create(w,w,32);
			offScreen.setAlphaBuffer(false);
			//TBuffer.fill(QColor(255,0,0).pixel());
			offScreen.fill(0);
			offScreen.setAlphaBuffer(true);
			
			bitBlt(&offScreen,0,0,&multiImageImage,0,nAnimationStep*w,w,w);
		}
		//*xImgSource=offScreen.convertToImage();
		*xImgSource=offScreen;
	}
}
