/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTN_NAMES_H
#define KTN_NAMES_H

#include <qobject.h>

#include <qstringlist.h>

/**
@author Stefano
*/
class KTN_Names : public QObject
{
Q_OBJECT
protected:
	QString bnep;
	QString bbnep;
	QString tbnep;
	QStringList cbnep;
	QStringList cibnep;
	QStringList icibnep;
	
	QString ppp;
	QString ippp;
	QString wlan;
	QString irda;
	QString tap;
	QString tun;
	QString usb;

	QString eth;
	QString sit;
	QString lo;
	QString unknow;

	QString beth;
	QString bsit;
	QString blo;
	QString bunknow;
	
	QString bppp;
	QString bippp;
	QString bwlan;
	QString birda;
	QString btap;
	QString btun;
	QString busb;

		
	QString teth;
	QString tsit;
	QString tlo;
	QString tunknow;
	QString tppp;
	QString tippp;
	QString twlan;
	QString tirda;
	QString ttap;
	QString ttun;
	QString tusb;

	QStringList ceth;
	QStringList csit;
	QStringList clo;
	QStringList cunknow;
	QStringList cppp;
	QStringList cippp;
	QStringList cwlan;
	QStringList cirda;
	QStringList ctap;
	QStringList ctun;
	QStringList cusb;

	QStringList cieth;
	QStringList cisit;
	QStringList cilo;
	QStringList ciunknow;
	QStringList ciippp;
	QStringList ciiippp;
	QStringList ciwlan;
	QStringList ciirda;
	QStringList citap;
	QStringList citun;
	QStringList ciusb;
	
	QStringList icieth;
	QStringList icisit;
	QStringList icilo;
	QStringList iciunknow;
	QStringList iciippp;
	QStringList iciiippp;
	QStringList iciwlan;
	QStringList iciirda;
	QStringList icitap;
	QStringList icitun;
	QStringList iciusb;
	
	QString filename;
	
	QString temp;
public:
    KTN_Names(QObject *parent = 0, const char *name = 0);

    ~KTN_Names();
    const QString & makeDeviceName(const QString &);
    const QString & makeDeviceTheme(const QString &);
    const QString & makeDeviceBase(const QString &);
    const QString & getResourcePath();
    const QString & getLinkCmd(const QString &iName,int index);
    const QString & getiLinkCmd(const QString &, int index);
    const QString & getLink(const QString &, int index);
};
extern KTN_Names *ktnNames;
#endif
