/***************************************************************************
                                 proc.cpp
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "proc.h"

Proc::Proc()
{
	buf = (char *) calloc(512, sizeof(char));
	tag = (char *) calloc(128, sizeof(char));
	dev = (char *) calloc(128, sizeof(char));

	cS = (float *) calloc(16, sizeof(float));
	S = (float *) calloc(2, sizeof(float));
	ret = (float *) calloc(2, sizeof(float));

	S[0] = 0;
	S[1] = 0;
}

Proc::~Proc()
{
	free(buf);
	free(tag);
	free(dev);
	free(cS);
	free(S);
	free(ret);
}

void Proc::setDev(const char *set)
{
	strcpy(dev, set);
	readLoad();
}

float *Proc::readLoad(void)
{
	ret[0] = 0;
	ret[1] = 0;

	if((fd = fopen("/proc/net/dev", "r")) == NULL) return ret;

	fgets(buf, 512, fd);
	fgets(buf, 512, fd);

	while(!feof(fd)) {

		fgets(buf, 512, fd);

		memset(tag, 0, 32);

		tmp = buf;
		tmp2 = tag;

		while(*tmp == ' ') tmp++;
		while((*tmp2++ = *tmp++) != ':');

		*--tmp2 = '\0';

		sscanf(tmp, "%f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f",
		&cS[0], &cS[1], &cS[2], &cS[3], &cS[4], &cS[5], &cS[6], &cS[7], &cS[8], &cS[9], &cS[10], &cS[11], &cS[12], &cS[13], &cS[14], &cS[15]);

		if(!strcmp(dev, tag)) {

			if(cS[0] > S[0]) {
				ret[0] = cS[0] - S[0];
				S[0] = cS[0];
			}

			if(cS[8] > S[1]) {
				ret[1] = cS[8] - S[1];
				S[1] = cS[8];
			}

			if(cS[0] < S[0] | cS[8] < S[1]) {
				S[0] = cS[0];
				S[1] = cS[8];
			}

			fclose(fd);
			return(ret);
		}

	}

	S[0] = 0;
	S[1] = 0;

	fclose(fd);
	return(ret);
}

float Proc::totalIn(void)
{
	return(S[0]);
}

float Proc::totalOut(void)
{
	return(S[1]);
}


QStringList &Proc::FindDevicesNetworks(QStringList &NewList)
{
	
	// local definitios to avoid thread mutex
	FILE *fd;

	char buf[512], tag[32],  *tmp, *tmp2;

	if((fd = fopen("/proc/net/dev", "r")) == NULL) return NewList;

	fgets(buf, 512, fd);
	fgets(buf, 512, fd);

	while(!feof(fd)) {

		fgets(buf, 512, fd);

		memset(tag, 0, 32);

		tmp = buf;
		tmp2 = tag;

		while(*tmp == ' ') tmp++;
		while((*tmp2++ = *tmp++) != ':');

		*--tmp2 = '\0';
		qWarning(tag);
		if(
			NewList.count() > 0 && NewList[NewList.count()-1]==tag
			)continue;
		NewList.append(tag);
	}

	fclose(fd);
	return(NewList);
}










