/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktraynetworker2.h"
#include <qlabel.h>

#include <kmainwindow.h>
#include <klocale.h>
#include <kurl.h>
#include <kurlrequesterdlg.h>
#include <kfiledialog.h>
#include <kpushbutton.h>
#include <qpopupmenu.h>
#include <kpopupmenu.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kicondialog.h>
#include <kiconloader.h>

#include "ktn_names.h"
#include "ktn_wizard.h"
#include "ktn_user.h"
#include "ktn_usercfg.h"

KTrayNetworker2::KTrayNetworker2(): KMainWindow( 0, "KTrayNetworker" )
{
	for(int i=0;i<10; i++)
	{
		TrayIcons[i]=NULL;
		UserGUI[i]=NULL;
	}
	Status=0;
	setXMLFile("ktraynetworkerui.rc");
	Restore=NULL;
	ElapsedTime=new QTimer(this,"ElapsedTime");
	connect(ElapsedTime, SIGNAL(timeout()), this, SLOT(Step()) );
	cSpeed=100;
	
}


KTrayNetworker2::~KTrayNetworker2()
{
	saveConfig();
	for(int i=0;i<devicesList.count() && i<10 && TrayIcons[i]!=NULL; i++)
	{
		TrayIcons[i]->IconHide();
		UserGUI[i]->hide();
	}
}









void KTrayNetworker2::Step()
{
	if(proc.networkPoll()==0)
	{
		if(Status>0)return;
		else Status=1;
	}
	else Status=0;
	
	const float *newIns=proc.getNetworkRX();
	const float *newOuts=proc.getNetworkTX();
	
	for(int i=0; i<10 && i<devicesList.count();i++)
	{
		float newIn=	newIns[i];
		float newOut=	newOuts[i];
		float rateIn=newIn-totalIn[i];
		float rateOut=newOut-totalOut[i];
		char pippo[100];
		if(totalOut[i]!=newOut)
		{
			int myscale=((newOut/deltaTX[i]-totalOut[i]/deltaTX[i]));
			if(myscale<1)
			{
				deltaTX[i]=deltaTX[i]/2;
			}
			else {
				if(myscale>9)
				{
					deltaTX[i]=deltaTX[i]*2;
					myscale=9;
				}
				else
				{
					if(lastValueTX[i]==myscale && myscale <9)
					{
						myscale=myscale+1;
						//lastValueTX[i]=myscale;
						deltaTX[i]=(newOut-totalOut[i])/myscale;
					}
				}
			}
			lastValueTX[i]=myscale;
			TrayIcons[i]->setIconTrasmit(myscale);
			totalOut[i]=newOut;
		}
		if(totalIn[i]!=newIn)
		{
			int myscale=((newIn/deltaRX[i]-totalIn[i]/deltaRX[i]));
			if(myscale<1)
			{
				deltaRX[i]=deltaRX[i]/2;
			}
			else
			{
				if(myscale>9)
				{
					deltaRX[i]=deltaRX[i]*2;
					myscale=9;
				}
				else
				{
					if(lastValueRX[i]==myscale && myscale <9)
					{
						myscale=myscale+1;
						//
						deltaRX[i]=(newIn-totalIn[i])/myscale;
					}
				}
				
			}
			lastValueRX[i]=myscale;
			TrayIcons[i]->setIconReceived(myscale);
			totalIn[i]=newIn;
		}
		if(newOut==0 and newIn==0)
		{
			TrayIcons[i]->setIconOff();
			if(hideIfOff[i])TrayIcons[i]->IconHide();
			deviceTime[i]=deviceTime[i].currentTime();
		}
		else
		{
			if(hideIfOff[i])TrayIcons[i]->IconShow();
		}
		TrayIcons[i]->Step();
		if(UserGUI[i]->isVisible())
		{
			QTime Tempo=QTime::currentTime();
			int dseconds=deviceTime[i].secsTo(Tempo);
			QTime Future(0,0,0);
			Future=Future.addSecs(dseconds);
			
			sprintf(pippo,"%d h %d m %d s (%d) ",
				Future.hour(),
				Future.minute(),
				Future.second(),
				dseconds
				);
			
			UserGUI[i]->deviceTime->setText(pippo);
			
			sprintf(pippo,"%.2f/%.2f kbyte/s",(totalIn[i]/dseconds)/1024,(totalOut[i]/dseconds)/1024);
			
			UserGUI[i]->deviceAverage->setText(pippo);
			
			
			
			UserGUI[i]->deviceIcon->setPixmap((TrayIcons[i]->getActiveIcon()));
			UserGUI[i]->setIcon(TrayIcons[i]->getBaseIcon());
			sprintf(pippo,"%.2f",newIn/scaleRX[i]);
			UserGUI[i]->deviceRX->setText(pippo);
			sprintf(pippo,"%.2f",newOut/scaleTX[i]);
			UserGUI[i]->deviceTX->setText(pippo);
			
			sprintf(pippo,"%.2f kbyte/t",(deltaRX[i]/1024)*10);
			UserGUI[i]->deviceScaleRX->setText(pippo);
			sprintf(pippo,"%.2f kbyte/t",(deltaTX[i]/1024)*10);
			UserGUI[i]->deviceScaleTX->setText(pippo);
			
			sprintf(pippo,"%.2f",(rateIn/1024));
			UserGUI[i]->statRX->setText(pippo);
			sprintf(pippo,"%.2f",(rateOut/1024));
			UserGUI[i]->statTX->setText(pippo);
		}
	}
}






void KTrayNetworker2::updateSpeed(const QString &newSpeed)
{

	cSpeed=newSpeed.toInt();
/*
	if(cSpeed->text(cSpeed->currentItem())!=newSpeed)
	{
		int i=0;
		for(; i<cSpeed->count();i++)
		{
			if(cSpeed->text(i)==newSpeed)
			{
				cSpeed->setCurrentItem(i);
			}
		}
		if(i>=cSpeed->count())
		{
			cSpeed->insertItem(newSpeed,0);
			cSpeed->setCurrentItem(0);
		}
	}
	*/
	if(ElapsedTime->isActive())
	{
		ElapsedTime->stop();
		ElapsedTime->start( cSpeed, false );
	}
}



void KTrayNetworker2::changeTheme(const QString &s, const QString &s2)
{
	//if(s!="")
	//cTheme->setText(s);
	//iTheme->setText(s2);
}


void KTrayNetworker2::readConfig(KConfig *Restoring)
{
	// check if we have a Session to restore/save
	if(Restoring!=NULL)Restore=Restoring;
	else 
	{
		if(Restore==NULL)Restore=KGlobal::config();
	}
	// We like to restore Session
	/// @todo check session config file
	if(Restore->readEntry("KTrayNetworkerWizard","yes")=="yes")
	{
		runWizard();
		return;
	}
	
	// restore Speed
	updateSpeed(Restore->readEntry("Speed", "250"));
	
	//QStringList sInstances=KGlobal::config()->groupList();
	QStringList sInstances;
	char savestring[20];
	for(int i=0;i<10;i++)
	{
		Restore->setGroup(QString::null);
		sprintf(savestring,"DeviceEnabled_%d",i);
		sInstances.append(Restore->readEntry(savestring));
	}
	for(int nInstances=0;nInstances<sInstances.count();nInstances++)
	{
		//
		Restore->setGroup(sInstances[nInstances]);
		if(Restore->readEntry("KTrayNetworkerStart")=="yes")
		{
			QString showedmsg=sInstances[nInstances];
			showedmsg=showedmsg+" ";
			showedmsg=showedmsg+i18n("will be showed on the tray");
			qWarning(showedmsg);
			
			devicesList.append(Restore->readEntry("Device", "eth0"));
			devicesName.append(Restore->readEntry("Nick", "eth0"));
			devicesTheme.append(Restore->readEntry("Theme", ""));
			devicesBase.append(Restore->readEntry("ThemeBase", ""));
			devicesType.append(Restore->readEntry("ThemeType", "no"));
			devicesScale.append(Restore->readEntry("ThemeScale", "no"));
			devicesAutoScale.append(Restore->readEntry("ScaleAuto", "yes"));
			
			devicesiLink0.append(Restore->readEntry("iLink0", ""));
			devicesiLink1.append(Restore->readEntry("iLink1", ""));
			devicesiLink2.append(Restore->readEntry("iLink2", ""));
			devicesiLink3.append(Restore->readEntry("iLink3", ""));
			devicesiLink4.append(Restore->readEntry("iLink4", ""));

						
			devicesLink0.append(Restore->readEntry("Link0", ""));
			devicesLink1.append(Restore->readEntry("Link1", ""));
			devicesLink2.append(Restore->readEntry("Link2", ""));
			devicesLink3.append(Restore->readEntry("Link3", ""));
			devicesLink4.append(Restore->readEntry("Link4", ""));

			
			hideIfOff[nInstances]=Restore->readNumEntry("hideIfOff",0);
			
			devicesLinkCmd0.append(Restore->readEntry("LinkCmd0", ""));
			devicesLinkCmd1.append(Restore->readEntry("LinkCmd1", ""));
			devicesLinkCmd2.append(Restore->readEntry("LinkCmd2", ""));
			devicesLinkCmd3.append(Restore->readEntry("LinkCmd3", ""));
			devicesLinkCmd4.append(Restore->readEntry("LinkCmd4", ""));
			
			scaleTX[nInstances]=Restore->readDoubleNumEntry("ScaleTX",(1024*1024));
			scaleRX[nInstances]=Restore->readDoubleNumEntry("ScaleRX",(1024*1024));
			
			
		}
	}
	proc.setDevicesNetwork(devicesList);
	createTrays();
}


void KTrayNetworker2::saveConfig(KConfig *Restoring)
{
	// check if we have a Session to restore/save
	if(Restoring!=NULL)Restore=Restoring;
	else 
	{
		if(Restore==NULL)Restore=KGlobal::config();
	}
	// setup default group
	Restore->setGroup(QString::null);
	// save general configurations
	Restore->writeEntry("Speed", cSpeed);
	int i;
	char savestring[20];
	for(i=0; i<devicesList.count() && i<10; i++)
	{
/*		Restore->writeEntry("Device", cDevices->text(cDevices->currentItem()));
		Restore->writeEntry("Speed", cSpeed->text(cSpeed->currentItem()));
		Restore->writeEntry("Theme", cTheme->text());
		Restore->writeEntry("ThemeBase", iTheme->text());
	
	if(bRestart->isChecked()==true)Restore->writeEntry("KTrayNetworkerStart","yes");
	else Restore->writeEntry("KTrayNetworkerStart","no");*/
		Restore->setGroup(devicesList[i]);
		Restore->writeEntry("Device", devicesList[i]);
		//Restore->writeEntry("Speed", cSpeed->text(cSpeed->currentItem()));
		Restore->writeEntry("Theme", devicesTheme[i]);
		Restore->writeEntry("Nick", devicesName[i]);
		Restore->writeEntry("ThemeBase", devicesBase[i]);
		Restore->writeEntry("ThemeType", devicesType[i]);
		Restore->writeEntry("ThemeScale", devicesScale[i]);
		if(true)Restore->writeEntry("KTrayNetworkerStart","yes");
		else Restore->writeEntry("KTrayNetworkerStart","no");
		Restore->writeEntry("ScaleAuto",devicesAutoScale[i]);
		
		Restore->writeEntry("Link0",devicesLink0[i]);
		Restore->writeEntry("Link1",devicesLink1[i]);
		Restore->writeEntry("Link2",devicesLink2[i]);
		Restore->writeEntry("Link3",devicesLink3[i]);
		Restore->writeEntry("Link4",devicesLink4[i]);
		
		Restore->writeEntry("LinkCmd0",devicesLinkCmd0[i]);
		Restore->writeEntry("LinkCmd1",devicesLinkCmd1[i]);
		Restore->writeEntry("LinkCmd2",devicesLinkCmd2[i]);
		Restore->writeEntry("LinkCmd3",devicesLinkCmd3[i]);
		Restore->writeEntry("LinkCmd4",devicesLinkCmd4[i]);
		
		Restore->writeEntry("iLink0",devicesiLink0[i]);
		Restore->writeEntry("iLink1",devicesiLink1[i]);
		Restore->writeEntry("iLink2",devicesiLink2[i]);
		Restore->writeEntry("iLink3",devicesiLink3[i]);
		Restore->writeEntry("iLink4",devicesiLink4[i]);
		
		
		Restore->writeEntry("ScaleRX",scaleRX[i]);
		Restore->writeEntry("ScaleTX", scaleTX[i]);
		Restore->writeEntry("hideIfOff", hideIfOff[i]);
		
		// setup default group
		Restore->setGroup(QString::null);
		sprintf(savestring,"DeviceEnabled_%d",i);
		Restore->writeEntry(savestring, devicesList[i]);
	}
	for(;i<10;i++)
	{
		sprintf(savestring,"DeviceEnabled_%d",i);
		Restore->writeEntry(savestring,QString::null);
	}
}


void KTrayNetworker2::workStart()
{
	for(int i=0;i<devicesList.count() && i<10 && TrayIcons[i]!=NULL; i++)
		TrayIcons[i]->IconShow();
	resetStatics();
	ElapsedTime->start(
		cSpeed,
		false);
}


void KTrayNetworker2::saveProperties(KConfig* config)
{
    saveConfig();
//    saveConfig(config);
//    saveConfig(appSessionConfig);
}


void KTrayNetworker2::readProperties(KConfig* config)
{
    readConfig();
//    readConfig(config);
}


bool KTrayNetworker2::queryClose()
{
	//qWarning("Close");
//	hide();
//	if(Status>=0)return false;
	return true;
}


bool KTrayNetworker2::queryExit()
{
	//qWarning("Exit");
	//askClose();
	return true;
}


void KTrayNetworker2::askClose()
{
	//hide();
	//Status=-1;
}


void KTrayNetworker2::updateTXScale(int newRate)
{
/*
	float Divisore=1;
	for(int pov=0; pov<newRate;pov++)Divisore=Divisore*1024;
	scaleTX[i]=Divisore;
*/
}


void KTrayNetworker2::updateRXScale(int newRate)
{
	float Divisore=1;
	for(int pov=0; pov<newRate;pov++)Divisore=Divisore*1024;
	//scaleRX=Divisore;
}




void KTrayNetworker2::runWizard()
{
	KTN_Wizard *Wizard=new KTN_Wizard(this,"appWizard",true);
	QStringList lista;
	proc.networkFindDevices(lista);
	for(int i=0;i<lista.count();i++)
	{
		Wizard->deviceAvailable->insertItem(lista[i]);
	}
	if(Wizard->exec()==QDialog::Accepted)
	{
		// write configurations options :)
		for (int i=0;i<Wizard->devicesEnabled->count();i++)
		{
			// enabled devices
			// we create a profile
			// and enable it...
			devicesList.append(Wizard->devicesEnabled->text(i));
			devicesName.append(Wizard->devicesName->item(i)->text());
			devicesTheme.append(Wizard->devicesTheme->item(i)->text());
			devicesBase.append(Wizard->devicesBase->item(i)->text());
			devicesType.append(Wizard->devicesType->item(i)->text());
			devicesScale.append(Wizard->devicesScale->item(i)->text());
			
			hideIfOff[i]=0;
			
			scaleTX[i]=1024*1024;
			scaleRX[i]=1024*1024;
			
			devicesAutoScale.append("yes");
			
			devicesLink0.append(ktnNames->getLink(Wizard->devicesEnabled->text(i),0));
			devicesLink1.append(ktnNames->getLink(Wizard->devicesEnabled->text(i),1));
			devicesLink2.append(ktnNames->getLink(Wizard->devicesEnabled->text(i),2));
			devicesLink3.append(ktnNames->getLink(Wizard->devicesEnabled->text(i),3));
			devicesLink4.append(ktnNames->getLink(Wizard->devicesEnabled->text(i),4));
			
			devicesLinkCmd0.append(ktnNames->getLinkCmd(Wizard->devicesEnabled->text(i),0));
			devicesLinkCmd1.append(ktnNames->getLinkCmd(Wizard->devicesEnabled->text(i),1));
			devicesLinkCmd2.append(ktnNames->getLinkCmd(Wizard->devicesEnabled->text(i),2));
			devicesLinkCmd3.append(ktnNames->getLinkCmd(Wizard->devicesEnabled->text(i),3));
			devicesLinkCmd4.append(ktnNames->getLinkCmd(Wizard->devicesEnabled->text(i),4));
			
			devicesiLink0.append(ktnNames->getiLinkCmd(Wizard->devicesEnabled->text(i),0));
			devicesiLink1.append(ktnNames->getiLinkCmd(Wizard->devicesEnabled->text(i),1));
			devicesiLink2.append(ktnNames->getiLinkCmd(Wizard->devicesEnabled->text(i),2));
			devicesiLink3.append(ktnNames->getiLinkCmd(Wizard->devicesEnabled->text(i),3));
			devicesiLink4.append(ktnNames->getiLinkCmd(Wizard->devicesEnabled->text(i),4));
		
		}
		proc.setDevicesNetwork(devicesList);
		createTrays();
		KGlobal::config()->writeEntry("KTrayNetworkerWizard","no");
		updateSpeed(Wizard->cfgSpeed->text(Wizard->cfgSpeed->currentItem()));
		//qWarning("ok");
		qWarning(i18n("New configurations are enabled!"));
	}
	else
	{
		if(devicesList.count()<1)close();
	}
	//delete Wizard;
}


void KTrayNetworker2::loadSession(const QString &newses)
{
	readConfig();
}


void KTrayNetworker2::createTrays()
{
	int i;
	//qWarning("createtrays");
	for(i=0;i<devicesList.count() && i<10; i++)
	{
		//qWarning(devicesList[i]);
		// now creating....
		UserGUI[i]=new KTN_User(this);
		TrayIcons[i]=new KTrayNetIcon(UserGUI[i],devicesList[i],this);
		if(TrayIcons[i]==NULL)continue;
		createTray(i);
	connect(TrayIcons[i], SIGNAL(quitSelected()), this, SLOT(close()) );
	connect(
		UserGUI[i],
		SIGNAL(deviceConfigureThis(const KTN_User *)),
		this,SLOT(userGUIConfigure(const KTN_User *)));

		/*
		connect(TrayIcons[i]->contextMenu(),
			SIGNAL(activated(int)),
			 this, SLOT(this->TrayPopupClick(int))
			  );
		*/
	}
	for(;i<10;i++)TrayIcons[i]=NULL;
}


void KTrayNetworker2::resetStatics()
{
	for(int i=0;i<10;i++)
	{
		totalIn[i]=0;
		totalOut[i]=0;
		//scaleTX[i]=1024*1024;
		//scaleRX[i]=1024*1024;
		deltaRX[i]=1024;
		deltaTX[i]=1024;
		lastValueTX[i]=0;
		lastValueRX[i]=0;
		deviceTime[i]=QTime::currentTime();
	}
}


void KTrayNetworker2::TrayPopupClick(int id)
{

}


void KTrayNetworker2::runWizardAgain()
{
	if(KMessageBox::questionYesNo (this, i18n("Restart application to Wizard Mode?"))==
		KMessageBox::Yes)
		{
			KGlobal::config()->setGroup(QString::null);
			KGlobal::config()->writeEntry("KTrayNetworkerWizard","yes");
			close();
		}
}


void KTrayNetworker2::userGUIConfigure(const KTN_User *UserG)
{
	for(int i=0;i<devicesList.count() && i<10; i++)
	{
		if(UserGUI[i]==UserG)
		{
			QString showmsg=i18n("Configuring");
			showmsg=showmsg+" ";
			showmsg=showmsg+devicesName[i];
			qWarning(showmsg);
			KTN_UserCfg *newConf=new KTN_UserCfg(this);
			// loading...
			newConf->deviceName->setText(devicesName[i]);
			newConf->deviceTheme->setPixmap(TrayIcons[i]->getActiveIcon());
			newConf->deviceThemeDirectory->setText(devicesTheme[i]);
			newConf->deviceBaseDirectory->setText(devicesBase[i]);
			newConf->deviceIcon->setPixmap(TrayIcons[i]->getBaseIcon());
			
			newConf->deviceWith->setChecked(TrayIcons[i]->isEnabledBase());
			newConf->deviceMulti->setChecked(TrayIcons[i]->isEnabledScale());
			//newConf->cfgSpeed=cSpeed;
			
			newConf->linkCmd0->setEditText(devicesLinkCmd0[i]);
			newConf->linkCmd1->setEditText(devicesLinkCmd1[i]);
			newConf->linkCmd2->setEditText(devicesLinkCmd2[i]);
			newConf->linkCmd3->setEditText(devicesLinkCmd3[i]);
			newConf->linkCmd4->setEditText(devicesLinkCmd4[i]);
			
			newConf->linkiCmd0->setEditText(devicesLink0[i]);
			newConf->linkiCmd1->setEditText(devicesLink1[i]);
			newConf->linkiCmd2->setEditText(devicesLink2[i]);
			newConf->linkiCmd3->setEditText(devicesLink3[i]);
			newConf->linkiCmd4->setEditText(devicesLink4[i]);
			
			newConf->linkIcon0->setIcon(devicesiLink0[i]);
			newConf->linkIcon1->setIcon(devicesiLink1[i]);
			newConf->linkIcon2->setIcon(devicesiLink2[i]);
			newConf->linkIcon3->setIcon(devicesiLink3[i]);
			newConf->linkIcon4->setIcon(devicesiLink4[i]);
			
			if(devicesAutoScale[i]!="yes")
			{
				// we have to disable the auto
				newConf->statAutoScale->setChecked(false);
				newConf->deviceAutoScaleTX->setEnabled(true);
				newConf->deviceAutoScaleRX->setEnabled(true);
				QString pippo;
				pippo=pippo.setNum(scaleRX[i]);
				newConf->deviceAutoScaleRX->insertItem(pippo);
				pippo=pippo.setNum(scaleTX[i]);
				newConf->deviceAutoScaleTX->insertItem(pippo);
				newConf->deviceAutoScaleRX->setCurrentItem(newConf->deviceAutoScaleRX->count());
			}
			
			if(hideIfOff[i])newConf->autoHideIfOff->setChecked(true);
			else newConf->autoHideIfOff->setChecked(false);

			int getScale=0;
			for(int thisScale=1;getScale<4;getScale++)
			{
				thisScale=thisScale*1024;
				if(thisScale>scaleTX[i])break;
			}
			newConf->statScaleTX->setCurrentItem(getScale);
			
			getScale=0;
			for(int thisScale=1;getScale<4;getScale++)
			{
				thisScale=thisScale*1024;
				if(thisScale>scaleRX[i])break;
			}
			newConf->statScaleRX->setCurrentItem(getScale);
			
			if(newConf->exec()==QDialog::Accepted)
			{

				devicesName[i]=newConf->deviceName->text();
				devicesTheme[i]=newConf->deviceThemeDirectory->text();
				devicesBase[i]=newConf->deviceBaseDirectory->text();
				if(newConf->deviceWith->isChecked()==true)devicesType[i]="yes";
				else devicesType[i]="no";
				if(newConf->deviceMulti->isChecked()==true)devicesScale[i]="yes";
				else devicesScale[i]="yes";
				
				devicesLink0[i]=newConf->linkiCmd0->currentText();
				devicesLink1[i]=newConf->linkiCmd1->currentText();
				devicesLink2[i]=newConf->linkiCmd2->currentText();
				devicesLink3[i]=newConf->linkiCmd3->currentText();
				devicesLink4[i]=newConf->linkiCmd4->currentText();
				
				devicesLinkCmd0[i]=newConf->linkCmd0->currentText();
				devicesLinkCmd1[i]=newConf->linkCmd1->currentText();
				devicesLinkCmd2[i]=newConf->linkCmd2->currentText();
				devicesLinkCmd3[i]=newConf->linkCmd3->currentText();
				devicesLinkCmd4[i]=newConf->linkCmd4->currentText();
				
				devicesiLink0[i]=newConf->linkIcon0->icon();
				devicesiLink1[i]=newConf->linkIcon1->icon();
				devicesiLink2[i]=newConf->linkIcon2->icon();
				devicesiLink3[i]=newConf->linkIcon3->icon();
				devicesiLink4[i]=newConf->linkIcon4->icon();
				if(newConf->autoHideIfOff->isChecked())hideIfOff[i]=1;
				else hideIfOff[i]=0;
				
				
				if(ElapsedTime->isActive())
				{
					ElapsedTime->stop();
					
					scaleTX[i]=1;
					for(int thisScale=newConf->statScaleTX->currentItem();thisScale>0;thisScale--)
					{
						scaleTX[i]=scaleTX[i]*1024;	
					}
	
					scaleRX[i]=1;
					for(int thisScale=newConf->statScaleRX->currentItem();thisScale>0;thisScale--)
					{
						scaleRX[i]=scaleRX[i]*1024;	
					}
					
					UserGUI[i]->deviceTXScale->setText(
						newConf->statScaleTX->text(
							newConf->statScaleTX->currentItem()));
					UserGUI[i]->deviceRXScale->setText(
						newConf->statScaleRX->text(
							newConf->statScaleRX->currentItem()));

					
					createTray(i);
					
					
					ElapsedTime->start( cSpeed, false );
				}
				else	{
					scaleTX[i]=1;
					for(int thisScale=newConf->statScaleTX->currentItem();thisScale>0;thisScale--)
					{
						scaleTX[i]=scaleTX[i]*1024;	
					}
	
					scaleRX[i]=1;
					for(int thisScale=newConf->statScaleRX->currentItem();thisScale>0;thisScale--)
					{
						scaleRX[i]=scaleRX[i]*1024;	
					}
					
					UserGUI[i]->deviceScaleTX->setText(
						newConf->statScaleTX->text(
							newConf->statScaleTX->currentItem()));
					UserGUI[i]->deviceScaleRX->setText(
						newConf->statScaleRX->text(
							newConf->statScaleRX->currentItem()));

					createTray(i);
				}
			
				qWarning(i18n("New configurations are enabled!"));
			}
			delete newConf;
		}
	}

}


void KTrayNetworker2::createTray(int i)
{
		if(devicesType[i]=="yes")TrayIcons[i]->enableBase();
		else TrayIcons[i]->enableBase(0);
		if(devicesScale[i]=="yes")TrayIcons[i]->enableScaleIcon();
		else TrayIcons[i]->enableScaleIcon(0);
		
		TrayIcons[i]->LoadTheme(devicesTheme[i],devicesBase[i]);
		TrayIcons[i]->setIconOff();
		TrayIcons[i]->Step();
		UserGUI[i]->deviceName->setText(devicesName[i]);
		TrayIcons[i]->contextMenu()->changeTitle(
		TrayIcons[i]->contextMenu()->idAt(0),
		TrayIcons[i]->getBaseIcon(),
		devicesName[i]);
		
		TrayIcons[i]->removeMenu();
		
		char pippo[50];
		UserGUI[i]->deviceIcon->setPixmap((TrayIcons[i]->getActiveIcon()));
		UserGUI[i]->deviceImage->setPixmap(TrayIcons[i]->getDeviceImage());
		UserGUI[i]->setIcon(TrayIcons[i]->getBaseIcon());
		sprintf(pippo,"%20.2f",totalIn[i]/scaleRX[i]);
		UserGUI[i]->deviceRX->setText(pippo);
		sprintf(pippo,"%20.2f",totalIn[i]/scaleTX[i]);
		UserGUI[i]->deviceTX->setText(pippo);
		

		
		if(devicesLinkCmd4[i]!="")
		{
			if(devicesLink4[i]=="separator")
			{
			}
			else
			{
			KIconLoader o;
				KPopupMenu *Menu=TrayIcons[i]->contextMenu();
				Menu->insertItem(
					QIconSet(o.loadIcon(devicesiLink4[i],KIcon::Small)),
					devicesLink4[i],
					TrayIcons[i],
					SLOT(menuAction4()),0,-1,2);
				TrayIcons[i]->linkCmd[4]=devicesLinkCmd4[i];
			}
		}

		if(devicesLinkCmd3[i]!="")
		{
			if(devicesLink3[i]=="separator")
			{
			}
			else
			{
			KIconLoader o;
				KPopupMenu *Menu=TrayIcons[i]->contextMenu();
				Menu->insertItem(
					QIconSet(o.loadIcon(devicesiLink3[i],KIcon::Small)),
					devicesLink3[i],
					TrayIcons[i],
					SLOT(menuAction3()),0,-1,2);
				TrayIcons[i]->linkCmd[3]=devicesLinkCmd3[i];
			}
		}
		if(devicesLinkCmd2[i]!="")
		{
			if(devicesLink2[i]=="separator")
			{
			}
			else
			{
			KIconLoader o;
				KPopupMenu *Menu=TrayIcons[i]->contextMenu();
				Menu->insertItem(
					QIconSet(o.loadIcon(devicesiLink2[i],KIcon::Small)),
					devicesLink2[i],
					TrayIcons[i],
					SLOT(menuAction2()),0,-1,2);
				TrayIcons[i]->linkCmd[2]=devicesLinkCmd2[i];
			}
		}
		if(devicesLinkCmd1[i]!="")
		{
			if(devicesLink1[i]=="separator")
			{
			}
			else
			{
			KIconLoader o;
				KPopupMenu *Menu=TrayIcons[i]->contextMenu();
				Menu->insertItem(
					QIconSet(o.loadIcon(devicesiLink1[i],KIcon::Small)),
					devicesLink1[i], 
					TrayIcons[i],
					SLOT(menuAction1()),0,-1,2);
				TrayIcons[i]->linkCmd[1]=devicesLinkCmd1[i];
			}
		}
		
		if(devicesLinkCmd0[i]!="")
		{
			if(devicesLink0[i]=="separator")
			{
			}
			else
			{
			KIconLoader o;
				KPopupMenu *Menu=TrayIcons[i]->contextMenu();
				Menu->insertItem(
					QIconSet(o.loadIcon(devicesiLink0[i],KIcon::Small)),
					devicesLink0[i], 
					TrayIcons[i],
					SLOT(menuAction0()),0,-1,2);
				TrayIcons[i]->linkCmd[0]=devicesLinkCmd0[i];
			}
		}

}









#include "ktraynetworker2.moc"
